# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['pcmf']

package_data = \
{'': ['*']}

install_requires = \
['tensorflow>=2.5.0,<3.0.0']

setup_kwargs = {
    'name': 'pcmf',
    'version': '0.1.4',
    'description': 'PCMF is a Python package of Positive Collective Matrix Factorization(PCMF). PCMF is a model that combines the interpretability of NMF and the extensibility of CMF.',
    'long_description': '![](https://raw.githubusercontent.com/N-YS-KK/PCMF/main/images/PCMF_logo.PNG) \n\n# Positive Collective Matrix Factorization (PCMF)\nWe propose Positive Collective Matrix Factorization (PCMF). PCMF is a model that combines the interpretability of NMF and the extensibility of CMF.\n\n# Description of PCMF\n\n## Problem setting\nWhen there are two relational data (matrix ![](https://latex.codecogs.com/gif.latex?X), ![](https://latex.codecogs.com/gif.latex?Y)) that share one set, and you want to predict the relational data (matrix ![](https://latex.codecogs.com/gif.latex?\\hat{X}), ![](https://latex.codecogs.com/gif.latex?\\hat{Y})) and extract feature representations (matrix ![](https://latex.codecogs.com/gif.latex?U), ![](https://latex.codecogs.com/gif.latex?V^T), ![](https://latex.codecogs.com/gif.latex?Z^T)) at the same time.\n\n### Example\n- Two relational data (matrix ![](https://latex.codecogs.com/gif.latex?X), ![](https://latex.codecogs.com/gif.latex?Y))\n\n![](https://latex.codecogs.com/gif.latex?X): Patient-disease matrix  \n![](https://latex.codecogs.com/gif.latex?Y): Patient-patient attribute matrix  \n\nAt this time, the patient set is shared.\n\n![](https://raw.githubusercontent.com/N-YS-KK/PCMF/main/images/two_relational_data.PNG) \n\n- Feature representations\n\n![](https://latex.codecogs.com/gif.latex?U): Patient matrix  \n![](https://latex.codecogs.com/gif.latex?V^T): Disease matrix  \n![](https://latex.codecogs.com/gif.latex?Z^T): Patient attributes matrix\n\n![](https://raw.githubusercontent.com/N-YS-KK/PCMF/main/images/feature_representations.PNG) \n\n## Detailed description of PCMF\nPCMF is a model that combines the advantages of NMF, "interpretability," and the advantages of CMF, "extensibility." Specifically, for each matrix, interpretability is achieved by converting the elements of the matrix into positive values using a softplus function. The backpropagation method is used as the learning method.\n\nThe illustration of PCMF is as follows.\n\n![](https://raw.githubusercontent.com/N-YS-KK/PCMF/main/images/PCMF.PNG) \n\n### Example  \nThis will be described using the previous example.\n\n- The patient matrix ![](https://latex.codecogs.com/gif.latex?U^T) with the softplus function applied is the patient matrix ![](https://latex.codecogs.com/gif.latex?U^{\'T}).  \n- The disease matrix ![](https://latex.codecogs.com/gif.latex?V^T) with the softplus function applied is the disease matrix ![](https://latex.codecogs.com/gif.latex?V^{\'T}).  \n- The patient attribute matrix ![](https://latex.codecogs.com/gif.latex?Z^T) with the softplus function applied is the patient attribute matrix ![](https://latex.codecogs.com/gif.latex?Z^{\'T}).  \n- Applying the link function ![](https://latex.codecogs.com/gif.latex?f_1) to the product of the patient matrix ![](https://latex.codecogs.com/gif.latex?U^{\'}) and the disease matrix ![](https://latex.codecogs.com/gif.latex?V^{\'T}) yields the predicted value of the patient-disease matrix ![](https://latex.codecogs.com/gif.latex?X^{\'}).  \n- Applying the link function ![](https://latex.codecogs.com/gif.latex?f_2) to the product of the patient matrix ![](https://latex.codecogs.com/gif.latex?U^{\'}) and the patient attributes ![](https://latex.codecogs.com/gif.latex?Z^{\'T}) yields the predicted value of the patient-patient attributes matrix ![](https://latex.codecogs.com/gif.latex?Y^{\'}).\n\n### Softplus function\n![](https://latex.codecogs.com/gif.latex?\\zeta(x)=\\mathrm{log}(1+e^x))\n\nThe softplus function is a narrowly monotonically increasing function that takes a positive value for all real numbers ![](https://latex.codecogs.com/gif.latex?x\\in\\mathrm{R}). It is applied to each element of the matrix, and it is assumed that a matrix of the same size is output.\n\n### Link function\nNote that due to the influence of the Softplus function, the input value of the PCMF link function is always positive. Choose a link function depending on the nature and purpose of the matrix you are predicting.\n\n- When the value of the matrix to be predicted is (-∞, ∞)  \nLog function.\n\n- When the value of the matrix to be predicted is (0, ∞)  \nLinear function.\n\n- When the value of the matrix to be predicted is {0,1}  \nSigmoid function. (Since the output value of the sigmoid function is 0.5 or more when the input value is 0 or more, the operation of subtracting a common positive number uniformly for the input is performed.)\n\n### Feature representations analysis\nFeature representations analysis can be performed by analyzing the feature representations (matrix ![](https://latex.codecogs.com/gif.latex?U), ![](https://latex.codecogs.com/gif.latex?V^T), ![](https://latex.codecogs.com/gif.latex?Z^T)) extracted by PCMF. (Note that PCMF outputs the matrix ![](https://latex.codecogs.com/gif.latex?U^{\'}), ![](https://latex.codecogs.com/gif.latex?V^{\'T}), ![](https://latex.codecogs.com/gif.latex?Z^{\'T})), which is the format to which the softplus function is applied, as the final output.)\n\n## CMF and NMF (reference)\nNon-Negative Matrix Factorization (NMF) and Collective matrix Factorization (CMF) exist as methods of matrix factorization. The features of each are as follows.\n\n### Non-Negative Matrix Factorization（NMF）[1][2]\nPredict the original matrix by the product of two nonnegative matrices.\n\n- Advantages  \nSince it is non-negative, a highly interpretable feature representation can be obtained.\n\n- Disadvantages  \nLow extensibility because multiple relationships cannot be considered.\n\n### Collective matrix Factorization（CMF）[3]\nThis is a method of factoring two or more relational data (matrix) at the same time when a set has multiple relations.\n\n- Advantages  \nIn addition to being able to consider multiple relationships, flexible output is possible (link function), so it is highly extensible.\n\n- Disadvantages  \nThe interpretability is low because positive and negative values appear in the elements of the matrix.\n\n# Installation\nYou can get PCMF from PyPI. Our project in PyPI is [here](https://pypi.org/project/pcmf/). \n```bash\npip install pcmf\n```\n\n# Usage\nFor more detail, please read `examples/How_to_use_PCMF.ipynb`. If it doesn\'t render at all in github, please click [here](https://nbviewer.jupyter.org/github/N-YS-KK/PCMF/blob/main/examples/How_to_use_PCMF.ipynb).\n\n## Training\n\n```python\ncmf = Positive_Collective_Matrix_Factorization(X, Y, alpha=0.5, d_hidden=12, lamda=0.1)\ncmf.train(link_X = \'sigmoid\', link_Y = \'sigmoid\', \n          weight_X = None, weight_Y =wY, \n          optim_steps=501, verbose=50, lr=0.05)\n```\n\n# License\nMIT Licence\n\n# Citation\nYou may use our package(PCMF) under MIT License. If you use this program in your research then please cite:\n\n**PCMF Package**\n```bash\n@misc{sumiya2021pcmf,\n  author = {Yuki, Sumiya and Kensho, Kondo and Kazuhide, Nakata},\n  title = {PCMF},\n  year = {2021},\n  publisher = {GitHub},\n  journal = {GitHub repository},\n  howpublished = {https://github.com/N-YS-KK/PCMF}\n}\n```\n\n**PCMF Paper**[ [link](https://www.jstage.jst.go.jp/article/pjsai/JSAI2021/0/JSAI2021_2G3GS2e03/_pdf/-char/ja) ](Japanese)\n```bash\n@article{sumiya2021pcmf,\n  title={Patient Disease Prediction and Medical Feature Extraction using Matrix Factorization},\n  author={Yuki, Sumiya and Atsuyoshi, Matsuda and Kenji, Araki and Kazuhide, Nakata},\n  journal={The Japanese Society for Artifical Intelligence},\n  year={2021}\n}\n```\n\n# Reference\n[5] [6] [7] are used in the code.  \n\n[1] Daniel D. Lee and H. Sebastian Seung. “Learning the parts of objects by non-negative matrix factorization.” Nature 401.6755 (1999): 788-791.\n\n[2] Daniel D. Lee and H. Sebastian Seung. “Algorithms for non-negative matrix factorization.” Advances in neural information processing systems 13 (2001): 556-562.\n\n[3] Ajit P. Singh and Geoffrey J. Gordon. Relational learning via collective matrix factorization. Proceedings of the 14th ACM SIGKDD International Conference on Knowledge Discovery and Data Mining: 650-658, 2008.\n\n[4] Yuki Sumiya, Kazuhide Nakata, Atsuyoshi Matsuda, Kenji Araki. "Patient Disease Prediction and Relational Data Mining using Matrix Factorization." The 40th Joint Conference on Medical Informatics, 2020.\n\n[5] David E. Rumelhart, Geoffrey E. Hinton and Ronald J. Williams. “Learning representations by back-propagating errors.” Nature 323.6088 (1986): 533-536\n\n[6] Diederik P. Kingma and Jimmy Ba. “Adam: A method for stochastic optimization.” arXiv preprint arXiv:1412.6980 (2014).\n\n[7] Martín Abadi, Ashish Agarwal, Paul Barham, Eugene Brevdo, Zhifeng Chen, Craig Citro, Greg S. Corrado, Andy Davis, Jeffrey Dean, Matthieu Devin, Sanjay Ghemawat, Ian Goodfel-low, Andrew Harp, Geoffrey Irving, Michael Isard, Yangqing Jia, Rafal Jozefowicz, Lukasz Kaiser, Manjunath Kudlur, Josh Levenberg, Dan Mane, Rajat Monga, Sherry Moore, Derek Murray, Chris Olah, Mike Schuster, Jonathon Shlens, Benoit Steiner, Ilya Sutskever, Kunal Talwar, Paul Tucker, Vincent Vanhoucke, Vijay Vasudevan, Fernanda Viegas, Oriol Vinyals, Pete Warden, Martin Wattenberg, Martin Wicke, Yuan Yu and Xiaoqiang Zheng. “Tensor-flow: Large-scale machine learning on heterogeneous distributed systems.” arXiv preprint arXiv:1603.04467 (2016)',
    'author': 'Y. Sumiya',
    'author_email': 'y.sumiya.1031@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/N-YS-KK',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<3.9',
}


setup(**setup_kwargs)
