# flake8: noqa: E501
class Const(object):
    def __init__(self):
        self.header = """<?xml version="1.0" encoding="utf-8"?>\n<gpx creator="jujumini" version="1.1" xsi:schemaLocation="http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd http://www.garmin.com/xmlschemas/WaypointExtension/v1 http://www8.garmin.com/xmlschemas/WaypointExtensionv1.xsd http://www.garmin.com/xmlschemas/TrackPointExtension/v1 http://www.garmin.com/xmlschemas/TrackPointExtensionv1.xsd http://www.garmin.com/xmlschemas/GpxExtensions/v3 http://www8.garmin.com/xmlschemas/GpxExtensionsv3.xsd http://www.garmin.com/xmlschemas/ActivityExtension/v1 http://www8.garmin.com/xmlschemas/ActivityExtensionv1.xsd http://www.garmin.com/xmlschemas/AdventuresExtensions/v1 http://www8.garmin.com/xmlschemas/AdventuresExtensionv1.xsd http://www.garmin.com/xmlschemas/PressureExtension/v1 http://www.garmin.com/xmlschemas/PressureExtensionv1.xsd http://www.garmin.com/xmlschemas/TripExtensions/v1 http://www.garmin.com/xmlschemas/TripExtensionsv1.xsd http://www.garmin.com/xmlschemas/TripMetaDataExtensions/v1 http://www.garmin.com/xmlschemas/TripMetaDataExtensionsv1.xsd http://www.garmin.com/xmlschemas/ViaPointTransportationModeExtensions/v1 http://www.garmin.com/xmlschemas/ViaPointTransportationModeExtensionsv1.xsd http://www.garmin.com/xmlschemas/CreationTimeExtension/v1 http://www.garmin.com/xmlschemas/CreationTimeExtensionsv1.xsd http://www.garmin.com/xmlschemas/AccelerationExtension/v1 http://www.garmin.com/xmlschemas/AccelerationExtensionv1.xsd http://www.garmin.com/xmlschemas/PowerExtension/v1 http://www.garmin.com/xmlschemas/PowerExtensionv1.xsd http://www.garmin.com/xmlschemas/VideoExtension/v1 http://www.garmin.com/xmlschemas/VideoExtensionv1.xsd" xmlns="http://www.topografix.com/GPX/1/1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:wptx1="http://www.garmin.com/xmlschemas/WaypointExtension/v1" xmlns:gpxtrx="http://www.garmin.com/xmlschemas/GpxExtensions/v3" xmlns:gpxtpx="http://www.garmin.com/xmlschemas/TrackPointExtension/v1" xmlns:gpxx="http://www.garmin.com/xmlschemas/GpxExtensions/v3" xmlns:trp="http://www.garmin.com/xmlschemas/TripExtensions/v1" xmlns:adv="http://www.garmin.com/xmlschemas/AdventuresExtensions/v1" xmlns:prs="http://www.garmin.com/xmlschemas/PressureExtension/v1" xmlns:tmd="http://www.garmin.com/xmlschemas/TripMetaDataExtensions/v1" xmlns:vptm="http://www.garmin.com/xmlschemas/ViaPointTransportationModeExtensions/v1" xmlns:ctx="http://www.garmin.com/xmlschemas/CreationTimeExtension/v1" xmlns:gpxacc="http://www.garmin.com/xmlschemas/AccelerationExtension/v1" xmlns:gpxpx="http://www.garmin.com/xmlschemas/PowerExtension/v1" xmlns:vidx1="http://www.garmin.com/xmlschemas/VideoExtension/v1">\n\n"""
        self.metadata = """<metadata>
        <link href="http://www.garmin.com">
          <text>Garmin International</text>
        </link>
        <time>{time}</time>
      </metadata>\n\n"""
        self.waypoint = """  <wpt lat = "{lat}" lon = "{lon}">\n    <name>{name}</name>\n    <desc>{desc}</desc>\n    <sym>{mark}, {color}</sym>\n    <type>user</type>\n  </wpt>\n\n"""
        self.route = """    <rtept lat="{lat}" lon="{lon}">\n      <name>{name}</name>\n      <desc>{desc}</desc>\n      <sym>{mark}, {color}</sym>\n    </rtept>\n\n"""
        self.routeStart = """  <rte>\n    <name>{name}</name>\n"""
        self.routeEnd = """  </rte>\n\n"""
        self.footer = "</gpx>"
        self.colors = ["Black", "Red", "Yellow", "Green", "Brown", "Purple", "Blue"]
        self.marks = {
            "@q": "Pin",
            "@r": "Flag",
            "@s": "Flag",
            "@t": "Fishing Area",
            "@u": "Fishing Area",
            "@v": "Fishing Area",
            "@w": "Shipwreck",
            "@x": "Anchor",
            "@y": "Skull And Crossbones",
            "@z": "Flag",
        }
        self.defaultMark = "@q"
        self.defaultColor = 0
        self.defaultColorText = "Blue"
