import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a team on Rollbar.
 *
 * @schema CfnTeamProps
 */
export interface CfnTeamProps {
    /**
     * Name of the team. Max length 32 characters.
     *
     * @schema CfnTeamProps#Name
     */
    readonly name: string;
    /**
     * Can be standard, light, or view.
     *
     * @schema CfnTeamProps#AccessLevel
     */
    readonly accessLevel: CfnTeamPropsAccessLevel;
}
/**
 * Converts an object of type 'CfnTeamProps' to JSON representation.
 */
export declare function toJson_CfnTeamProps(obj: CfnTeamProps | undefined): Record<string, any> | undefined;
/**
 * Can be standard, light, or view.
 *
 * @schema CfnTeamPropsAccessLevel
 */
export declare enum CfnTeamPropsAccessLevel {
    /** standard */
    STANDARD = "standard",
    /** light */
    LIGHT = "light",
    /** view */
    VIEW = "view"
}
/**
 * A CloudFormation `Rollbar::Teams::Team`
 *
 * @cloudformationResource Rollbar::Teams::Team
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-rollbar-resource-providers.git
 */
export declare class CfnTeam extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Rollbar::Teams::Team";
    /**
     * Resource props.
     */
    readonly props: CfnTeamProps;
    /**
     * Attribute `Rollbar::Teams::Team.Id`
     * @link https://github.com/aws-ia/cloudformation-rollbar-resource-providers.git
     */
    readonly attrId: number;
    /**
     * Attribute `Rollbar::Teams::Team.AccountId`
     * @link https://github.com/aws-ia/cloudformation-rollbar-resource-providers.git
     */
    readonly attrAccountId: number;
    /**
     * Create a new `Rollbar::Teams::Team`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnTeamProps);
}
