import string
import random


class GreinLoaderUtils:
    def __init__(self, gse_id: str = None):
        """Initialize a new utils function. If gse_id is set, this injected in the
           respective data values.

        :param gse_id: The GSE id to load, defaults to None
        :type gse_id: str, optional
        """
        self.gse_id = gse_id

    def ui_init_parameter(self):
        return '["1#0|m|{\\"method\\":\\"init\\",\\"data\\":{\\"modalheatmap_regsig\\":false,\\"grin\\":\\"datasets\\",\\"tab2\\":\\"summary\\",\\"preplots\\":\\"corr\\",\\"heatvis\\":\\"static\\",\\"fir_or_scr\\":\\"fitinscreen\\",\\"pcap\\":\\"pca2\\",\\"heatmodal_regsig\\":\\"static_mod_regsig\\",\\"fit_or_scr_mod_regsig\\":\\"fitinscreen_mod_regsig\\",\\"signature\\":\\"create_sig\\",\\"cr_reg_sig\\":\\"meta_reg\\",\\"sigtab\\":\\"meta_powers\\",\\"process\\":\\"log\\",\\"user_geo_bs:shiny.action\\":0,\\"start_process:shiny.action\\":0,\\"sample_ont_ser_bs:shiny.action\\":0,\\"process_log_bs:shiny.action\\":0,\\"process_log:shiny.action\\":0,\\"load_counts:shiny.action\\":0,\\"draw_heat:shiny.action\\":0,\\"draw_heatscr:shiny.action\\":0,\\"draw_heatint:shiny.action\\":0,\\"draw_pca:shiny.action\\":0,\\"draw_pca3:shiny.action\\":0,\\"draw_tsne2:shiny.action\\":0,\\"draw_tsne3:shiny.action\\":0,\\"heat_stat_bs:shiny.action\\":0,\\"heat_int_bs:shiny.action\\":0,\\"heatmap_mod_regsig:shiny.action\\":0,\\"draw_heatfit_regsig:shiny.action\\":0,\\"draw_heatscr_regsig:shiny.action\\":0,\\"draw_heatint_regsig:shiny.action\\":0,\\"draw_ma_regsig:shiny.action\\":0,\\"gen_pow_mod_btn:shiny.action\\":0,\\"search_mod_bs:shiny.action\\":0,\\"de_sig_bs:shiny.action\\":0,\\"de_sig_bs2:shiny.action\\":0,\\"power_bs:shiny.action\\":0,\\"detect_bs:shiny.action\\":0,\\"search_gene_bs:shiny.action\\":0,\\"show_log:shiny.action\\":0,\\"counts_choice\\":\\"Raw\\",\\"download_type_counts\\":\\"Gene level\\",\\"download_type_fit\\":\\"png\\",\\"download_type_scr\\":\\"png\\",\\"sub_prop_tsne2\\":\\"No\\",\\"sub_sam_pca\\":\\"No\\",\\"fact_choice\\":\\"All samples\\",\\"sub_sam\\":\\"No\\",\\"download_type_fit_mod_regsig\\":\\"png\\",\\"download_type_scr_mod_regsig\\":\\"png\\",\\"gen_det_mod_type\\":\\"All\\",\\"pow_fact_choice\\":\\"All samples\\",\\"pow_sub_sample2\\":\\"No\\",\\"sample_ont_ser\\":[],\\"geo_next_lp\\":\\"\\",\\"geo_current\\":\\"\\",\\"geo_next\\":\\"\\",\\"user_geo\\":\\"\\",\\"search_mod_gene\\":\\"\\",\\"search_gene\\":\\"\\",\\".clientdata_output_samplesize_den_width\\":440,\\".clientdata_output_samplesize_den_height\\":255,\\".clientdata_output_study_stat_width\\":575,\\".clientdata_output_study_stat_height\\":255,\\".clientdata_output_sample_stat_width\\":595,\\".clientdata_output_sample_stat_height\\":255,\\".clientdata_output_stepbystep_hidden\\":true,\\".clientdata_output_samplesize_den_hidden\\":false,\\".clientdata_output_study_stat_hidden\\":false,\\".clientdata_output_sample_stat_hidden\\":false,\\".clientdata_output_warn_hidden\\":false,\\".clientdata_output_warn2_hidden\\":false,\\".clientdata_output_warn3_hidden\\":false,\\".clientdata_output_warn4_hidden\\":false,\\".clientdata_output_warn5_hidden\\":false,\\".clientdata_output_warn_ont_hidden\\":false,\\".clientdata_output_warn_ont2_hidden\\":false,\\".clientdata_output_datatable_hidden\\":false,\\".clientdata_output_geo_acc_ui_hidden\\":true,\\".clientdata_output_metadata_column_hidden\\":true,\\".clientdata_output_full_metacol_hidden\\":true,\\".clientdata_output_downloadmeta_hidden\\":true,\\".clientdata_output_counts_sample_ui_hidden\\":true,\\".clientdata_output_downloadcounts_hidden\\":true,\\".clientdata_output_cor_sample_ui_hidden\\":true,\\".clientdata_output_show_grp_ui_hidden\\":true,\\".clientdata_output_corr_prop_hidden\\":true,\\".clientdata_output_draw_cor_ui_hidden\\":true,\\".clientdata_output_dens_sample_ui_hidden\\":true,\\".clientdata_output_draw_dens_ui_hidden\\":true,\\".clientdata_output_heat_prop_hidden\\":true,\\".clientdata_output_cluster_meth_hidden\\":true,\\".clientdata_output_cluster_genes_hidden\\":true,\\".clientdata_output_download_hidden\\":true,\\".clientdata_output_downloadscr_hidden\\":true,\\".clientdata_output_pca_prop_hidden\\":true,\\".clientdata_output_subprop2_ui_hidden\\":true,\\".clientdata_output_subprop_ui_hidden\\":true,\\".clientdata_output_legendplot_hidden\\":true,\\".clientdata_output_geo_summary_hidden\\":true,\\".clientdata_output_metadata_hidden\\":true,\\".clientdata_output_metadata_full_hidden\\":true,\\".clientdata_output_ontology_hidden\\":true,\\".clientdata_output_counts_warn_hidden\\":true,\\".clientdata_output_counts_text_hidden\\":true,\\".clientdata_output_counts_hidden\\":true,\\".clientdata_output_boxplot_counts_hidden\\":true,\\".clientdata_output_downloadqc_hidden\\":true,\\".clientdata_output_multiqc_hidden\\":true,\\".clientdata_output_corr_warn_hidden\\":true,\\".clientdata_output_corplot_ui_hidden\\":true,\\".clientdata_output_dens_warn_hidden\\":true,\\".clientdata_output_densityp_hidden\\":true,\\".clientdata_output_heat_warn_hidden\\":true,\\".clientdata_output_HeatStatic_hidden\\":true,\\".clientdata_output_HeatStaticscr_hidden\\":true,\\".clientdata_output_iheatmapui_hidden\\":true,\\".clientdata_output_downloadPCA2D_hidden\\":true,\\".clientdata_output_p2D_ui_hidden\\":true,\\".clientdata_output_pca_sam_warn_hidden\\":true,\\".clientdata_output_pca3Dplot_ui_hidden\\":true,\\".clientdata_output_t2Dplot_ui_hidden\\":true,\\".clientdata_output_tsne3Dplot_ui_hidden\\":true,\\".clientdata_output_geo_acc2_ui_hidden\\":true,\\".clientdata_output_metadata_analysis_hidden\\":true,\\".clientdata_output_group1_hidden\\":true,\\".clientdata_output_group2_hidden\\":true,\\".clientdata_output_ana_type_hidden\\":true,\\".clientdata_output_cov_hidden\\":true,\\".clientdata_output_meta_ui_hidden\\":true,\\".clientdata_output_gen_reg_sig_ui_hidden\\":true,\\".clientdata_output_heat_typeui_mod_regsig_hidden\\":true,\\".clientdata_output_heat_prop_mod_regsig_hidden\\":true,\\".clientdata_output_cluster_meth_mod_regsig_hidden\\":true,\\".clientdata_output_cluster_genes_mod_regsig_hidden\\":true,\\".clientdata_output_downloadfit_mod_regsig_hidden\\":true,\\".clientdata_output_downloadscr_mod_regsig_hidden\\":true,\\".clientdata_output_fdrui_mod_regsig_hidden\\":true,\\".clientdata_output_effect_ma_mod_ui_hidden\\":true,\\".clientdata_output_power_mod_ui_hidden\\":true,\\".clientdata_output_alpha_mod_ui_hidden\\":true,\\".clientdata_output_fitscreen_mod_regsig_hidden\\":true,\\".clientdata_output_scroll_mod_regsig_hidden\\":true,\\".clientdata_output_iheatmapui_mod_regsig_hidden\\":true,\\".clientdata_output_downloadMA_hidden\\":true,\\".clientdata_output_maplotui_mod_regsig_hidden\\":true,\\".clientdata_output_ma_mod_text_hidden\\":true,\\".clientdata_output_maplot_clickedpoints_hidden\\":true,\\".clientdata_output_gene_mod_warn_hidden\\":true,\\".clientdata_output_gene_sym_mod_warn_hidden\\":true,\\".clientdata_output_gene_sym_mod_green_hidden\\":true,\\".clientdata_output_det_mod_label_hidden\\":true,\\".clientdata_output_gen_det_mod_dl_hidden\\":true,\\".clientdata_output_plotdetui_mod_regsig_hidden\\":true,\\".clientdata_output_det_mod_text_hidden\\":true,\\".clientdata_output_det_mod_gene_clickedpoints_hidden\\":true,\\".clientdata_output_downloadsigdata_hidden\\":true,\\".clientdata_output_ui_reg_ilincs_option_hidden\\":true,\\".clientdata_output_power_sig_ui_hidden\\":true,\\".clientdata_output_alpha_sig_ui_hidden\\":true,\\".clientdata_output_dynamiclink_hidden\\":true,\\".clientdata_output_prop_power_ui_hidden\\":true,\\".clientdata_output_group1_pow_ui_hidden\\":true,\\".clientdata_output_group2_pow_ui_hidden\\":true,\\".clientdata_output_meta_pow_ui_hidden\\":true,\\".clientdata_output_gen_meta_pow_ui_hidden\\":true,\\".clientdata_output_samples1_hidden\\":true,\\".clientdata_output_samples2_hidden\\":true,\\".clientdata_output_effect_hidden\\":true,\\".clientdata_output_alpha_hidden\\":true,\\".clientdata_output_depth_ui_hidden\\":true,\\".clientdata_output_power_ui_hidden\\":true,\\".clientdata_output_det_effect_ui_hidden\\":true,\\".clientdata_output_fdr_ui_hidden\\":true,\\".clientdata_output_prop_detect_ui_hidden\\":true,\\".clientdata_output_group1_detect_ui_hidden\\":true,\\".clientdata_output_group2_detect_ui_hidden\\":true,\\".clientdata_output_gen_pow_btn_ui_hidden\\":true,\\".clientdata_output_gen_detect_btn_ui_hidden\\":true,\\".clientdata_output_sig1_warn_hidden\\":true,\\".clientdata_output_rank_warn_hidden\\":true,\\".clientdata_output_level_warn_hidden\\":true,\\".clientdata_output_sig_meta_hidden\\":true,\\".clientdata_output_sig_data_hidden\\":true,\\".clientdata_output_meta_pow_txt_hidden\\":true,\\".clientdata_output_meta_power_warn_hidden\\":true,\\".clientdata_output_metadata_pow_table_hidden\\":true,\\".clientdata_output_power1_warn_hidden\\":true,\\".clientdata_output_powerplot_hidden\\":true,\\".clientdata_output_gene_warn_hidden\\":true,\\".clientdata_output_gene_sym_warn_hidden\\":true,\\".clientdata_output_gene_sym_green_hidden\\":true,\\".clientdata_output_power2_warn_hidden\\":true,\\".clientdata_output_detect_gene_ui_hidden\\":true,\\".clientdata_output_gen_det_text_hidden\\":true,\\".clientdata_output_detect_gene_tab_hidden\\":true,\\".clientdata_output_steps_hidden\\":true,\\".clientdata_output_process_log_text_hidden\\":true,\\".clientdata_pixelratio\\":1,\\".clientdata_url_protocol\\":\\"http:\\",\\".clientdata_url_hostname\\":\\"www.ilincs.org\\",\\".clientdata_url_port\\":\\"\\",\\".clientdata_url_pathname\\":\\"/apps/grein/\\",\\".clientdata_url_search\\":\\"?gse=' + self.gse_id + '\\",\\".clientdata_url_hash_initial\\":\\"\\",\\".clientdata_url_hash\\":\\"\\",\\".clientdata_singletons\\":\\"991a9dee8b6f41039f0d48e0f3cb481dfef69248,abbc5191535f7e95ba1254171676097ac26b5edc,2581d36bc09732ee052ca2bcc5a7ae809019206f,2936dd0d01d731dd90358375bdaef9c44ce3b494,603e796bcfc2ab3685167d58c426f64c15a95192\\",\\".clientdata_allowDataUriScheme\\":true}}"]'

    def method_update_parameter(self):
        return '["2#0|m|{\\"method\\":\\"update\\",\\"data\\":{\\".clientdata_output_warn_hidden\\":true,\\".clientdata_output_warn3_hidden\\":true,\\".clientdata_output_warn4_hidden\\":true,\\".clientdata_output_warn5_hidden\\":true}}"]'

    def client_parameter(self):
        return '["3#0|m|{\\"method\\":\\"update\\",\\"data\\":{\\".clientValue-default-plotlyCrosstalkOpts\\":{\\"on\\":\\"plotly_click\\",\\"persistent\\":false,\\"dynamic\\":false,\\"selectize\\":false,\\"opacityDim\\":0.2,\\"selected\\":{\\"opacity\\":1},\\"debounce\\":0,\\"color\\":[]},\\"datatable_rows_current\\":[],\\"datatable_rows_all\\":[],\\"datatable_state\\":null,\\"datatable_search\\":\\"\\",\\"datatable_search_columns\\":[\\"\\",\\"\\",\\"\\",\\"\\",\\"\\"],\\"datatable_cell_clicked\\":{},\\"geo_next_lp\\":\\"GSE103221\\",\\"grin\\":\\"explore\\",\\"plotly_afterplot-A\\":\\"\\\\\\"sample_stat\\\\\\"\\",\\".clientdata_output_samplesize_den_hidden\\":true,\\".clientdata_output_study_stat_hidden\\":true,\\".clientdata_output_sample_stat_hidden\\":true,\\".clientdata_output_warn2_hidden\\":true,\\".clientdata_output_warn_ont_hidden\\":true,\\".clientdata_output_warn_ont2_hidden\\":true,\\".clientdata_output_datatable_hidden\\":true,\\".clientdata_output_geo_acc_ui_hidden\\":false,\\".clientdata_output_cor_sample_ui_hidden\\":false,\\".clientdata_output_show_grp_ui_hidden\\":false,\\".clientdata_output_corr_prop_hidden\\":false,\\".clientdata_output_draw_cor_ui_hidden\\":false,\\".clientdata_output_geo_summary_hidden\\":false}}"]'

    def stream_dataset_parameter(self):
        return '["7#0|m|{\\"method\\":\\"update\\",\\"data\\":{\\"geo_acc\\":\\"' + self.gse_id + '\\"}}"]'

    def description_formdata(self):
        return "draw=1&columns[0][data]=0&columns[0][name]&columns[0][searchable]=true&columns[0][orderable]=false&columns[0][search][value]&columns[0][search][regex]=false&columns[1][data]=1&columns[1][name]&columns[1][searchable]=true&columns[1][orderable]=true&columns[1][search][value]&columns[1][search][regex]=false&start=0&length=10&search[value]&search[regex]=false&search[caseInsensitive]=true&search[smart]=true&escape=false"

    def metadata_labels_parameter(self):
        return '["B#0|m|{\\"method\\":\\"update\\",\\"data\\":{\\"tab2\\":\\"metadata\\",\\".clientdata_output_geo_summary_hidden\\":true,\\".clientdata_output_metadata_hidden\\":false,\\".clientdata_output_metadata_full_hidden\\":false,\\".clientdata_output_ontology_hidden\\":false}}"]'

    def count_matrix_parameter(self):
        return '["18#0|m|{\\"method\\":\\"update\\",\\"data\\":{\\"counts_rows_selected\\":[],\\"counts_rows_current\\":[],\\"counts_rows_all\\":[],\\"counts_state\\":null,\\"counts_search\\":\\"\\",\\"counts_cell_clicked\\":{},\\".clientdata_output_downloadcounts_hidden\\":false}}"]'

    def raw_form_start(self):
        return "draw=1&columns%5B0%5D%5Bdata%5D=0&columns%5B0%5D%5Bname%5D=&columns%5B0%5D%5Bsearchable%5D=true&columns%5B0%5D%5Borderable%5D=false&columns%5B0%5D%5Bsearch%5D%5Bvalue%5D=&columns%5B0%5D%5Bsearch%5D%5Bregex%5D=false"

    def raw_form_end(self):
        return "start=0&length=9&search%5Bvalue%5D=&search%5Bregex%5D=false&search%5BcaseInsensitive%5D=true&search%5Bsmart%5D=true&escape=true"

    def raw_form_column(self, n):
        return f"&columns%5B{n}%5D%5Bdata%5D={n}&columns%5B{n}%5D%5Bname%5D=&columns%5B{n}%5D%5Bsearchable%5D=true&columns%5B{n}%5D%5Borderable%5D=true&columns%5B{n}%5D%5Bsearch%5D%5Bvalue%5D=&columns%5B{n}%5D%5Bsearch%5D%5Bregex%5D=false&"

    def overview_streaming(self):
        return '["1#0|m|{\\"method\\":\\"init\\",\\"data\\":{\\"modalheatmap_regsig\\":false,\\"grin\\":\\"datasets\\",\\"tab2\\":\\"summary\\",\\"preplots\\":\\"corr\\",\\"heatvis\\":\\"static\\",\\"fir_or_scr\\":\\"fitinscreen\\",\\"pcap\\":\\"pca2\\",\\"heatmodal_regsig\\":\\"static_mod_regsig\\",\\"fit_or_scr_mod_regsig\\":\\"fitinscreen_mod_regsig\\",\\"signature\\":\\"create_sig\\",\\"cr_reg_sig\\":\\"meta_reg\\",\\"sigtab\\":\\"meta_powers\\",\\"process\\":\\"log\\",\\"user_geo_bs:shiny.action\\":0,\\"start_process:shiny.action\\":0,\\"sample_ont_ser_bs:shiny.action\\":0,\\"process_log_bs:shiny.action\\":0,\\"process_log:shiny.action\\":0,\\"load_counts:shiny.action\\":0,\\"draw_heat:shiny.action\\":0,\\"draw_heatscr:shiny.action\\":0,\\"draw_heatint:shiny.action\\":0,\\"draw_pca:shiny.action\\":0,\\"draw_pca3:shiny.action\\":0,\\"draw_tsne2:shiny.action\\":0,\\"draw_tsne3:shiny.action\\":0,\\"heat_stat_bs:shiny.action\\":0,\\"heat_int_bs:shiny.action\\":0,\\"heatmap_mod_regsig:shiny.action\\":0,\\"draw_heatfit_regsig:shiny.action\\":0,\\"draw_heatscr_regsig:shiny.action\\":0,\\"draw_heatint_regsig:shiny.action\\":0,\\"draw_ma_regsig:shiny.action\\":0,\\"gen_pow_mod_btn:shiny.action\\":0,\\"search_mod_bs:shiny.action\\":0,\\"de_sig_bs:shiny.action\\":0,\\"de_sig_bs2:shiny.action\\":0,\\"power_bs:shiny.action\\":0,\\"detect_bs:shiny.action\\":0,\\"search_gene_bs:shiny.action\\":0,\\"show_log:shiny.action\\":0,\\"counts_choice\\":\\"Raw\\",\\"download_type_counts\\":\\"Gene level\\",\\"download_type_fit\\":\\"png\\",\\"download_type_scr\\":\\"png\\",\\"sub_prop_tsne2\\":\\"No\\",\\"sub_sam_pca\\":\\"No\\",\\"fact_choice\\":\\"All samples\\",\\"sub_sam\\":\\"No\\",\\"download_type_fit_mod_regsig\\":\\"png\\",\\"download_type_scr_mod_regsig\\":\\"png\\",\\"gen_det_mod_type\\":\\"All\\",\\"pow_fact_choice\\":\\"All samples\\",\\"pow_sub_sample2\\":\\"No\\",\\"sample_ont_ser\\":[],\\"geo_next_lp\\":\\"\\",\\"geo_current\\":\\"\\",\\"geo_next\\":\\"\\",\\"user_geo\\":\\"\\",\\"search_mod_gene\\":\\"\\",\\"search_gene\\":\\"\\",\\".clientdata_output_samplesize_den_width\\":440,\\".clientdata_output_samplesize_den_height\\":255,\\".clientdata_output_study_stat_width\\":595,\\".clientdata_output_study_stat_height\\":255,\\".clientdata_output_sample_stat_width\\":615,\\".clientdata_output_sample_stat_height\\":255,\\".clientdata_output_stepbystep_hidden\\":true,\\".clientdata_output_samplesize_den_hidden\\":false,\\".clientdata_output_study_stat_hidden\\":false,\\".clientdata_output_sample_stat_hidden\\":false,\\".clientdata_output_warn_hidden\\":false,\\".clientdata_output_warn2_hidden\\":false,\\".clientdata_output_warn3_hidden\\":false,\\".clientdata_output_warn4_hidden\\":false,\\".clientdata_output_warn5_hidden\\":false,\\".clientdata_output_warn_ont_hidden\\":false,\\".clientdata_output_warn_ont2_hidden\\":false,\\".clientdata_output_datatable_hidden\\":false,\\".clientdata_output_geo_acc_ui_hidden\\":true,\\".clientdata_output_metadata_column_hidden\\":true,\\".clientdata_output_full_metacol_hidden\\":true,\\".clientdata_output_downloadmeta_hidden\\":true,\\".clientdata_output_counts_sample_ui_hidden\\":true,\\".clientdata_output_downloadcounts_hidden\\":true,\\".clientdata_output_cor_sample_ui_hidden\\":true,\\".clientdata_output_show_grp_ui_hidden\\":true,\\".clientdata_output_corr_prop_hidden\\":true,\\".clientdata_output_draw_cor_ui_hidden\\":true,\\".clientdata_output_dens_sample_ui_hidden\\":true,\\".clientdata_output_draw_dens_ui_hidden\\":true,\\".clientdata_output_heat_prop_hidden\\":true,\\".clientdata_output_cluster_meth_hidden\\":true,\\".clientdata_output_cluster_genes_hidden\\":true,\\".clientdata_output_download_hidden\\":true,\\".clientdata_output_downloadscr_hidden\\":true,\\".clientdata_output_pca_prop_hidden\\":true,\\".clientdata_output_subprop2_ui_hidden\\":true,\\".clientdata_output_subprop_ui_hidden\\":true,\\".clientdata_output_legendplot_hidden\\":true,\\".clientdata_output_geo_summary_hidden\\":true,\\".clientdata_output_metadata_hidden\\":true,\\".clientdata_output_metadata_full_hidden\\":true,\\".clientdata_output_ontology_hidden\\":true,\\".clientdata_output_counts_warn_hidden\\":true,\\".clientdata_output_counts_text_hidden\\":true,\\".clientdata_output_counts_hidden\\":true,\\".clientdata_output_boxplot_counts_hidden\\":true,\\".clientdata_output_downloadqc_hidden\\":true,\\".clientdata_output_multiqc_hidden\\":true,\\".clientdata_output_corr_warn_hidden\\":true,\\".clientdata_output_corplot_ui_hidden\\":true,\\".clientdata_output_dens_warn_hidden\\":true,\\".clientdata_output_densityp_hidden\\":true,\\".clientdata_output_heat_warn_hidden\\":true,\\".clientdata_output_HeatStatic_hidden\\":true,\\".clientdata_output_HeatStaticscr_hidden\\":true,\\".clientdata_output_iheatmapui_hidden\\":true,\\".clientdata_output_downloadPCA2D_hidden\\":true,\\".clientdata_output_p2D_ui_hidden\\":true,\\".clientdata_output_pca_sam_warn_hidden\\":true,\\".clientdata_output_pca3Dplot_ui_hidden\\":true,\\".clientdata_output_t2Dplot_ui_hidden\\":true,\\".clientdata_output_tsne3Dplot_ui_hidden\\":true,\\".clientdata_output_geo_acc2_ui_hidden\\":true,\\".clientdata_output_metadata_analysis_hidden\\":true,\\".clientdata_output_group1_hidden\\":true,\\".clientdata_output_group2_hidden\\":true,\\".clientdata_output_ana_type_hidden\\":true,\\".clientdata_output_cov_hidden\\":true,\\".clientdata_output_meta_ui_hidden\\":true,\\".clientdata_output_gen_reg_sig_ui_hidden\\":true,\\".clientdata_output_heat_typeui_mod_regsig_hidden\\":true,\\".clientdata_output_heat_prop_mod_regsig_hidden\\":true,\\".clientdata_output_cluster_meth_mod_regsig_hidden\\":true,\\".clientdata_output_cluster_genes_mod_regsig_hidden\\":true,\\".clientdata_output_downloadfit_mod_regsig_hidden\\":true,\\".clientdata_output_downloadscr_mod_regsig_hidden\\":true,\\".clientdata_output_fdrui_mod_regsig_hidden\\":true,\\".clientdata_output_effect_ma_mod_ui_hidden\\":true,\\".clientdata_output_power_mod_ui_hidden\\":true,\\".clientdata_output_alpha_mod_ui_hidden\\":true,\\".clientdata_output_fitscreen_mod_regsig_hidden\\":true,\\".clientdata_output_scroll_mod_regsig_hidden\\":true,\\".clientdata_output_iheatmapui_mod_regsig_hidden\\":true,\\".clientdata_output_downloadMA_hidden\\":true,\\".clientdata_output_maplotui_mod_regsig_hidden\\":true,\\".clientdata_output_ma_mod_text_hidden\\":true,\\".clientdata_output_maplot_clickedpoints_hidden\\":true,\\".clientdata_output_gene_mod_warn_hidden\\":true,\\".clientdata_output_gene_sym_mod_warn_hidden\\":true,\\".clientdata_output_gene_sym_mod_green_hidden\\":true,\\".clientdata_output_det_mod_label_hidden\\":true,\\".clientdata_output_gen_det_mod_dl_hidden\\":true,\\".clientdata_output_plotdetui_mod_regsig_hidden\\":true,\\".clientdata_output_det_mod_text_hidden\\":true,\\".clientdata_output_det_mod_gene_clickedpoints_hidden\\":true,\\".clientdata_output_downloadsigdata_hidden\\":true,\\".clientdata_output_ui_reg_ilincs_option_hidden\\":true,\\".clientdata_output_power_sig_ui_hidden\\":true,\\".clientdata_output_alpha_sig_ui_hidden\\":true,\\".clientdata_output_dynamiclink_hidden\\":true,\\".clientdata_output_prop_power_ui_hidden\\":true,\\".clientdata_output_group1_pow_ui_hidden\\":true,\\".clientdata_output_group2_pow_ui_hidden\\":true,\\".clientdata_output_meta_pow_ui_hidden\\":true,\\".clientdata_output_gen_meta_pow_ui_hidden\\":true,\\".clientdata_output_samples1_hidden\\":true,\\".clientdata_output_samples2_hidden\\":true,\\".clientdata_output_effect_hidden\\":true,\\".clientdata_output_alpha_hidden\\":true,\\".clientdata_output_depth_ui_hidden\\":true,\\".clientdata_output_power_ui_hidden\\":true,\\".clientdata_output_det_effect_ui_hidden\\":true,\\".clientdata_output_fdr_ui_hidden\\":true,\\".clientdata_output_prop_detect_ui_hidden\\":true,\\".clientdata_output_group1_detect_ui_hidden\\":true,\\".clientdata_output_group2_detect_ui_hidden\\":true,\\".clientdata_output_gen_pow_btn_ui_hidden\\":true,\\".clientdata_output_gen_detect_btn_ui_hidden\\":true,\\".clientdata_output_sig1_warn_hidden\\":true,\\".clientdata_output_rank_warn_hidden\\":true,\\".clientdata_output_level_warn_hidden\\":true,\\".clientdata_output_sig_meta_hidden\\":true,\\".clientdata_output_sig_data_hidden\\":true,\\".clientdata_output_meta_pow_txt_hidden\\":true,\\".clientdata_output_meta_power_warn_hidden\\":true,\\".clientdata_output_metadata_pow_table_hidden\\":true,\\".clientdata_output_power1_warn_hidden\\":true,\\".clientdata_output_powerplot_hidden\\":true,\\".clientdata_output_gene_warn_hidden\\":true,\\".clientdata_output_gene_sym_warn_hidden\\":true,\\".clientdata_output_gene_sym_green_hidden\\":true,\\".clientdata_output_power2_warn_hidden\\":true,\\".clientdata_output_detect_gene_ui_hidden\\":true,\\".clientdata_output_gen_det_text_hidden\\":true,\\".clientdata_output_detect_gene_tab_hidden\\":true,\\".clientdata_output_steps_hidden\\":true,\\".clientdata_output_process_log_text_hidden\\":true,\\".clientdata_pixelratio\\":1,\\".clientdata_url_protocol\\":\\"http:\\",\\".clientdata_url_hostname\\":\\"www.ilincs.org\\",\\".clientdata_url_port\\":\\"\\",\\".clientdata_url_pathname\\":\\"/apps/grein/\\",\\".clientdata_url_search\\":\\"?gse=\\",\\".clientdata_url_hash_initial\\":\\"\\",\\".clientdata_url_hash\\":\\"\\",\\".clientdata_singletons\\":\\"991a9dee8b6f41039f0d48e0f3cb481dfef69248,abbc5191535f7e95ba1254171676097ac26b5edc,2581d36bc09732ee052ca2bcc5a7ae809019206f,2936dd0d01d731dd90358375bdaef9c44ce3b494,603e796bcfc2ab3685167d58c426f64c15a95192\\",\\".clientdata_allowDataUriScheme\\":true}}"]'

    def overview_streaming_updata(self):
        return '["2#0|m|{\\"method\\":\\"update\\",\\"data\\":{\\".clientdata_output_warn_hidden\\":true,\\".clientdata_output_warn3_hidden\\":true,\\".clientdata_output_warn4_hidden\\":true,\\".clientdata_output_warn5_hidden\\":true}}"]'

    def overview_form_data(self, no_datasets):
        return f"draw=1&columns%5B0%5D%5Bdata%5D=0&columns%5B0%5D%5Bname%5D=&columns%5B0%5D%5Bsearchable%5D=true&columns%5B0%5D%5Borderable%5D=true&columns%5B0%5D%5Bsearch%5D%5Bvalue%5D=&columns%5B0%5D%5Bsearch%5D%5Bregex%5D=false&columns%5B1%5D%5Bdata%5D=1&columns%5B1%5D%5Bname%5D=&columns%5B1%5D%5Bsearchable%5D=true&columns%5B1%5D%5Borderable%5D=true&columns%5B1%5D%5Bsearch%5D%5Bvalue%5D=&columns%5B1%5D%5Bsearch%5D%5Bregex%5D=false&columns%5B2%5D%5Bdata%5D=2&columns%5B2%5D%5Bname%5D=&columns%5B2%5D%5Bsearchable%5D=true&columns%5B2%5D%5Borderable%5D=true&columns%5B2%5D%5Bsearch%5D%5Bvalue%5D=&columns%5B2%5D%5Bsearch%5D%5Bregex%5D=false&columns%5B3%5D%5Bdata%5D=3&columns%5B3%5D%5Bname%5D=&columns%5B3%5D%5Bsearchable%5D=true&columns%5B3%5D%5Borderable%5D=true&columns%5B3%5D%5Bsearch%5D%5Bvalue%5D=&columns%5B3%5D%5Bsearch%5D%5Bregex%5D=false&columns%5B4%5D%5Bdata%5D=4&columns%5B4%5D%5Bname%5D=&columns%5B4%5D%5Bsearchable%5D=true&columns%5B4%5D%5Borderable%5D=true&columns%5B4%5D%5Bsearch%5D%5Bvalue%5D=&columns%5B4%5D%5Bsearch%5D%5Bregex%5D=false&start=0&length={no_datasets}&search%5Bvalue%5D=&search%5Bregex%5D=false&search%5BcaseInsensitive%5D=true&search%5Bsmart%5D=true&escape=false"

    @staticmethod
    def get_random_url_string_parameter():
        return ''.join(random.choice(string.ascii_letters) for _ in range(10)) + "/" + \
               ''.join(random.choice(string.ascii_letters) for _ in range(3)) + "/" + \
               ''.join(random.choice(string.ascii_letters) for _ in range(8))

    @staticmethod
    def get_random_nonce_parameter():
        return ''.join(random.choice(string.ascii_letters) for _ in range(10))
