# Generated by Django 3.1.13 on 2021-07-24 03:13

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='App',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('code', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('name', models.CharField(help_text='The application display name.', max_length=255)),
                ('android_package_name', models.CharField(blank=True, help_text='com.company.appname', max_length=255)),
                ('apple_app_id', models.CharField(blank=True, help_text='id1234567890', max_length=36)),
            ],
            options={
                'ordering': ['android_package_name', 'apple_app_id'],
            },
        ),
        migrations.CreateModel(
            name='Visit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('ip_address', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('ip_data', models.JSONField(blank=True, default=dict, help_text='Must be valid JSON', null=True, verbose_name='IP geodata')),
                ('ua_data', models.JSONField(blank=True, default=dict, help_text='Must be valid JSON', null=True, verbose_name='User agent data')),
                ('deep_link', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='scans', to='django_deep_link.app')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
