# coding: utf-8

"""
    Qase.io TestOps API v1

    Qase TestOps API v1 Specification.

    The version of the OpenAPI document: 1.0.0
    Contact: support@qase.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qase.api_client_v1.models.attachment import Attachment
from qase.api_client_v1.models.custom_field_value import CustomFieldValue
from qase.api_client_v1.models.tag_value import TagValue
from qase.api_client_v1.models.test_case_params import TestCaseParams
from qase.api_client_v1.models.test_step import TestStep
from typing import Optional, Set
from typing_extensions import Self

class TestCaseQuery(BaseModel):
    """
    TestCaseQuery
    """ # noqa: E501
    id: Optional[StrictInt] = None
    test_case_id: StrictInt
    position: Optional[StrictInt] = None
    title: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    preconditions: Optional[StrictStr] = None
    postconditions: Optional[StrictStr] = None
    severity: Optional[StrictInt] = None
    priority: Optional[StrictInt] = None
    type: Optional[StrictInt] = None
    layer: Optional[StrictInt] = None
    is_flaky: Optional[StrictInt] = None
    behavior: Optional[StrictInt] = None
    automation: Optional[StrictInt] = None
    status: Optional[StrictInt] = None
    milestone_id: Optional[StrictInt] = None
    suite_id: Optional[StrictInt] = None
    custom_fields: Optional[List[CustomFieldValue]] = None
    attachments: Optional[List[Attachment]] = None
    steps_type: Optional[StrictStr] = None
    steps: Optional[List[TestStep]] = None
    params: Optional[TestCaseParams] = None
    tags: Optional[List[TagValue]] = None
    member_id: Optional[StrictInt] = Field(default=None, description="Deprecated, use `author_id` instead.")
    author_id: Optional[StrictInt] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    updated_by: Optional[StrictInt] = Field(default=None, description="Author ID of the last update.")
    __properties: ClassVar[List[str]] = ["id", "test_case_id", "position", "title", "description", "preconditions", "postconditions", "severity", "priority", "type", "layer", "is_flaky", "behavior", "automation", "status", "milestone_id", "suite_id", "custom_fields", "attachments", "steps_type", "steps", "params", "tags", "member_id", "author_id", "created_at", "updated_at", "updated_by"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestCaseQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_fields (list)
        _items = []
        if self.custom_fields:
            for _item in self.custom_fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['custom_fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item in self.steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of params
        if self.params:
            _dict['params'] = self.params.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if preconditions (nullable) is None
        # and model_fields_set contains the field
        if self.preconditions is None and "preconditions" in self.model_fields_set:
            _dict['preconditions'] = None

        # set to None if postconditions (nullable) is None
        # and model_fields_set contains the field
        if self.postconditions is None and "postconditions" in self.model_fields_set:
            _dict['postconditions'] = None

        # set to None if milestone_id (nullable) is None
        # and model_fields_set contains the field
        if self.milestone_id is None and "milestone_id" in self.model_fields_set:
            _dict['milestone_id'] = None

        # set to None if suite_id (nullable) is None
        # and model_fields_set contains the field
        if self.suite_id is None and "suite_id" in self.model_fields_set:
            _dict['suite_id'] = None

        # set to None if steps_type (nullable) is None
        # and model_fields_set contains the field
        if self.steps_type is None and "steps_type" in self.model_fields_set:
            _dict['steps_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestCaseQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "test_case_id": obj.get("test_case_id"),
            "position": obj.get("position"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "preconditions": obj.get("preconditions"),
            "postconditions": obj.get("postconditions"),
            "severity": obj.get("severity"),
            "priority": obj.get("priority"),
            "type": obj.get("type"),
            "layer": obj.get("layer"),
            "is_flaky": obj.get("is_flaky"),
            "behavior": obj.get("behavior"),
            "automation": obj.get("automation"),
            "status": obj.get("status"),
            "milestone_id": obj.get("milestone_id"),
            "suite_id": obj.get("suite_id"),
            "custom_fields": [CustomFieldValue.from_dict(_item) for _item in obj["custom_fields"]] if obj.get("custom_fields") is not None else None,
            "attachments": [Attachment.from_dict(_item) for _item in obj["attachments"]] if obj.get("attachments") is not None else None,
            "steps_type": obj.get("steps_type"),
            "steps": [TestStep.from_dict(_item) for _item in obj["steps"]] if obj.get("steps") is not None else None,
            "params": TestCaseParams.from_dict(obj["params"]) if obj.get("params") is not None else None,
            "tags": [TagValue.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "member_id": obj.get("member_id"),
            "author_id": obj.get("author_id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "updated_by": obj.get("updated_by")
        })
        return _obj


