# coding: utf-8

"""
    Qase.io TestOps API v1

    Qase TestOps API v1 Specification.

    The version of the OpenAPI document: 1.0.0
    Contact: support@qase.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Runupdate(BaseModel):
    """
    Runupdate
    """ # noqa: E501
    title: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    description: Optional[Annotated[str, Field(strict=True, max_length=10000)]] = None
    environment_id: Optional[Annotated[int, Field(strict=True, ge=1)]] = None
    environment_slug: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    milestone_id: Optional[Annotated[int, Field(strict=True, ge=1)]] = None
    tags: Optional[List[StrictStr]] = None
    configurations: Optional[List[StrictInt]] = None
    custom_field: Optional[Dict[str, StrictStr]] = Field(default=None, description="A map of custom fields values (id => value)")
    __properties: ClassVar[List[str]] = ["title", "description", "environment_id", "environment_slug", "milestone_id", "tags", "configurations", "custom_field"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Runupdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if environment_id (nullable) is None
        # and model_fields_set contains the field
        if self.environment_id is None and "environment_id" in self.model_fields_set:
            _dict['environment_id'] = None

        # set to None if environment_slug (nullable) is None
        # and model_fields_set contains the field
        if self.environment_slug is None and "environment_slug" in self.model_fields_set:
            _dict['environment_slug'] = None

        # set to None if milestone_id (nullable) is None
        # and model_fields_set contains the field
        if self.milestone_id is None and "milestone_id" in self.model_fields_set:
            _dict['milestone_id'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if configurations (nullable) is None
        # and model_fields_set contains the field
        if self.configurations is None and "configurations" in self.model_fields_set:
            _dict['configurations'] = None

        # set to None if custom_field (nullable) is None
        # and model_fields_set contains the field
        if self.custom_field is None and "custom_field" in self.model_fields_set:
            _dict['custom_field'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Runupdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "description": obj.get("description"),
            "environment_id": obj.get("environment_id"),
            "environment_slug": obj.get("environment_slug"),
            "milestone_id": obj.get("milestone_id"),
            "tags": obj.get("tags"),
            "configurations": obj.get("configurations"),
            "custom_field": obj.get("custom_field")
        })
        return _obj


