# coding: utf-8

"""
    Qase.io TestOps API v1

    Qase TestOps API v1 Specification.

    The version of the OpenAPI document: 1.0.0
    Contact: support@qase.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from qase.api_client_v1.models.test_step_result_create import TestStepResultCreate
from typing import Optional, Set
from typing_extensions import Self

class ResultUpdate(BaseModel):
    """
    ResultUpdate
    """ # noqa: E501
    status: Optional[StrictStr] = None
    time_ms: Optional[Annotated[int, Field(le=31536000000, strict=True, ge=0)]] = None
    defect: Optional[StrictBool] = None
    attachments: Optional[List[StrictStr]] = None
    stacktrace: Optional[StrictStr] = None
    comment: Optional[StrictStr] = None
    steps: Optional[List[TestStepResultCreate]] = None
    __properties: ClassVar[List[str]] = ["status", "time_ms", "defect", "attachments", "stacktrace", "comment", "steps"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['in_progress', 'passed', 'failed', 'blocked', 'skipped']):
            raise ValueError("must be one of enum values ('in_progress', 'passed', 'failed', 'blocked', 'skipped')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResultUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item in self.steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['steps'] = _items
        # set to None if time_ms (nullable) is None
        # and model_fields_set contains the field
        if self.time_ms is None and "time_ms" in self.model_fields_set:
            _dict['time_ms'] = None

        # set to None if defect (nullable) is None
        # and model_fields_set contains the field
        if self.defect is None and "defect" in self.model_fields_set:
            _dict['defect'] = None

        # set to None if attachments (nullable) is None
        # and model_fields_set contains the field
        if self.attachments is None and "attachments" in self.model_fields_set:
            _dict['attachments'] = None

        # set to None if stacktrace (nullable) is None
        # and model_fields_set contains the field
        if self.stacktrace is None and "stacktrace" in self.model_fields_set:
            _dict['stacktrace'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        # set to None if steps (nullable) is None
        # and model_fields_set contains the field
        if self.steps is None and "steps" in self.model_fields_set:
            _dict['steps'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResultUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "time_ms": obj.get("time_ms"),
            "defect": obj.get("defect"),
            "attachments": obj.get("attachments"),
            "stacktrace": obj.get("stacktrace"),
            "comment": obj.get("comment"),
            "steps": [TestStepResultCreate.from_dict(_item) for _item in obj["steps"]] if obj.get("steps") is not None else None
        })
        return _obj


