# coding: utf-8

"""
    Qase.io TestOps API v1

    Qase TestOps API v1 Specification.

    The version of the OpenAPI document: 1.0.0
    Contact: support@qase.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from qase.api_client_v1.models.result_create_case import ResultCreateCase
from qase.api_client_v1.models.test_step_result_create import TestStepResultCreate
from typing import Optional, Set
from typing_extensions import Self

class ResultCreate(BaseModel):
    """
    ResultCreate
    """ # noqa: E501
    case_id: Optional[StrictInt] = None
    case: Optional[ResultCreateCase] = None
    status: StrictStr = Field(description="Can have the following values `passed`, `failed`, `blocked`, `skipped`, `invalid` + custom statuses")
    start_time: Optional[Annotated[int, Field(strict=True, ge=0)]] = None
    time: Optional[Annotated[int, Field(le=31536000, strict=True, ge=0)]] = None
    time_ms: Optional[Annotated[int, Field(le=31536000000, strict=True, ge=0)]] = None
    defect: Optional[StrictBool] = None
    attachments: Optional[List[StrictStr]] = None
    stacktrace: Optional[StrictStr] = None
    comment: Optional[StrictStr] = None
    param: Optional[Dict[str, StrictStr]] = Field(default=None, description="A map of parameters (name => value)")
    param_groups: Optional[List[List[StrictStr]]] = Field(default=None, description="List parameter groups by name only. Add their values in the 'param' field")
    steps: Optional[List[TestStepResultCreate]] = None
    author_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["case_id", "case", "status", "start_time", "time", "time_ms", "defect", "attachments", "stacktrace", "comment", "param", "param_groups", "steps", "author_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResultCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of case
        if self.case:
            _dict['case'] = self.case.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item in self.steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['steps'] = _items
        # set to None if start_time (nullable) is None
        # and model_fields_set contains the field
        if self.start_time is None and "start_time" in self.model_fields_set:
            _dict['start_time'] = None

        # set to None if time (nullable) is None
        # and model_fields_set contains the field
        if self.time is None and "time" in self.model_fields_set:
            _dict['time'] = None

        # set to None if time_ms (nullable) is None
        # and model_fields_set contains the field
        if self.time_ms is None and "time_ms" in self.model_fields_set:
            _dict['time_ms'] = None

        # set to None if defect (nullable) is None
        # and model_fields_set contains the field
        if self.defect is None and "defect" in self.model_fields_set:
            _dict['defect'] = None

        # set to None if attachments (nullable) is None
        # and model_fields_set contains the field
        if self.attachments is None and "attachments" in self.model_fields_set:
            _dict['attachments'] = None

        # set to None if stacktrace (nullable) is None
        # and model_fields_set contains the field
        if self.stacktrace is None and "stacktrace" in self.model_fields_set:
            _dict['stacktrace'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        # set to None if param (nullable) is None
        # and model_fields_set contains the field
        if self.param is None and "param" in self.model_fields_set:
            _dict['param'] = None

        # set to None if param_groups (nullable) is None
        # and model_fields_set contains the field
        if self.param_groups is None and "param_groups" in self.model_fields_set:
            _dict['param_groups'] = None

        # set to None if steps (nullable) is None
        # and model_fields_set contains the field
        if self.steps is None and "steps" in self.model_fields_set:
            _dict['steps'] = None

        # set to None if author_id (nullable) is None
        # and model_fields_set contains the field
        if self.author_id is None and "author_id" in self.model_fields_set:
            _dict['author_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResultCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "case_id": obj.get("case_id"),
            "case": ResultCreateCase.from_dict(obj["case"]) if obj.get("case") is not None else None,
            "status": obj.get("status"),
            "start_time": obj.get("start_time"),
            "time": obj.get("time"),
            "time_ms": obj.get("time_ms"),
            "defect": obj.get("defect"),
            "attachments": obj.get("attachments"),
            "stacktrace": obj.get("stacktrace"),
            "comment": obj.get("comment"),
            "param": obj.get("param"),
            "param_groups": obj.get("param_groups"),
            "steps": [TestStepResultCreate.from_dict(_item) for _item in obj["steps"]] if obj.get("steps") is not None else None,
            "author_id": obj.get("author_id")
        })
        return _obj


