# coding: utf-8

"""
    Qase.io TestOps API v1

    Qase TestOps API v1 Specification.

    The version of the OpenAPI document: 1.0.0
    Contact: support@qase.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CustomField(BaseModel):
    """
    CustomField
    """ # noqa: E501
    id: Optional[StrictInt] = None
    title: Optional[StrictStr] = None
    entity: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    placeholder: Optional[StrictStr] = None
    default_value: Optional[StrictStr] = None
    value: Optional[StrictStr] = None
    is_required: Optional[StrictBool] = None
    is_visible: Optional[StrictBool] = None
    is_filterable: Optional[StrictBool] = None
    is_enabled_for_all_projects: Optional[StrictBool] = None
    created: Optional[StrictStr] = Field(default=None, description="Deprecated, use the `created_at` property instead.")
    updated: Optional[StrictStr] = Field(default=None, description="Deprecated, use the `updated_at` property instead.")
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    projects_codes: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["id", "title", "entity", "type", "placeholder", "default_value", "value", "is_required", "is_visible", "is_filterable", "is_enabled_for_all_projects", "created", "updated", "created_at", "updated_at", "projects_codes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if placeholder (nullable) is None
        # and model_fields_set contains the field
        if self.placeholder is None and "placeholder" in self.model_fields_set:
            _dict['placeholder'] = None

        # set to None if default_value (nullable) is None
        # and model_fields_set contains the field
        if self.default_value is None and "default_value" in self.model_fields_set:
            _dict['default_value'] = None

        # set to None if value (nullable) is None
        # and model_fields_set contains the field
        if self.value is None and "value" in self.model_fields_set:
            _dict['value'] = None

        # set to None if updated (nullable) is None
        # and model_fields_set contains the field
        if self.updated is None and "updated" in self.model_fields_set:
            _dict['updated'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "entity": obj.get("entity"),
            "type": obj.get("type"),
            "placeholder": obj.get("placeholder"),
            "default_value": obj.get("default_value"),
            "value": obj.get("value"),
            "is_required": obj.get("is_required"),
            "is_visible": obj.get("is_visible"),
            "is_filterable": obj.get("is_filterable"),
            "is_enabled_for_all_projects": obj.get("is_enabled_for_all_projects"),
            "created": obj.get("created"),
            "updated": obj.get("updated"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "projects_codes": obj.get("projects_codes")
        })
        return _obj


