/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.FormatDescription;
import com.sas.text.InvalidFormatException;
import com.sas.text.SASFormatEntry;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

@SASScope
class SingleEntry
extends SASFormatEntry {
    protected Vector patterns = new Vector(5, 1);
    private String m_currencySymbol = null;
    private static final String[] CurrencyPatterns = new String[]{"#,##0.##\u00a4", "#,##0.##\u00a4", "#,##0.##\u00a4", "#,##0.##\u00a4", "#,##0.##\u00a4", "\u00a4#,##0.##", "\u00a4#,##0.##", "\u00a4#,##0.##", "\u00a4#,##0.##", "\u00a4#,##0.##", "#,##0.## \u00a4", "#,##0.## \u00a4", "#,##0.## \u00a4", "#,##0.## \u00a4", "#,##0.## \u00a4", "\u00a4 #,##0.##", "\u00a4 #,##0.##", "\u00a4 #,##0.##", "\u00a4 #,##0.##", "\u00a4 #,##0.##"};
    private static final String[] CurrencyNegativePatterns = new String[]{"(#,##0.##\u00a4)", "#,##0.##\u00a4", "#,##0.##\u00a4-", "#,##0.##-\u00a4", "#,##0.##\u00a4-", "(\u00a4#,##0.##)", "-\u00a4#,##0.##", "\u00a4#,##0.##-", "-\u00a4#,##0.##", "\u00a4-#,##0.##", "(#,##0.## \u00a4)", "-#,##0.## \u00a4", "#,##0.## \u00a4-", "#,##0.##- \u00a4", "#,##0.## \u00a4-", "(\u00a4 #,##0.##)", "\u00a4 #,##0.##", "\u00a4 #,##0.##-", "-\u00a4 #,##0.##", "\u00a4 -#,##0.##"};
    private String m_replacedLocalCurrencySymbol;
    public boolean m_isReplaced = false;

    public SingleEntry(String format, String className) {
        super(format, className);
    }

    @Override
    public void addPattern(int minWidth, int maxWidth, String pattern, boolean defaultPattern) {
        Entry entry = new Entry();
        entry.min = minWidth;
        entry.max = maxWidth;
        entry.pattern = pattern;
        if (defaultPattern) {
            this.patterns.insertElementAt(entry, 0);
        } else {
            this.patterns.addElement(entry);
        }
        this.setMinWidth(Math.min(this.getMinWidth(), minWidth));
        this.setMaxWidth(Math.max(this.getMaxWidth(), maxWidth));
    }

    public void addPattern(int minWidth, int maxWidth, String pattern, boolean defaultPattern, boolean d) {
        Entry entry = new Entry();
        entry.min = minWidth;
        entry.max = maxWidth;
        entry.pattern = pattern;
        entry.d = d;
        if (defaultPattern) {
            this.patterns.insertElementAt(entry, 0);
        } else {
            this.patterns.addElement(entry);
        }
        this.setMinWidth(Math.min(this.getMinWidth(), minWidth));
        this.setMaxWidth(Math.max(this.getMaxWidth(), maxWidth));
    }

    public void addPattern(int minWidth, int maxWidth, String pattern, boolean defaultPattern, int style) {
        Entry entry = new Entry();
        entry.min = minWidth;
        entry.max = maxWidth;
        entry.pattern = pattern;
        if (style != -1) {
            entry.m_style = style;
        }
        if (defaultPattern) {
            this.patterns.insertElementAt(entry, 0);
        } else {
            this.patterns.addElement(entry);
        }
        this.setMinWidth(Math.min(this.getMinWidth(), minWidth));
        this.setMaxWidth(Math.max(this.getMaxWidth(), maxWidth));
    }

    public void addPattern(int minWidth, int maxWidth, String pattern, boolean defaultPattern, int style, boolean d) {
        Entry entry = new Entry();
        entry.min = minWidth;
        entry.max = maxWidth;
        entry.pattern = pattern;
        entry.d = d;
        if (style != -1) {
            entry.m_style = style;
        }
        if (defaultPattern) {
            this.patterns.insertElementAt(entry, 0);
        } else {
            this.patterns.addElement(entry);
        }
        this.setMinWidth(Math.min(this.getMinWidth(), minWidth));
        this.setMaxWidth(Math.max(this.getMaxWidth(), maxWidth));
    }

    @Override
    public void addPattern(int minWidth, int maxWidth, String pattern) {
        this.addPattern(minWidth, maxWidth, pattern, false);
    }

    private void addPatternD(int minWidth, int maxWidth, String pattern, boolean d, boolean isDatms) {
        this.addPattern(minWidth, maxWidth, pattern, false);
        Entry entry = (Entry)this.patterns.get(this.patterns.size() - 1);
        entry.d = d;
        entry.isDatms = isDatms;
    }

    @Override
    public void addDatetimeResourceString(int minWidth, String maxKey, String key) {
        String max = this.getDatetimeString(maxKey);
        int maxWidth = Integer.parseInt(max) - 1;
        this.addDatetimeResourceString(minWidth, maxWidth, key, false, -1, false);
    }

    @Override
    public void addDatetimeResourceString(String minKey, String maxKey, String key, int style, boolean d) {
        String min = this.getDatetimeString(minKey);
        int minWidth = Integer.parseInt(min);
        String max = this.getDatetimeString(maxKey);
        int maxWidth = Integer.parseInt(max) - 1;
        if (maxWidth >= minWidth) {
            this.addDatetimeResourceString(minWidth, maxWidth, key, false, style, d);
        }
    }

    @Override
    public String getBaseFormatName() {
        return this.baseFormat;
    }

    @Override
    public String getPattern(String format, int width) throws InvalidFormatException {
        Entry validEntry = null;
        for (int i = this.patterns.size() - 1; i >= 0; --i) {
            Entry entry = (Entry)this.patterns.elementAt(i);
            if (width == entry.min) {
                validEntry = entry;
                break;
            }
            if (width <= entry.min || width > entry.max) continue;
            validEntry = entry;
        }
        if (validEntry != null) {
            if (this.m_isReplaced) {
                return validEntry.getReplacedPattern();
            }
            return validEntry.pattern;
        }
        throw new InvalidFormatException("Width specified for format " + format + " is invalid.");
    }

    public String getPattern(String format, int width, int dWidth) throws InvalidFormatException {
        Entry validEntry = null;
        for (int i = this.patterns.size() - 1; i >= 0; --i) {
            int tmpWidth;
            Entry entry = (Entry)this.patterns.elementAt(i);
            if (width == entry.min) {
                if (dWidth > 0 && entry.isDatms && (entry.min > (tmpWidth = width - 1 - dWidth) || tmpWidth > entry.max)) {
                    return this.getPattern(format, entry.min - 1, dWidth);
                }
                validEntry = entry;
                break;
            }
            if (width <= entry.min || width > entry.max) continue;
            if (dWidth > 0 && entry.isDatms && (entry.min > (tmpWidth = width - 1 - dWidth) || tmpWidth > entry.max)) {
                return this.getPattern(format, entry.min - 1, dWidth);
            }
            validEntry = entry;
        }
        if (validEntry != null) {
            if (this.m_isReplaced) {
                return validEntry.getReplacedPattern();
            }
            return validEntry.pattern;
        }
        throw new InvalidFormatException("Width specified for format " + format + " is invalid.");
    }

    public boolean isSupportDecimal(String format, int width) throws InvalidFormatException {
        Entry validEntry = null;
        for (int i = this.patterns.size() - 1; i >= 0; --i) {
            Entry entry = (Entry)this.patterns.elementAt(i);
            if (width == entry.min) {
                validEntry = entry;
                break;
            }
            if (width <= entry.min || width > entry.max) continue;
            validEntry = entry;
        }
        if (validEntry != null) {
            return validEntry.d;
        }
        throw new InvalidFormatException("Width specified for format " + format + " is invalid.");
    }

    public boolean isSupportDecimal(String format, int width, int dWidth) throws InvalidFormatException {
        Entry validEntry = null;
        for (int i = this.patterns.size() - 1; i >= 0; --i) {
            int tmpWidth;
            Entry entry = (Entry)this.patterns.elementAt(i);
            if (width == entry.min) {
                if (dWidth > 0 && entry.isDatms && (entry.min > (tmpWidth = width - 1 - dWidth) || tmpWidth > entry.max)) {
                    return this.isSupportDecimal(format, entry.min - 1, dWidth);
                }
                validEntry = entry;
                break;
            }
            if (width <= entry.min || width > entry.max) continue;
            if (dWidth > 0 && entry.isDatms && (entry.min > (tmpWidth = width - 1 - dWidth) || tmpWidth > entry.max)) {
                return this.isSupportDecimal(format, entry.min - 1, dWidth);
            }
            validEntry = entry;
        }
        if (validEntry != null) {
            return validEntry.d;
        }
        throw new InvalidFormatException("Width specified for format " + format + " is invalid.");
    }

    @Override
    public String getPattern(String format) throws InvalidFormatException {
        if (this.m_isReplaced) {
            return ((Entry)this.patterns.elementAt(0)).getReplacedPattern();
        }
        return ((Entry)this.patterns.elementAt((int)0)).pattern;
    }

    @Override
    public int getDefaultWidth() {
        Entry entry = (Entry)this.patterns.elementAt(0);
        return entry.min;
    }

    @Override
    FormatDescription[] getFormatDescription() {
        return new FormatDescription[]{this};
    }

    @Override
    public void addResourceString(int minWidth, int maxWidth, int defaultWidth, String[] keys) {
        int max = maxWidth;
        for (int i = 0; i < keys.length; ++i) {
            int width;
            String pattern = this.getString(keys[i]);
            if (pattern == null) {
                pattern = "********";
            }
            try {
                width = Integer.parseInt(this.getString(keys[i] + ".w"));
            }
            catch (NumberFormatException nfe) {
                width = 0;
            }
            if (i == keys.length - 1) {
                width = minWidth;
            }
            if (defaultWidth > width && defaultWidth < max) {
                this.addPattern(defaultWidth, max, pattern, true);
                max = defaultWidth;
            }
            if (width != defaultWidth) {
                this.addPattern(width, max, pattern);
                if (keys[i].endsWith("_s") || keys[i].equalsIgnoreCase("s")) {
                    ((Entry)this.patterns.get(this.patterns.size() - 1)).setStyle(3);
                } else {
                    ((Entry)this.patterns.get(this.patterns.size() - 1)).setStyle(0);
                }
            } else {
                this.addPattern(width, max, pattern, true);
                ((Entry)this.patterns.get(0)).setStyle(2);
            }
            max = width;
        }
    }

    @Override
    public void addDatetimeResourceString(int maxWidth, int defaultWidth, String[] keys) {
        this.addDatetimeResourceString(0, maxWidth, defaultWidth, keys);
    }

    @Override
    public void addDatetimeResourceString(int minWidth, int maxWidth, int defaultWidth, String[] keys) {
        int max = maxWidth;
        for (int i = 0; i < keys.length; ++i) {
            int width;
            String pattern = this.getDatetimeString(keys[i]);
            if (pattern == null) {
                pattern = "********";
            }
            try {
                width = Integer.parseInt(this.getDatetimeString(keys[i] + ".w"));
            }
            catch (NumberFormatException nfe) {
                width = 0;
            }
            if (i == keys.length - 1 && minWidth > 0) {
                width = minWidth;
            }
            if (defaultWidth > width && defaultWidth < max) {
                this.addPattern(defaultWidth, max, pattern, true);
                max = defaultWidth - 1;
            }
            if (width != defaultWidth) {
                this.addPattern(width, max, pattern);
                if (keys[i].endsWith("_s") || keys[i].equalsIgnoreCase("s")) {
                    ((Entry)this.patterns.get(this.patterns.size() - 1)).setStyle(3);
                } else {
                    ((Entry)this.patterns.get(this.patterns.size() - 1)).setStyle(0);
                }
            } else {
                this.addPattern(width, max, pattern, true);
                ((Entry)this.patterns.get(0)).setStyle(2);
            }
            max = width - 1;
        }
    }

    @Override
    public void addResourceString(int minWidth, int maxWidth, String key, boolean defaultPattern) {
        Entry entry = new Entry();
        String pattern = this.getString(key);
        this.addPattern(minWidth, maxWidth, pattern, defaultPattern);
    }

    @Override
    public void addDatetimeResourceString(int minWidth, int maxWidth, String key, boolean defaultPattern) {
        String pattern = this.getDatetimeString(key);
        this.addPattern(minWidth, maxWidth, pattern, defaultPattern, -1);
    }

    @Override
    public void addDatetimeResourceString(String minKey, int maxWidth, String key, boolean defaultPattern) {
        String min = this.getDatetimeString(minKey);
        int minWidth = Integer.parseInt(min);
        String pattern = this.getDatetimeString(key);
        if (minWidth < maxWidth) {
            this.addPattern(minWidth, maxWidth, pattern, defaultPattern, -1);
        }
    }

    public void addDatetimeResourceString(int minWidth, int maxWidth, String key, boolean defaultPattern, int style, boolean d) {
        String pattern = null;
        if (key != null) {
            pattern = this.getDatetimeString(key);
        }
        if (style == -1) {
            this.addPattern(minWidth, maxWidth, pattern, false, d);
        } else {
            this.addPattern(minWidth, maxWidth, pattern, defaultPattern, style, d);
        }
    }

    @Override
    public void addResourceString(String key, boolean defaultPattern) {
        int max;
        int min;
        Entry entry = new Entry();
        String pattern = this.getString(key);
        if (pattern == null) {
            pattern = "********";
            min = 1;
            max = 5;
        } else {
            String width = this.getString(key + ".w");
            min = Integer.parseInt(width);
            max = min + 5;
        }
        this.addPattern(min, max, pattern, defaultPattern);
    }

    @Override
    public void addResourceString(String minKey, int maxWidth, String key, boolean defaultPattern) {
        int max;
        int min;
        Entry entry = new Entry();
        String pattern = null;
        if (key != null && !key.equals("*")) {
            pattern = this.getString(key);
        }
        if (pattern == null) {
            pattern = "********";
            min = 1;
            max = 5;
        } else {
            String minWidth = this.getString(minKey);
            min = Integer.parseInt(minWidth);
            max = maxWidth;
        }
        if (min < max) {
            this.addPattern(min, max, pattern, defaultPattern);
        }
    }

    @Override
    public void addResourceString(String minKey, String maxKey, String key, boolean defaultPattern) {
        int max;
        int min;
        Entry entry = new Entry();
        String pattern = null;
        if (key != null && !key.equals("*")) {
            pattern = this.getString(key);
        }
        if (pattern == null) {
            pattern = "********";
            min = 1;
            max = 5;
        } else {
            String minWidth = this.getString(minKey);
            min = Integer.parseInt(minWidth);
            String maxWidth = this.getString(maxKey);
            max = Integer.parseInt(maxWidth);
        }
        if (min < max) {
            this.addPattern(min, max, pattern, defaultPattern);
        }
    }

    @Override
    public void addResourceString(int minWidth, String maxKey, String key, boolean defaultPattern) {
        int max;
        int min;
        Entry entry = new Entry();
        String pattern = null;
        if (key != null && !key.equals("*")) {
            pattern = this.getString(key);
        }
        if (pattern == null) {
            pattern = "********";
            min = 1;
            max = 5;
        } else {
            min = minWidth;
            String maxWidth = this.getString(maxKey);
            max = Integer.parseInt(maxWidth);
        }
        if (min < max) {
            this.addPattern(min, max, pattern, defaultPattern);
        }
    }

    @Override
    public void addResourceString(String minKey, int maxWidth, String key) {
        this.addResourceString(minKey, maxWidth, key, false);
    }

    @Override
    public void addResourceString(String minKey, String maxKey, String key) {
        this.addResourceString(minKey, maxKey, key, false);
    }

    @Override
    public void addResourceString(int minWidth, String maxKey, String key) {
        this.addResourceString(minWidth, maxKey, key, false);
    }

    @Override
    public void addResourceString(int minWidth, int maxWidth, String key) {
        this.addResourceString(minWidth, maxWidth, key, false);
    }

    @Override
    public void addResourceString(String key) {
        this.addResourceString(key, false);
    }

    @Override
    public void setCurrencyPatterns(String symbol, boolean localized) {
        String currencyPattern;
        Entry entry = new Entry();
        String patternNums = this.getString("p_n");
        Currency currency = Currency.getInstance(symbol);
        String decimalPattern = ".#######";
        if (patternNums == null) {
            currencyPattern = "#,##0.##";
            System.out.println("Unable to read p_n pattern for " + symbol);
        } else {
            String[] p_n = patternNums.split(";");
            currencyPattern = CurrencyPatterns[Integer.parseInt(p_n[0])];
            if (p_n.length > 1) {
                currencyPattern = currencyPattern.concat(";");
                currencyPattern = currencyPattern.concat(CurrencyNegativePatterns[Integer.parseInt(p_n[1])]);
            }
        }
        String currencySymbol = localized ? currency.getSymbol(this.getFormatLocale()) : symbol;
        currencySymbol = currencySymbol.replaceAll("\\$", "\\\\\\$");
        currencyPattern = currencyPattern.replaceAll("\u00a4", currencySymbol);
        if (currency.getDefaultFractionDigits() > 0) {
            currencyPattern = currencyPattern.replaceAll("\\.##", decimalPattern.substring(0, currency.getDefaultFractionDigits() + 1));
        }
        this.addPattern(12, 32, currencyPattern, true);
        this.addPattern(8, 12, currencyPattern);
        this.setCurrencySymbol(currencySymbol);
        if (this.patterns != null) {
            this.replaceLocalCurrencySymbol(currencySymbol);
        }
    }

    public String[] getPatterns() {
        String[] p = null;
        if (this.patterns != null) {
            p = new String[this.patterns.size()];
            for (int i = 0; i < this.patterns.size(); ++i) {
                p[i] = ((Entry)this.patterns.elementAt((int)i)).pattern;
            }
        }
        return p;
    }

    public String getCurrecnySymbol() {
        if (this.m_isReplaced) {
            return this.m_replacedLocalCurrencySymbol;
        }
        return this.m_currencySymbol;
    }

    public void setCurrencySymbol(String symbol) {
        this.m_currencySymbol = symbol;
    }

    public void replaceLocalCurrencySymbol(String symbol) {
        if (symbol != null && symbol.length() > 0) {
            StringBuffer sb = new StringBuffer(symbol.length());
            char ASTERISK = '*';
            for (int i = 0; i < symbol.length(); ++i) {
                sb.append(ASTERISK);
            }
            this.m_replacedLocalCurrencySymbol = sb.toString();
            this.m_isReplaced = true;
        }
    }

    public StringBuffer restore(StringBuffer result) {
        if (this.m_isReplaced) {
            String tmp = result.toString();
            tmp = tmp.replace(this.m_replacedLocalCurrencySymbol, this.m_currencySymbol);
            result = new StringBuffer(tmp);
        }
        return result;
    }

    public String getPattern(int style) {
        for (int i = 0; i < this.patterns.size(); ++i) {
            Entry entry = (Entry)this.patterns.elementAt(i);
            if (entry.getStyle() != style) continue;
            if (this.m_isReplaced) {
                return entry.getReplacedPattern();
            }
            return entry.pattern;
        }
        return null;
    }

    public Map genNLdatesEntry(int flgDatetime) {
        return this.genNLdatesEntry(flgDatetime, null);
    }

    public Map genNLdatesEntry(int flgDatetime, String shortPatternKey) {
        int i;
        HashMap<Integer, SingleEntry> shortUniformEntryMap = new HashMap<Integer, SingleEntry>();
        String delim = this.getDatetimeString("date_sep");
        String pattern = this.getDatetimeString("datestyle");
        StringBuffer styleBuff = new StringBuffer();
        StringBuffer[] ptnNLDATES = new StringBuffer[6];
        StringBuffer[] ptnNLDATMS = new StringBuffer[5];
        if (flgDatetime == 0) {
            for (i = 0; i < 6; ++i) {
                ptnNLDATES[i] = new StringBuffer();
            }
        } else {
            for (i = 0; i < 5; ++i) {
                ptnNLDATMS[i] = new StringBuffer();
            }
        }
        for (int ftype = 1; ftype <= 4; ++ftype) {
            String tmpPrePattern;
            String tmpPattern;
            int i2;
            SingleEntry shortEntry;
            int i3;
            styleBuff.setLength(0);
            switch (ftype) {
                case 1: {
                    styleBuff.append(pattern);
                    break;
                }
                case 2: {
                    int tmpIdx;
                    for (tmpIdx = 0; tmpIdx < pattern.length(); ++tmpIdx) {
                        char ch = pattern.charAt(tmpIdx);
                        if (ch == 'D') continue;
                        styleBuff.append(ch);
                    }
                    break;
                }
                case 3: {
                    int tmpIdx;
                    for (tmpIdx = 0; tmpIdx < pattern.length(); ++tmpIdx) {
                        char ch = pattern.charAt(tmpIdx);
                        if (ch == 'Y') continue;
                        styleBuff.append(ch);
                    }
                    break;
                }
                case 4: {
                    int tmpIdx;
                    for (tmpIdx = 0; tmpIdx < pattern.length(); ++tmpIdx) {
                        char ch = pattern.charAt(tmpIdx);
                        if (ch != 'Y') continue;
                        styleBuff.append(ch);
                        styleBuff.append('Q');
                    }
                    break;
                }
            }
            if (flgDatetime == 0) {
                for (i3 = 0; i3 < 6; ++i3) {
                    ptnNLDATES[i3].setLength(0);
                }
            } else {
                for (i3 = 0; i3 < 5; ++i3) {
                    ptnNLDATMS[i3].setLength(0);
                }
            }
            block25: for (i3 = 0; i3 < styleBuff.length(); ++i3) {
                int j;
                if (flgDatetime == 0) {
                    switch (styleBuff.charAt(i3)) {
                        case 'Y': {
                            if (ptnNLDATES[0].length() > 0) {
                                ptnNLDATES[0].append(delim);
                            }
                            ptnNLDATES[0].append("yyyy");
                            if (ptnNLDATES[1].length() > 0) {
                                ptnNLDATES[1].append(delim);
                            }
                            ptnNLDATES[1].append("yy");
                            ptnNLDATES[2].append("yy");
                            break;
                        }
                        case 'M': {
                            for (j = 0; j <= 5; ++j) {
                                if ((j <= 1 || j == 3) && ptnNLDATES[j].length() > 0) {
                                    ptnNLDATES[j].append(delim);
                                }
                                ptnNLDATES[j].append("MM");
                            }
                            continue block25;
                        }
                        case 'D': {
                            for (j = 0; j <= 4; ++j) {
                                if ((j <= 1 || j == 3) && ptnNLDATES[j].length() > 0) {
                                    ptnNLDATES[j].append(delim);
                                }
                                ptnNLDATES[j].append("dd");
                            }
                            continue block25;
                        }
                        case 'Q': {
                            for (j = 0; j <= 2; ++j) {
                                if ((j <= 1 || j == 3) && ptnNLDATES[j].length() > 0) {
                                    ptnNLDATES[j].append(delim);
                                }
                                ptnNLDATES[j].append("QQ");
                            }
                            break;
                        }
                    }
                    continue;
                }
                switch (styleBuff.charAt(i3)) {
                    case 'Y': {
                        if (ptnNLDATMS[0].length() > 0) {
                            ptnNLDATMS[0].append(delim);
                        }
                        ptnNLDATMS[0].append("yyyy");
                        for (j = 1; j <= 3; ++j) {
                            if (ptnNLDATMS[j].length() > 0) {
                                ptnNLDATMS[j].append(delim);
                            }
                            ptnNLDATMS[j].append("yy");
                        }
                        ptnNLDATMS[4].append("yy");
                        continue block25;
                    }
                    case 'M': {
                        for (j = 0; j <= 4; ++j) {
                            if (j <= 3 && ptnNLDATMS[j].length() > 0) {
                                ptnNLDATMS[j].append(delim);
                            }
                            ptnNLDATMS[j].append("MM");
                        }
                        continue block25;
                    }
                    case 'D': {
                        for (j = 0; j <= 4; ++j) {
                            if (j <= 3 && ptnNLDATMS[j].length() > 0) {
                                ptnNLDATMS[j].append(delim);
                            }
                            ptnNLDATMS[j].append("dd");
                        }
                        continue block25;
                    }
                }
            }
            if (flgDatetime == 1) {
                if (this.isDateFirst()) {
                    ptnNLDATMS[0].append(" HH:mm:ss");
                    ptnNLDATMS[1].append(" HH:mm:ss");
                    ptnNLDATMS[2].append(" HH:mm");
                    ptnNLDATMS[3].append(" HH");
                    ptnNLDATMS[4].append(" HH");
                } else {
                    ptnNLDATMS[0].insert(0, "HH:mm:ss ");
                    ptnNLDATMS[1].insert(0, "HH:mm:ss ");
                    ptnNLDATMS[2].insert(0, "HH:mm ");
                    ptnNLDATMS[3].insert(0, "HH ");
                    ptnNLDATMS[4].insert(0, "HH ");
                }
            }
            int shortPatternwidth = 0;
            shortPatternwidth = shortPatternKey != null ? Integer.parseInt(this.getDatetimeString(shortPatternKey)) : (flgDatetime == 0 ? (ftype == 4 ? Integer.parseInt(this.getDatetimeString("d_fmt_yyqq_s.w")) : (ftype == 3 ? Integer.parseInt(this.getDatetimeString("d_fmt_mmdd_s.w")) : (ftype == 2 ? Integer.parseInt(this.getDatetimeString("d_fmt_yymm_s.w")) : Integer.parseInt(this.getDatetimeString("d_fmt_s.w"))))) : Integer.parseInt(this.getDatetimeString("d_t_fmt_s.w")));
            if (flgDatetime == 0) {
                shortEntry = new SingleEntry("NLDATES" + ftype + "w", "");
                if (ftype == 4) {
                    for (i2 = 1; i2 >= 0; --i2) {
                        tmpPattern = ptnNLDATES[i2].toString();
                        tmpPrePattern = i2 - 1 >= 0 ? ptnNLDATES[i2 - 1].toString() : null;
                        shortEntry.addPattern(tmpPattern.length() - 1, tmpPrePattern == null ? shortPatternwidth - 1 : tmpPrePattern.length() - 2, tmpPattern);
                    }
                } else {
                    for (i2 = 5; i2 >= 0; --i2) {
                        tmpPattern = ptnNLDATES[i2].toString();
                        tmpPrePattern = i2 - 1 >= 0 ? ptnNLDATES[i2 - 1].toString() : null;
                        shortEntry.addPattern(tmpPattern.length(), tmpPrePattern == null ? shortPatternwidth - 1 : tmpPrePattern.length() - 1, tmpPattern);
                    }
                }
                shortUniformEntryMap.put(new Integer(ftype), shortEntry);
                continue;
            }
            shortEntry = new SingleEntry("NLDATMS" + ftype + "w", "");
            for (i2 = 4; i2 >= 0; --i2) {
                tmpPattern = ptnNLDATMS[i2].toString();
                String string = tmpPrePattern = i2 - 1 >= 0 ? ptnNLDATMS[i2 - 1].toString() : null;
                if (i2 == 0) {
                    shortEntry.addPatternD(tmpPattern.length(), tmpPrePattern == null ? shortPatternwidth - 1 : tmpPrePattern.length() - 1, tmpPattern, true, true);
                    continue;
                }
                shortEntry.addPatternD(tmpPattern.length(), tmpPrePattern == null ? shortPatternwidth - 1 : tmpPrePattern.length() - 1, tmpPattern, false, false);
            }
            shortUniformEntryMap.put(new Integer(ftype), shortEntry);
        }
        return shortUniformEntryMap;
    }

    boolean isDateFirst() {
        String d_t_fmt_l = this.getDatetimeString("d_t_fmt_l");
        int lo_y = d_t_fmt_l.indexOf("yyyy");
        int lo_h = d_t_fmt_l.indexOf("hh");
        if (lo_h == -1) {
            lo_h = d_t_fmt_l.indexOf("HH");
        }
        return lo_y < lo_h;
    }

    protected void addAllPaterns(Vector applyPatterns, int defaultWidth, int max) {
        int index = 0;
        int size = applyPatterns.size();
        Entry newEntry = null;
        int tmpMax = 0;
        if (size > 0) {
            tmpMax = ((Entry)applyPatterns.get((int)(size - 1))).max;
        }
        if (max > 0) {
            tmpMax = max;
        }
        for (index = 0; index < size; ++index) {
            Entry entry = (Entry)applyPatterns.get(index);
            if (tmpMax < entry.max || max > 0 && index == size - 1) {
                newEntry = (Entry)entry.clone();
                newEntry.max = tmpMax;
            } else {
                newEntry = entry;
            }
            if (newEntry.min > newEntry.max) continue;
            if (defaultWidth > 0) {
                if (defaultWidth == newEntry.min) {
                    this.patterns.insertElementAt(newEntry, 0);
                    this.setMinWidth(Math.min(this.getMinWidth(), newEntry.min));
                    this.setMaxWidth(Math.max(this.getMaxWidth(), newEntry.max));
                    newEntry = null;
                } else if (defaultWidth > newEntry.min && defaultWidth <= newEntry.max) {
                    Entry defaultEntry = (Entry)newEntry.clone();
                    defaultEntry.min = defaultWidth;
                    this.patterns.insertElementAt(defaultEntry, 0);
                    this.setMinWidth(Math.min(this.getMinWidth(), defaultEntry.min));
                    this.setMaxWidth(Math.max(this.getMaxWidth(), defaultEntry.max));
                    newEntry.max = defaultWidth - 1;
                }
            }
            if (newEntry == null) continue;
            this.patterns.addElement(newEntry);
            this.setMinWidth(Math.min(this.getMinWidth(), newEntry.min));
            this.setMaxWidth(Math.max(this.getMaxWidth(), newEntry.max));
        }
    }

    @SASScope
    private class Entry
    implements Cloneable {
        public int min;
        public int max;
        public boolean isDatms = false;
        public String pattern;
        public boolean d = true;
        private String replacedPattern;
        private int m_style = -1;

        private Entry() {
        }

        public String getReplacedPattern() {
            try {
                if (SingleEntry.this.m_isReplaced && this.replacedPattern == null) {
                    this.replacedPattern = this.pattern.replace(SingleEntry.this.m_currencySymbol, SingleEntry.this.m_replacedLocalCurrencySymbol);
                }
                return this.replacedPattern;
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
                return null;
            }
        }

        public int getStyle() {
            return this.m_style;
        }

        public void setStyle(int style) {
            this.m_style = style;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

