/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SASURI;
import com.sas.services.connection.Server;
import java.util.Locale;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public abstract class TCPIPServer
extends Server {
    private static final long serialVersionUID = 4763548047827393826L;
    private String origHost = null;
    private String normHost = null;
    private int port = 0;

    public TCPIPServer(String classID, String host, int port) {
        super(classID);
        this.setHost(host);
        this.setPort(port);
    }

    public void setHost(String host) {
        if (host == null) {
            throw new IllegalArgumentException("\"host\" cannot be null.");
        }
        this.origHost = host;
        this.normHost = host.toLowerCase(Locale.US);
    }

    public String getHost() {
        return this.origHost;
    }

    public String getNormalizedHost() {
        return this.normHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String getOption(String name) {
        String value = null;
        value = "host".equals(name) ? this.getHost() : ("port".equals(name) ? Integer.toString(this.getPort()) : super.getOption(name));
        return value;
    }

    @Override
    public String setOption(String name, String value) {
        String previousValue = null;
        if ("host".equals(name)) {
            previousValue = this.getHost();
            this.setHost(value);
        } else if ("port".equals(name)) {
            previousValue = Integer.toString(this.getPort());
            this.setPort(Integer.parseInt(value));
        } else {
            previousValue = super.setOption(name, value);
        }
        return previousValue;
    }

    @Override
    public String removeOption(String name) {
        String previousValue = null;
        if ("host".equals(name)) {
            previousValue = this.getHost();
            this.setHost("");
        } else if ("port".equals(name)) {
            previousValue = Integer.toString(this.getPort());
            this.setPort(0);
        } else {
            previousValue = super.removeOption(name);
        }
        return previousValue;
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        TCPIPServer thatServer = (TCPIPServer)that;
        String thatNormHost = thatServer.getNormalizedHost();
        if (!this.normHost.equals(thatNormHost)) {
            return false;
        }
        int thatPort = thatServer.getPort();
        return this.port == thatPort;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        hc ^= this.normHost.hashCode();
        return hc ^= this.port;
    }

    @Override
    @SASScope
    protected String getEntryPoint() {
        String portS = Integer.toString(this.port);
        int portL = portS.length();
        int hostL = this.origHost.length();
        int bufL = hostL + SASURI.colonL + portL;
        StringBuffer buf = new StringBuffer(bufL);
        buf.append(this.origHost).append(":").append(portS);
        String entryPoint = buf.toString();
        return entryPoint;
    }
}

