# =============================================================================== #
#                                                                                 #
#    This file has been generated automatically!! Do not change this manually!    #
#                                                                                 #
# =============================================================================== #
from __future__ import annotations

from pydantic import Field

from ..base_object import BaseObject


class InputFile(BaseObject):
    """
    Points to a file
    
    """

    ID: str = Field("inputFile", alias="@type")


class InputFileGenerated(InputFile):
    """
    A file generated by the application
    
    Params:
        original_path (:class:`str`)
            Local path to a file from which the file is generated; may be empty if there is no such file
        
        conversion (:class:`str`)
            String specifying the conversion applied to the original file; should be persistent across application restarts. Conversions beginning with '#' are reserved for internal TDLib usage
        
        expected_size (:class:`int`)
            Expected size of the generated file; 0 if unknown
        
    """

    ID: str = Field("inputFileGenerated", alias="@type")
    original_path: str
    conversion: str
    expected_size: int

    @staticmethod
    def read(q: dict) -> InputFileGenerated:
        return InputFileGenerated.construct(**q)


class InputFileId(InputFile):
    """
    A file defined by its unique ID
    
    Params:
        id (:class:`int`)
            Unique file identifier
        
    """

    ID: str = Field("inputFileId", alias="@type")
    id: int

    @staticmethod
    def read(q: dict) -> InputFileId:
        return InputFileId.construct(**q)


class InputFileLocal(InputFile):
    """
    A file defined by a local path
    
    Params:
        path (:class:`str`)
            Local path to the file
        
    """

    ID: str = Field("inputFileLocal", alias="@type")
    path: str

    @staticmethod
    def read(q: dict) -> InputFileLocal:
        return InputFileLocal.construct(**q)


class InputFileRemote(InputFile):
    """
    A file defined by its remote ID. The remote ID is guaranteed to be usable only if the corresponding file is still accessible to the user and known to TDLib. For example, if the file is from a message, then the message must be not deleted and accessible to the user. If the file database is disabled, then the corresponding object with the file must be preloaded by the application
    
    Params:
        id (:class:`str`)
            Remote file identifier
        
    """

    ID: str = Field("inputFileRemote", alias="@type")
    id: str

    @staticmethod
    def read(q: dict) -> InputFileRemote:
        return InputFileRemote.construct(**q)
