# PyTekla: Python Library for the Tekla Open API

PyTekla is a Python library that provides a thin wrapper around the [Tekla Open API](https://developer.tekla.com/tekla-structures/api/22/8180), designed to make the experience more Pythonic. It simplifies the process of working with [Tekla Structures](https://www.tekla.com/us/products/tekla-structures) software, which is used in the construction industry for modeling and detailing building structures.

## What is the Tekla Open API?

The Tekla Open API is an application programming interface that allows developers to interact with the Tekla Structures software. Tekla Structures is used for 3D modeling and detailing of building structures, and is widely used in the construction industry. The API provides a range of tools and functions that allow developers to automate processes, integrate with other software tools, and customize the behavior of the Tekla Structures software.

## What does PyTekla do?

PyTekla provides a Pythonic interface to the Tekla Open API, which makes it easier to read and write code that interacts with the software. The library includes a range of classes and functions that simplify common tasks, such as creating new objects, modifying existing objects, and querying the properties of objects. Some of the benefits of using PyTekla include:

- **Pythonic syntax:** PyTekla uses Pythonic syntax, thanks to the use of wrapper classes that encapsulate the .NET classes provided by the Tekla Open API. This makes it easier to read and write code that interacts with the Tekla Open API, using idiomatic Python expressions and conventions.

- **Handy classes and functions:** PyTekla includes a range of handy classes and functions that make it easy to work with Tekla Structures objects and streamline common tasks. For example, PyTekla provides functions for converting between .NET types and Python types, making it easy to pass data between Tekla Structures and other Python libraries like NumPy and Pandas. PyTekla also includes wrapper classes for common Tekla Structures objects, which offer extra methods and functionality to facilitate the developer experience."

- **Use of CPython and ecosystem of libraries:** PyTekla is built on top of CPython, the reference implementation of the Python programming language, and uses the [Python.Net](https://github.com/pythonnet/pythonnet) library to interact with the .NET libraries provided by the Tekla Open API. This means that PyTekla can take advantage of the rich ecosystem of libraries and tools that are available for Python, such as NumPy and Pandas. With these libraries, it is possible to perform advanced calculations, data manipulation, and data analysis tasks with Tekla Structures data. 


## About Us

Made with :octicons-heart-fill-24:{ .heart } by [Eduardo](https://www.linkedin.com/in/ediloreto/) and [Natalia](https://www.linkedin.com/in/mnaa85/)

## Support our work

[!["Buy Me A Coffee"](https://www.buymeacoffee.com/assets/img/guidelines/download-assets-sm-1.svg)](https://www.buymeacoffee.com/mnaa85)

