import rdflib as rdf
import os, sys

#sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))
from ..core import Constants
from ..experiment import Core
from ..experiment.Core import getUUID
import prov.model as pm

class Derivative(pm.ProvActivity,Core):
    """Class for NIDM-Experimenent Derivative Objects.

    Default constructor uses empty graph with namespaces added from NIDM/Scripts/Constants.py.
    Additional alternate constructors for user-supplied graphs and default namespaces (i.e. from Constants.py)
    and user-supplied graph and namespaces

    @author: David Keator <dbkeator@uci.edu>
    @copyright: University of California, Irvine 2019

    """
    #constructor
    def __init__(self, project, attributes=None, uuid=None):
        """
        Default contructor, creates a derivative activity and links to project object

        :param project: the NIDM-E project to connect the derivative to
        :param uuid: optional uuid...used mostly for reading in existing NIDM document
        :param attributes: optional dictionary of attributes to add qname:value

        """
        if uuid is None:
            self._uuid = getUUID()
            #execute default parent class constructor
            super(Derivative,self).__init__(project.graph, pm.QualifiedName(pm.Namespace("niiri",Constants.NIIRI),self.get_uuid()),attributes)
        else:
            self._uuid = uuid
            super(Derivative,self).__init__(project.graph, pm.QualifiedName(pm.Namespace("niiri",Constants.NIIRI),self.get_uuid()),attributes)

        project.graph._add_record(self)

        self.add_attributes({pm.PROV_TYPE: pm.PROV_ACTIVITY})
        project.add_derivatives(self)
        self.graph = project.graph

        #list to store acquisition objects associated with this activity
        self._derivative_objects=[]
        #if constructor is called with a session object then add this acquisition to the session




    def add_derivative_object(self,derivative_object):
        """
        Adds derivative objects to derivative activity, creating links and adding reference to derivatives list

        :param derivative_object: object of type "DerivativeObject" from nidm API

        """
        #add acquisition object to self._acquisitions list
        self._derivative_objects.extend([derivative_object])
        #create links in graph
        self.graph.wasGeneratedBy(derivative_object,self)
    def get_derivative_objects(self):
        return self._derivative_objects
    def derivative_object_exists(self,uuid):
        '''
        Checks whether uuid is a registered derivative object
        :param uuid: full uuid of derivative
        :return: True if exists, False otherwise
        '''
        if uuid in self._derivative_objects:
            return True
        else:
            return False

    def __str__(self):
        return "NIDM-Experiment Derivative Class"
