import requests
from dacite import from_dict

from .data import DataSource, OracleScript, RequestInfo, DACITE_CONFIG


class Client(object):
    def __init__(self, rpc_url):
        self.rpc_url = rpc_url

    def _get(self, path, **kwargs):
        return requests.get(self.rpc_url + path, **kwargs).json()["result"]

    def get_data_source(self, id):
        return from_dict(
            data_class=DataSource,
            data=self._get("/oracle/data_sources/{}".format(id)),
            config=DACITE_CONFIG,
        )

    def get_oracle_script(self, id):
        return from_dict(
            data_class=OracleScript,
            data=self._get("/oracle/oracle_scripts/{}".format(id)),
            config=DACITE_CONFIG,
        )

    def get_request_by_id(self, id):
        return from_dict(
            data_class=RequestInfo,
            data=self._get("/oracle/requests/{}".format(id)),
            config=DACITE_CONFIG,
        )

    def get_latest_request(self, oid, calldata, min_count, ask_count):
        return from_dict(
            data_class=RequestInfo,
            data=self._get(
                "/oracle/request_search".format(self.rpc_url),
                params={
                    "oid": oid,
                    "calldata": calldata.hex(),
                    "min_count": min_count,
                    "ask_count": ask_count,
                },
            ),
            config=DACITE_CONFIG,
        )

