# Generated by Django 3.2.4 on 2021-06-23 19:26

import django.contrib.gis.db.models.fields
from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields
import rgd.models.mixins
import rgd.utility
import s3_file_field.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('rgd', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='FMV',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name='ID'
                    ),
                ),
                ('failure_reason', models.TextField(null=True)),
                (
                    'status',
                    models.CharField(
                        choices=[
                            ('created', 'Created but not queued'),
                            ('queued', 'Queued for processing'),
                            ('running', 'Processing'),
                            ('failed', 'Failed'),
                            ('success', 'Succeeded'),
                        ],
                        default='created',
                        max_length=20,
                    ),
                ),
                (
                    'created',
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name='modified'
                    ),
                ),
                (
                    'klv_file',
                    s3_file_field.fields.S3FileField(
                        null=True, upload_to=rgd.utility.uuid_prefix_filename
                    ),
                ),
                (
                    'web_video_file',
                    s3_file_field.fields.S3FileField(
                        null=True, upload_to=rgd.utility.uuid_prefix_filename
                    ),
                ),
                ('frame_rate', models.FloatField(null=True)),
                (
                    'file',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to='rgd.checksumfile'
                    ),
                ),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
            bases=(models.Model, rgd.models.mixins.PermissionPathMixin),
        ),
        migrations.CreateModel(
            name='FMVMeta',
            fields=[
                (
                    'spatialentry_ptr',
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to='rgd.spatialentry',
                    ),
                ),
                (
                    'created',
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name='modified'
                    ),
                ),
                ('ground_frames', django.contrib.gis.db.models.fields.MultiPolygonField(srid=4326)),
                ('ground_union', django.contrib.gis.db.models.fields.MultiPolygonField(srid=4326)),
                ('flight_path', django.contrib.gis.db.models.fields.MultiPointField(srid=4326)),
                ('frame_numbers', models.BinaryField()),
                (
                    'fmv_file',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE, to='rgd_fmv.fmv'
                    ),
                ),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
            bases=(
                'rgd.spatialentry',
                models.Model,
                rgd.models.mixins.PermissionPathMixin,
                rgd.models.mixins.DetailViewMixin,
            ),
        ),
    ]
