import setuptools

with open("readme.md", "r") as f:
    long_description = f.read()

setuptools.setup(
    name='labml_nn',
    version='0.4.77',
    author="Varuna Jayasiri, Nipun Wijerathne",
    author_email="vpjayasiri@gmail.com, hnipun@gmail.com",
    description="A collection of PyTorch implementations of neural network architectures and layers.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/lab-ml/labml_nn",
    project_urls={
        'Documentation': 'https://lab-ml.com/'
    },
    packages=setuptools.find_packages(exclude=('labml', 'labml.*',
                                               'labml_samples', 'labml_samples.*',
                                               'labml_helpers', 'labml_helpers.*',
                                               'test',
                                               'test.*')),
    install_requires=['labml>=0.4.86',
                      'labml_helpers>=0.4.72',
                      'torch',
                      'einops',
                      'numpy'],
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        'Intended Audience :: Developers',
        'Intended Audience :: Science/Research',
        'Topic :: Scientific/Engineering',
        'Topic :: Scientific/Engineering :: Mathematics',
        'Topic :: Scientific/Engineering :: Artificial Intelligence',
        'Topic :: Software Development',
        'Topic :: Software Development :: Libraries',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
    keywords='machine learning',
)
