# snaptrade-python-sdk
Connect brokerage accounts to your app for live positions and trading

This Python package is automatically generated by the [Konfig](https://konfigthis.com):

- API version: 1.0.0
- Package version: 2.4.0

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install snaptrade-python-sdk==2.4.0
```
(you may need to run `pip` with root permission: `sudo pip install snaptrade-python-sdk==2.4.0`)

Then import the package:
```python
import snaptrade_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
import os
import uuid
import snaptrade_client
from pprint import pprint
from snaptrade_client.api import api_status_api
from snaptrade_client.api import authentication_api
from snaptrade_client.api import account_information_api
from snaptrade_client.api import portfolio_management_api
from snaptrade_client.api import api_disclaimer_api
from snaptrade_client.model.portfolio_group import PortfolioGroup
from snaptrade_client.model.snap_trade_register_user_request_body import SnapTradeRegisterUserRequestBody
from snaptrade_client.model.api_disclaimer_accept_request import APIDisclaimerAcceptRequest

# 1) Initialize a client with your clientID and consumerKey.
configuration = snaptrade_client.Configuration(client_id=os.environ["SNAPTRADE_CLIENT_ID"],
                                            consumer_key=os.environ['SNAPTRADE_CONSUMER_KEY'])

with snaptrade_client.ApiClient(configuration) as api_client:
    # 2) Check that the client is able to make a request to the API server.
    api_status_api_inst = api_status_api.APIStatusApi(api_client)
    api_response = api_status_api_inst.check()
    pprint(api_response)

    # 3) Create a new user on SnapTrade
    user_id = str(uuid.uuid4())
    authentication_api_inst = authentication_api.AuthenticationApi(api_client)
    register_response = authentication_api_inst.register_snap_trade_user(
        SnapTradeRegisterUserRequestBody(user_id=user_id))
    pprint(register_response)

    # Note: A user secret is only generated once. It's required to access
    # resources for certain endpoints.
    user_secret = register_response.user_secret

    # 4) Get a redirect URI. Users will need this to connect
    # their brokerage to the SnapTrade server.
    redirect_uri = authentication_api_inst.login_snap_trade_user(user_id, user_secret)
    print(redirect_uri)

    portfolio_management_api_inst = portfolio_management_api.PortfolioManagementApi(api_client)
    portfolio_management_api_inst.create(user_id, user_secret,
                                                        PortfolioGroup(id=str(uuid.uuid4()), name="MyPortfolio"))
    res = portfolio_management_api_inst.list(user_id, user_secret)
    pprint(res)

    api_disclaimer_api_inst = api_disclaimer_api.APIDisclaimerApi(api_client)
    api_disclaimer_api_inst.accept(user_id, user_secret, APIDisclaimerAcceptRequest(accepted=True))

    # 5) Obtaining account holdings data
    account_information_api_inst = account_information_api.AccountInformationApi(api_client)
    holdings = account_information_api_inst.get_all_user_holdings(user_id, user_secret)
    pprint(holdings)

    # 6) Deleting a user
    deleted_response = authentication_api_inst.delete_snap_trade_user(user_id)
    pprint(deleted_response)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.snaptrade.com/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIDisclaimerApi* | [**accept**](docs/APIDisclaimerApi.md#accept) | **POST** /snapTrade/acceptDisclaimer | Accept or Reject SnapTrade disclaimer agreement
*APIStatusApi* | [**check**](docs/APIStatusApi.md#check) | **GET** / | Get API Status
*AccountInformationApi* | [**get_all_user_holdings**](docs/AccountInformationApi.md#get_all_user_holdings) | **GET** /holdings | List all accounts for the user, plus balances and positions for each account.
*AccountInformationApi* | [**get_user_account_balance**](docs/AccountInformationApi.md#get_user_account_balance) | **GET** /accounts/{accountId}/balances | Get all cash balances of an investment account
*AccountInformationApi* | [**get_user_account_details**](docs/AccountInformationApi.md#get_user_account_details) | **GET** /accounts/{accountId} | Return details of a specific investment account
*AccountInformationApi* | [**get_user_account_orders**](docs/AccountInformationApi.md#get_user_account_orders) | **GET** /accounts/{accountId}/orders | Get all history of orders placed in account
*AccountInformationApi* | [**get_user_account_positions**](docs/AccountInformationApi.md#get_user_account_positions) | **GET** /accounts/{accountId}/positions | Get all positions of an investment account
*AccountInformationApi* | [**get_user_holdings**](docs/AccountInformationApi.md#get_user_holdings) | **GET** /accounts/{accountId}/holdings | List balances, positions and orders for the specified account.
*AccountInformationApi* | [**list_user_accounts**](docs/AccountInformationApi.md#list_user_accounts) | **GET** /accounts | List all investment accounts for the user
*AccountInformationApi* | [**update_user_account**](docs/AccountInformationApi.md#update_user_account) | **PUT** /accounts/{accountId} | Update details of an investment account
*AuthenticationApi* | [**delete_snap_trade_user**](docs/AuthenticationApi.md#delete_snap_trade_user) | **DELETE** /snapTrade/deleteUser | Delete user from SnapTrade, disabling all brokerage authorizations and permanently deleting all data associated with the user
*AuthenticationApi* | [**get_user_jwt**](docs/AuthenticationApi.md#get_user_jwt) | **GET** /snapTrade/encryptedJWT | Obtains an encrypted JWT tokens that should be decrypted on a user&#39;s local device
*AuthenticationApi* | [**list_snap_trade_users**](docs/AuthenticationApi.md#list_snap_trade_users) | **GET** /snapTrade/listUsers | Get a list of all SnapTrade users you&#39;ve registered on our platform
*AuthenticationApi* | [**login_snap_trade_user**](docs/AuthenticationApi.md#login_snap_trade_user) | **POST** /snapTrade/login | Generate a redirect URI to securely login a user to the SnapTrade Connection Portal
*AuthenticationApi* | [**register_snap_trade_user**](docs/AuthenticationApi.md#register_snap_trade_user) | **POST** /snapTrade/registerUser | Register user with SnapTrade in order to create secure brokerage authorizations
*ConnectionsApi* | [**detail_brokerage_authorization**](docs/ConnectionsApi.md#detail_brokerage_authorization) | **GET** /authorizations/{authorizationId} | Get detail of a specific brokerage authorizations for the user
*ConnectionsApi* | [**list_brokerage_authorizations**](docs/ConnectionsApi.md#list_brokerage_authorizations) | **GET** /authorizations | List all brokerage authorizations for the user
*ConnectionsApi* | [**remove_brokerage_authorization**](docs/ConnectionsApi.md#remove_brokerage_authorization) | **DELETE** /authorizations/{authorizationId} | Remove a brokerage authorization.
*ErrorLogsApi* | [**list_user_errors**](docs/ErrorLogsApi.md#list_user_errors) | **GET** /snapTrade/listUserErrors | Retrieve error logs on behalf of your SnapTrade users
*OptionsApi* | [**get_option_strategy**](docs/OptionsApi.md#get_option_strategy) | **POST** /accounts/{accountId}/optionStrategy | Creates an option strategy object that will be used to place an option strategy order
*OptionsApi* | [**get_options_chain**](docs/OptionsApi.md#get_options_chain) | **GET** /accounts/{accountId}/optionsChain | Get the options chain
*OptionsApi* | [**get_options_strategy_quote**](docs/OptionsApi.md#get_options_strategy_quote) | **GET** /accounts/{accountId}/optionStrategy/{optionStrategyId} | Get latest market data of option strategy
*OptionsApi* | [**list_option_holdings**](docs/OptionsApi.md#list_option_holdings) | **GET** /accounts/{accountId}/options | Get the options holdings in the account
*OptionsApi* | [**place_option_strategy**](docs/OptionsApi.md#place_option_strategy) | **POST** /accounts/{accountId}/optionStrategy/{optionStrategyId}/execute | Place an option strategy order on the brokerage
*PortfolioManagementApi* | [**add_portfolio_excluded_asset**](docs/PortfolioManagementApi.md#add_portfolio_excluded_asset) | **POST** /portfolioGroups/{portfolioGroupId}/excludedassets | Adds an asset to exclude to a portfolio group
*PortfolioManagementApi* | [**create**](docs/PortfolioManagementApi.md#create) | **POST** /portfolioGroups | Create new portfolio group
*PortfolioManagementApi* | [**create_asset_class**](docs/PortfolioManagementApi.md#create_asset_class) | **POST** /modelAssetClass | Create a new model asset class
*PortfolioManagementApi* | [**create_model_portfolio**](docs/PortfolioManagementApi.md#create_model_portfolio) | **POST** /modelPortfolio | Creates a new model portfolio
*PortfolioManagementApi* | [**delete_asset_class**](docs/PortfolioManagementApi.md#delete_asset_class) | **DELETE** /modelAssetClass/{modelAssetClassId} | Deletes a model asset class
*PortfolioManagementApi* | [**delete_excluded_asset**](docs/PortfolioManagementApi.md#delete_excluded_asset) | **DELETE** /portfolioGroups/{portfolioGroupId}/excludedassets/{symbolId} | Unexclude an asset from a portfolio group
*PortfolioManagementApi* | [**delete_model_portfolio_by_id**](docs/PortfolioManagementApi.md#delete_model_portfolio_by_id) | **DELETE** /modelPortfolio/{modelPortfolioId} | Deletes a model portfolio
*PortfolioManagementApi* | [**delete_portfoli**](docs/PortfolioManagementApi.md#delete_portfoli) | **DELETE** /portfolioGroups/{portfolioGroupId} | Remove a target portfolio.
*PortfolioManagementApi* | [**delete_portfolio_target_by_id**](docs/PortfolioManagementApi.md#delete_portfolio_target_by_id) | **DELETE** /portfolioGroups/{portfolioGroupId}/targets/{targetAssetId} | Remove a TargetAsset.
*PortfolioManagementApi* | [**detail_asset_class**](docs/PortfolioManagementApi.md#detail_asset_class) | **GET** /modelAssetClass/{modelAssetClassId} | Get details of a model asset class
*PortfolioManagementApi* | [**get_calculated_trade_by_id**](docs/PortfolioManagementApi.md#get_calculated_trade_by_id) | **GET** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/{TradeId} | Return an individual trade
*PortfolioManagementApi* | [**get_model_details_by_id**](docs/PortfolioManagementApi.md#get_model_details_by_id) | **GET** /modelPortfolio/{modelPortfolioId} | Get details of a model portfolio
*PortfolioManagementApi* | [**get_portfolio_balances**](docs/PortfolioManagementApi.md#get_portfolio_balances) | **GET** /portfolioGroups/{portfolioGroupId}/balances | Get sum of cash balances in portfolio group
*PortfolioManagementApi* | [**get_portfolio_details_by_id**](docs/PortfolioManagementApi.md#get_portfolio_details_by_id) | **GET** /portfolioGroups/{portfolioGroupId} | Get details of a target portfolio
*PortfolioManagementApi* | [**get_portfolio_info**](docs/PortfolioManagementApi.md#get_portfolio_info) | **GET** /portfolioGroups/{portfolioGroupId}/info | Return a whole bunch of relevant information relating to a portfolio group.
*PortfolioManagementApi* | [**get_portfolio_positions**](docs/PortfolioManagementApi.md#get_portfolio_positions) | **GET** /portfolioGroups/{portfolioGroupId}/positions | Get total of each postions owned in portfolio group
*PortfolioManagementApi* | [**get_portfolio_settings**](docs/PortfolioManagementApi.md#get_portfolio_settings) | **GET** /portfolioGroups/{portfolioGroupId}/settings | Get portfolio group settings
*PortfolioManagementApi* | [**get_portfolio_target_by_id**](docs/PortfolioManagementApi.md#get_portfolio_target_by_id) | **GET** /portfolioGroups/{portfolioGroupId}/targets/{targetAssetId} | Get a specific target from a portfolio group
*PortfolioManagementApi* | [**get_portfolio_targets**](docs/PortfolioManagementApi.md#get_portfolio_targets) | **GET** /portfolioGroups/{portfolioGroupId}/targets | Get all target assets under the specified PortfolioGroup.
*PortfolioManagementApi* | [**get_portoflio_excluded_assets**](docs/PortfolioManagementApi.md#get_portoflio_excluded_assets) | **GET** /portfolioGroups/{portfolioGroupId}/excludedassets | Get an array of excluded assets associated with a portfolio group\\
*PortfolioManagementApi* | [**import_model_portfolio**](docs/PortfolioManagementApi.md#import_model_portfolio) | **POST** /portfolioGroups/{portfolioGroupId}/import | Import target allocation based on portfolio group
*PortfolioManagementApi* | [**list**](docs/PortfolioManagementApi.md#list) | **GET** /portfolioGroups | List all portfolio groups
*PortfolioManagementApi* | [**list_asset_classes**](docs/PortfolioManagementApi.md#list_asset_classes) | **GET** /modelAssetClass | List of model asset class
*PortfolioManagementApi* | [**list_calculated_trades**](docs/PortfolioManagementApi.md#list_calculated_trades) | **GET** /portfolioGroups/{portfolioGroupId}/calculatedtrades | List of trades to make to rebalance portfolio group
*PortfolioManagementApi* | [**list_model_portfolio**](docs/PortfolioManagementApi.md#list_model_portfolio) | **GET** /modelPortfolio | List of model portfolio
*PortfolioManagementApi* | [**list_portfolio_accounts**](docs/PortfolioManagementApi.md#list_portfolio_accounts) | **GET** /portfolioGroups/{portfolioGroupId}/accounts | Get all accounts associated with a portfolio group
*PortfolioManagementApi* | [**modify_model_portfolio_by_id**](docs/PortfolioManagementApi.md#modify_model_portfolio_by_id) | **POST** /modelPortfolio/{modelPortfolioId} | Updates model portfolio object
*PortfolioManagementApi* | [**save_portfolio**](docs/PortfolioManagementApi.md#save_portfolio) | **PATCH** /portfolioGroups/{portfolioGroupId} | Update an existing target portfolio.
*PortfolioManagementApi* | [**search_portfolio_symbols**](docs/PortfolioManagementApi.md#search_portfolio_symbols) | **POST** /portfolioGroups/{portfolioGroupId}/symbols | Search for symbols limited to brokerages under the specified portfolio group
*PortfolioManagementApi* | [**set_portfolio_targets**](docs/PortfolioManagementApi.md#set_portfolio_targets) | **POST** /portfolioGroups/{portfolioGroupId}/targets | Set a new list of target assets under the specified PortfolioGroup. All existing target assets under this portfolio group will be replaced with the new list.
*PortfolioManagementApi* | [**update_asset_class**](docs/PortfolioManagementApi.md#update_asset_class) | **POST** /modelAssetClass/{modelAssetClassId} | Updates model asset class objects
*PortfolioManagementApi* | [**update_portfolio_settings**](docs/PortfolioManagementApi.md#update_portfolio_settings) | **PATCH** /portfolioGroups/{portfolioGroupId}/settings | Updates portfolio group settings
*PortfolioManagementApi* | [**update_portfolio_target_by_id**](docs/PortfolioManagementApi.md#update_portfolio_target_by_id) | **PATCH** /portfolioGroups/{portfolioGroupId}/targets/{targetAssetId} | Update a TargetAsset under the specified PortfolioGroup.
*ReferenceDataApi* | [**get_currency_exchange_rate_pair**](docs/ReferenceDataApi.md#get_currency_exchange_rate_pair) | **GET** /currencies/rates/{currencyPair} | Return the exchange rate of a currency pair
*ReferenceDataApi* | [**get_partner_info**](docs/ReferenceDataApi.md#get_partner_info) | **GET** /snapTrade/partners | Get metadata related to Snaptrade partner
*ReferenceDataApi* | [**get_security_types**](docs/ReferenceDataApi.md#get_security_types) | **GET** /securityTypes | List of all security types.
*ReferenceDataApi* | [**get_stock_exchanges**](docs/ReferenceDataApi.md#get_stock_exchanges) | **GET** /exchanges | Return list of stock exchanges on Passiv and their suffixes
*ReferenceDataApi* | [**get_symbols**](docs/ReferenceDataApi.md#get_symbols) | **POST** /symbols | Search for symbols
*ReferenceDataApi* | [**get_symbols_by_ticker**](docs/ReferenceDataApi.md#get_symbols_by_ticker) | **GET** /symbols/{ticker} | Get details of a symbol by the ticker
*ReferenceDataApi* | [**list_all_brokerage_authorization_type**](docs/ReferenceDataApi.md#list_all_brokerage_authorization_type) | **GET** /brokerageAuthorizationTypes | List of all brokerage authorization types
*ReferenceDataApi* | [**list_all_brokerages**](docs/ReferenceDataApi.md#list_all_brokerages) | **GET** /brokerages | List of all brokerages.
*ReferenceDataApi* | [**list_all_currencies**](docs/ReferenceDataApi.md#list_all_currencies) | **GET** /currencies | List of all supported currencies
*ReferenceDataApi* | [**list_all_currencies_rates**](docs/ReferenceDataApi.md#list_all_currencies_rates) | **GET** /currencies/rates | Return the exchange rates of all supported currencies
*ReferenceDataApi* | [**symbol_search_user_account**](docs/ReferenceDataApi.md#symbol_search_user_account) | **POST** /accounts/{accountId}/symbols | Search for symbols that are supported by a brokerage account using a substring
*TradingApi* | [**cancel_user_account_order**](docs/TradingApi.md#cancel_user_account_order) | **POST** /accounts/{accountId}/orders/cancel | Cancel open order in account
*TradingApi* | [**get_calculated_trade_impact_by_id**](docs/TradingApi.md#get_calculated_trade_impact_by_id) | **GET** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/modify/{tradeId} | Return details of a specific trade before it&#39;s placed
*TradingApi* | [**get_calculated_trades_impact**](docs/TradingApi.md#get_calculated_trades_impact) | **GET** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/impact | Return the impact of placing a series of trades on the portfolio
*TradingApi* | [**get_order_impact**](docs/TradingApi.md#get_order_impact) | **POST** /trade/impact | Check impact of trades on account.
*TradingApi* | [**get_user_account_quotes**](docs/TradingApi.md#get_user_account_quotes) | **GET** /accounts/{accountId}/quotes | Get symbol quotes
*TradingApi* | [**modify_calculated_trade_by_id**](docs/TradingApi.md#modify_calculated_trade_by_id) | **PATCH** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/modify/{tradeId} | Modify units of a trade before it is placed
*TradingApi* | [**place_calculated_trades**](docs/TradingApi.md#place_calculated_trades) | **POST** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/placeOrders | Place orders for the CalculatedTrades in series
*TradingApi* | [**place_force_order**](docs/TradingApi.md#place_force_order) | **POST** /trade/place | Place a trade with NO validation.
*TradingApi* | [**place_oco_order**](docs/TradingApi.md#place_oco_order) | **POST** /trade/oco | Place a OCO (One Cancels Other) order
*TradingApi* | [**place_order**](docs/TradingApi.md#place_order) | **POST** /trade/{tradeId} | Place order
*TransactionsAndReportingApi* | [**get_activities**](docs/TransactionsAndReportingApi.md#get_activities) | **GET** /activities | Get transaction history for a user
*TransactionsAndReportingApi* | [**get_reporting_custom_range**](docs/TransactionsAndReportingApi.md#get_reporting_custom_range) | **GET** /performance/custom | Get performance information for a specific timeframe


## Documentation For Models

 - [APIDisclaimerAcceptRequest](docs/APIDisclaimerAcceptRequest.md)
 - [Account](docs/Account.md)
 - [AccountHoldings](docs/AccountHoldings.md)
 - [AccountOrderRecord](docs/AccountOrderRecord.md)
 - [AccountOrderRecordStatus](docs/AccountOrderRecordStatus.md)
 - [AccountSimple](docs/AccountSimple.md)
 - [Action](docs/Action.md)
 - [AuthenticationLoginSnapTradeUser200Response](docs/AuthenticationLoginSnapTradeUser200Response.md)
 - [Balance](docs/Balance.md)
 - [Brokerage](docs/Brokerage.md)
 - [BrokerageAuthorization](docs/BrokerageAuthorization.md)
 - [BrokerageAuthorizationType](docs/BrokerageAuthorizationType.md)
 - [BrokerageAuthorizationTypeReadOnly](docs/BrokerageAuthorizationTypeReadOnly.md)
 - [BrokerageAuthorizationTypeReadOnlyBrokerage](docs/BrokerageAuthorizationTypeReadOnlyBrokerage.md)
 - [BrokerageSymbol](docs/BrokerageSymbol.md)
 - [BrokerageType](docs/BrokerageType.md)
 - [CalculatedTrade](docs/CalculatedTrade.md)
 - [CashRestriction](docs/CashRestriction.md)
 - [Currency](docs/Currency.md)
 - [DeleteUserResponse](docs/DeleteUserResponse.md)
 - [DividendAtDate](docs/DividendAtDate.md)
 - [EncryptedResponse](docs/EncryptedResponse.md)
 - [EncryptedResponseEncryptedMessageData](docs/EncryptedResponseEncryptedMessageData.md)
 - [Exchange](docs/Exchange.md)
 - [ExchangeRatePairs](docs/ExchangeRatePairs.md)
 - [ExcludedAsset](docs/ExcludedAsset.md)
 - [JWT](docs/JWT.md)
 - [LoginRedirectURI](docs/LoginRedirectURI.md)
 - [ManualTrade](docs/ManualTrade.md)
 - [ManualTradeAndImpact](docs/ManualTradeAndImpact.md)
 - [ManualTradeBalance](docs/ManualTradeBalance.md)
 - [ManualTradeForm](docs/ManualTradeForm.md)
 - [ManualTradeSymbol](docs/ManualTradeSymbol.md)
 - [Model400FailedRequestResponse](docs/Model400FailedRequestResponse.md)
 - [Model401FailedRequestResponse](docs/Model401FailedRequestResponse.md)
 - [Model403FailedRequestResponse](docs/Model403FailedRequestResponse.md)
 - [Model404FailedRequestResponse](docs/Model404FailedRequestResponse.md)
 - [ModelAssetClass](docs/ModelAssetClass.md)
 - [ModelAssetClassDetails](docs/ModelAssetClassDetails.md)
 - [ModelAssetClassTarget](docs/ModelAssetClassTarget.md)
 - [ModelPortfolio](docs/ModelPortfolio.md)
 - [ModelPortfolioAssetClass](docs/ModelPortfolioAssetClass.md)
 - [ModelPortfolioDetails](docs/ModelPortfolioDetails.md)
 - [ModelPortfolioSecurity](docs/ModelPortfolioSecurity.md)
 - [MonthlyDividends](docs/MonthlyDividends.md)
 - [NetContributions](docs/NetContributions.md)
 - [NetDividend](docs/NetDividend.md)
 - [OptionChain](docs/OptionChain.md)
 - [OptionChainInner](docs/OptionChainInner.md)
 - [OptionChainInnerChainPerRootInner](docs/OptionChainInnerChainPerRootInner.md)
 - [OptionChainInnerChainPerRootInnerChainPerStrikePriceInner](docs/OptionChainInnerChainPerRootInnerChainPerStrikePriceInner.md)
 - [OptionLeg](docs/OptionLeg.md)
 - [OptionStrategy](docs/OptionStrategy.md)
 - [OptionStrategyLegsInner](docs/OptionStrategyLegsInner.md)
 - [OptionsGetOptionStrategyRequest](docs/OptionsGetOptionStrategyRequest.md)
 - [OptionsHoldings](docs/OptionsHoldings.md)
 - [OptionsPlaceOptionStrategyRequest](docs/OptionsPlaceOptionStrategyRequest.md)
 - [OptionsPosition](docs/OptionsPosition.md)
 - [OptionsSymbol](docs/OptionsSymbol.md)
 - [OrderType](docs/OrderType.md)
 - [PartnerData](docs/PartnerData.md)
 - [PastValue](docs/PastValue.md)
 - [Percent](docs/Percent.md)
 - [PerformanceCustom](docs/PerformanceCustom.md)
 - [PortfolioGroup](docs/PortfolioGroup.md)
 - [PortfolioGroupInfo](docs/PortfolioGroupInfo.md)
 - [PortfolioGroupPosition](docs/PortfolioGroupPosition.md)
 - [PortfolioGroupSettings](docs/PortfolioGroupSettings.md)
 - [Position](docs/Position.md)
 - [PositionSymbol](docs/PositionSymbol.md)
 - [RedirectTokenandPin](docs/RedirectTokenandPin.md)
 - [SecurityType](docs/SecurityType.md)
 - [SnapTradeAPIDisclaimerAcceptStatus](docs/SnapTradeAPIDisclaimerAcceptStatus.md)
 - [SnapTradeHoldingsAccount](docs/SnapTradeHoldingsAccount.md)
 - [SnapTradeHoldingsTotalValue](docs/SnapTradeHoldingsTotalValue.md)
 - [SnapTradeLoginUserRequestBody](docs/SnapTradeLoginUserRequestBody.md)
 - [SnapTradeRegisterUserRequestBody](docs/SnapTradeRegisterUserRequestBody.md)
 - [Status](docs/Status.md)
 - [StrategyImpact](docs/StrategyImpact.md)
 - [StrategyImpactLegsInner](docs/StrategyImpactLegsInner.md)
 - [StrategyOrderPlace](docs/StrategyOrderPlace.md)
 - [StrategyOrderPlaceOrdersInner](docs/StrategyOrderPlaceOrdersInner.md)
 - [StrategyOrderPlaceOrdersInnerLegsInner](docs/StrategyOrderPlaceOrdersInnerLegsInner.md)
 - [StrategyOrderRecord](docs/StrategyOrderRecord.md)
 - [StrategyQuotes](docs/StrategyQuotes.md)
 - [StrategyQuotesGreek](docs/StrategyQuotesGreek.md)
 - [SubPeriodReturnRate](docs/SubPeriodReturnRate.md)
 - [Symbol](docs/Symbol.md)
 - [SymbolQuery](docs/SymbolQuery.md)
 - [SymbolsQuotes](docs/SymbolsQuotes.md)
 - [TargetAsset](docs/TargetAsset.md)
 - [TargetAssetList](docs/TargetAssetList.md)
 - [TimeInForce](docs/TimeInForce.md)
 - [Trade](docs/Trade.md)
 - [TradeExecutionStatus](docs/TradeExecutionStatus.md)
 - [TradeImpact](docs/TradeImpact.md)
 - [TradingPlaceOCOOrderRequest](docs/TradingPlaceOCOOrderRequest.md)
 - [USExchange](docs/USExchange.md)
 - [UnderlyingSymbol](docs/UnderlyingSymbol.md)
 - [UniversalActivity](docs/UniversalActivity.md)
 - [UniversalSymbol](docs/UniversalSymbol.md)
 - [UniversalSymbolTicker](docs/UniversalSymbolTicker.md)
 - [UserErrorLog](docs/UserErrorLog.md)
 - [UserIDandSecret](docs/UserIDandSecret.md)
 - [UserList](docs/UserList.md)
 - [UserSettings](docs/UserSettings.md)


## Documentation For Authorization


## PartnerClientId

- **Type**: API key
- **API key parameter name**: clientId
- **Location**: URL query string


## PartnerSignature

- **Type**: API key
- **API key parameter name**: Signature
- **Location**: HTTP header


## PartnerTimestamp

- **Type**: API key
- **API key parameter name**: timestamp
- **Location**: URL query string


## Author

api@snaptrade.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in snaptrade_client.apis and snaptrade_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from snaptrade_client.api.default_api import DefaultApi`
- `from snaptrade_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import snaptrade_client
from snaptrade_client.apis import *
from snaptrade_client.models import *
```

