# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from .signrpc import signer_pb2 as signrpc_dot_signer__pb2
from .walletrpc import walletkit_pb2 as walletrpc_dot_walletkit__pb2


class WalletKitStub(object):
    """WalletKit is a service that gives access to the core functionalities of the
    daemon's wallet.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.ListUnspent = channel.unary_unary(
                '/walletrpc.WalletKit/ListUnspent',
                request_serializer=walletrpc_dot_walletkit__pb2.ListUnspentRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.ListUnspentResponse.FromString,
                )
        self.LeaseOutput = channel.unary_unary(
                '/walletrpc.WalletKit/LeaseOutput',
                request_serializer=walletrpc_dot_walletkit__pb2.LeaseOutputRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.LeaseOutputResponse.FromString,
                )
        self.ReleaseOutput = channel.unary_unary(
                '/walletrpc.WalletKit/ReleaseOutput',
                request_serializer=walletrpc_dot_walletkit__pb2.ReleaseOutputRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.ReleaseOutputResponse.FromString,
                )
        self.ListLeases = channel.unary_unary(
                '/walletrpc.WalletKit/ListLeases',
                request_serializer=walletrpc_dot_walletkit__pb2.ListLeasesRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.ListLeasesResponse.FromString,
                )
        self.DeriveNextKey = channel.unary_unary(
                '/walletrpc.WalletKit/DeriveNextKey',
                request_serializer=walletrpc_dot_walletkit__pb2.KeyReq.SerializeToString,
                response_deserializer=signrpc_dot_signer__pb2.KeyDescriptor.FromString,
                )
        self.DeriveKey = channel.unary_unary(
                '/walletrpc.WalletKit/DeriveKey',
                request_serializer=signrpc_dot_signer__pb2.KeyLocator.SerializeToString,
                response_deserializer=signrpc_dot_signer__pb2.KeyDescriptor.FromString,
                )
        self.NextAddr = channel.unary_unary(
                '/walletrpc.WalletKit/NextAddr',
                request_serializer=walletrpc_dot_walletkit__pb2.AddrRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.AddrResponse.FromString,
                )
        self.ListAccounts = channel.unary_unary(
                '/walletrpc.WalletKit/ListAccounts',
                request_serializer=walletrpc_dot_walletkit__pb2.ListAccountsRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.ListAccountsResponse.FromString,
                )
        self.ImportAccount = channel.unary_unary(
                '/walletrpc.WalletKit/ImportAccount',
                request_serializer=walletrpc_dot_walletkit__pb2.ImportAccountRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.ImportAccountResponse.FromString,
                )
        self.ImportPublicKey = channel.unary_unary(
                '/walletrpc.WalletKit/ImportPublicKey',
                request_serializer=walletrpc_dot_walletkit__pb2.ImportPublicKeyRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.ImportPublicKeyResponse.FromString,
                )
        self.PublishTransaction = channel.unary_unary(
                '/walletrpc.WalletKit/PublishTransaction',
                request_serializer=walletrpc_dot_walletkit__pb2.Transaction.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.PublishResponse.FromString,
                )
        self.SendOutputs = channel.unary_unary(
                '/walletrpc.WalletKit/SendOutputs',
                request_serializer=walletrpc_dot_walletkit__pb2.SendOutputsRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.SendOutputsResponse.FromString,
                )
        self.EstimateFee = channel.unary_unary(
                '/walletrpc.WalletKit/EstimateFee',
                request_serializer=walletrpc_dot_walletkit__pb2.EstimateFeeRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.EstimateFeeResponse.FromString,
                )
        self.PendingSweeps = channel.unary_unary(
                '/walletrpc.WalletKit/PendingSweeps',
                request_serializer=walletrpc_dot_walletkit__pb2.PendingSweepsRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.PendingSweepsResponse.FromString,
                )
        self.BumpFee = channel.unary_unary(
                '/walletrpc.WalletKit/BumpFee',
                request_serializer=walletrpc_dot_walletkit__pb2.BumpFeeRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.BumpFeeResponse.FromString,
                )
        self.ListSweeps = channel.unary_unary(
                '/walletrpc.WalletKit/ListSweeps',
                request_serializer=walletrpc_dot_walletkit__pb2.ListSweepsRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.ListSweepsResponse.FromString,
                )
        self.LabelTransaction = channel.unary_unary(
                '/walletrpc.WalletKit/LabelTransaction',
                request_serializer=walletrpc_dot_walletkit__pb2.LabelTransactionRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.LabelTransactionResponse.FromString,
                )
        self.FundPsbt = channel.unary_unary(
                '/walletrpc.WalletKit/FundPsbt',
                request_serializer=walletrpc_dot_walletkit__pb2.FundPsbtRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.FundPsbtResponse.FromString,
                )
        self.FinalizePsbt = channel.unary_unary(
                '/walletrpc.WalletKit/FinalizePsbt',
                request_serializer=walletrpc_dot_walletkit__pb2.FinalizePsbtRequest.SerializeToString,
                response_deserializer=walletrpc_dot_walletkit__pb2.FinalizePsbtResponse.FromString,
                )


class WalletKitServicer(object):
    """WalletKit is a service that gives access to the core functionalities of the
    daemon's wallet.
    """

    def ListUnspent(self, request, context):
        """
        ListUnspent returns a list of all utxos spendable by the wallet with a
        number of confirmations between the specified minimum and maximum.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def LeaseOutput(self, request, context):
        """
        LeaseOutput locks an output to the given ID, preventing it from being
        available for any future coin selection attempts. The absolute time of the
        lock's expiration is returned. The expiration of the lock can be extended by
        successive invocations of this RPC. Outputs can be unlocked before their
        expiration through `ReleaseOutput`.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ReleaseOutput(self, request, context):
        """
        ReleaseOutput unlocks an output, allowing it to be available for coin
        selection if it remains unspent. The ID should match the one used to
        originally lock the output.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListLeases(self, request, context):
        """
        ListLeases lists all currently locked utxos.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeriveNextKey(self, request, context):
        """
        DeriveNextKey attempts to derive the *next* key within the key family
        (account in BIP43) specified. This method should return the next external
        child within this branch.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeriveKey(self, request, context):
        """
        DeriveKey attempts to derive an arbitrary key specified by the passed
        KeyLocator.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def NextAddr(self, request, context):
        """
        NextAddr returns the next unused address within the wallet.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListAccounts(self, request, context):
        """
        ListAccounts retrieves all accounts belonging to the wallet by default. A
        name and key scope filter can be provided to filter through all of the
        wallet accounts and return only those matching.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ImportAccount(self, request, context):
        """
        ImportAccount imports an account backed by an account extended public key.
        The master key fingerprint denotes the fingerprint of the root key
        corresponding to the account public key (also known as the key with
        derivation path m/). This may be required by some hardware wallets for
        proper identification and signing.

        The address type can usually be inferred from the key's version, but may be
        required for certain keys to map them into the proper scope.

        For BIP-0044 keys, an address type must be specified as we intend to not
        support importing BIP-0044 keys into the wallet using the legacy
        pay-to-pubkey-hash (P2PKH) scheme. A nested witness address type will force
        the standard BIP-0049 derivation scheme, while a witness address type will
        force the standard BIP-0084 derivation scheme.

        For BIP-0049 keys, an address type must also be specified to make a
        distinction between the standard BIP-0049 address schema (nested witness
        pubkeys everywhere) and our own BIP-0049Plus address schema (nested pubkeys
        externally, witness pubkeys internally).

        NOTE: Events (deposits/spends) for keys derived from an account will only be
        detected by lnd if they happen after the import. Rescans to detect past
        events will be supported later on.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ImportPublicKey(self, request, context):
        """
        ImportPublicKey imports a public key as watch-only into the wallet.

        NOTE: Events (deposits/spends) for a key will only be detected by lnd if
        they happen after the import. Rescans to detect past events will be
        supported later on.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PublishTransaction(self, request, context):
        """
        PublishTransaction attempts to publish the passed transaction to the
        network. Once this returns without an error, the wallet will continually
        attempt to re-broadcast the transaction on start up, until it enters the
        chain.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SendOutputs(self, request, context):
        """
        SendOutputs is similar to the existing sendmany call in Bitcoind, and
        allows the caller to create a transaction that sends to several outputs at
        once. This is ideal when wanting to batch create a set of transactions.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def EstimateFee(self, request, context):
        """
        EstimateFee attempts to query the internal fee estimator of the wallet to
        determine the fee (in sat/kw) to attach to a transaction in order to
        achieve the confirmation target.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PendingSweeps(self, request, context):
        """
        PendingSweeps returns lists of on-chain outputs that lnd is currently
        attempting to sweep within its central batching engine. Outputs with similar
        fee rates are batched together in order to sweep them within a single
        transaction.

        NOTE: Some of the fields within PendingSweepsRequest are not guaranteed to
        remain supported. This is an advanced API that depends on the internals of
        the UtxoSweeper, so things may change.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def BumpFee(self, request, context):
        """
        BumpFee bumps the fee of an arbitrary input within a transaction. This RPC
        takes a different approach than bitcoind's bumpfee command. lnd has a
        central batching engine in which inputs with similar fee rates are batched
        together to save on transaction fees. Due to this, we cannot rely on
        bumping the fee on a specific transaction, since transactions can change at
        any point with the addition of new inputs. The list of inputs that
        currently exist within lnd's central batching engine can be retrieved
        through the PendingSweeps RPC.

        When bumping the fee of an input that currently exists within lnd's central
        batching engine, a higher fee transaction will be created that replaces the
        lower fee transaction through the Replace-By-Fee (RBF) policy. If it

        This RPC also serves useful when wanting to perform a Child-Pays-For-Parent
        (CPFP), where the child transaction pays for its parent's fee. This can be
        done by specifying an outpoint within the low fee transaction that is under
        the control of the wallet.

        The fee preference can be expressed either as a specific fee rate or a delta
        of blocks in which the output should be swept on-chain within. If a fee
        preference is not explicitly specified, then an error is returned.

        Note that this RPC currently doesn't perform any validation checks on the
        fee preference being provided. For now, the responsibility of ensuring that
        the new fee preference is sufficient is delegated to the user.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListSweeps(self, request, context):
        """
        ListSweeps returns a list of the sweep transactions our node has produced.
        Note that these sweeps may not be confirmed yet, as we record sweeps on
        broadcast, not confirmation.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def LabelTransaction(self, request, context):
        """
        LabelTransaction adds a label to a transaction. If the transaction already
        has a label the call will fail unless the overwrite bool is set. This will
        overwrite the exiting transaction label. Labels must not be empty, and
        cannot exceed 500 characters.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FundPsbt(self, request, context):
        """
        FundPsbt creates a fully populated PSBT that contains enough inputs to fund
        the outputs specified in the template. There are two ways of specifying a
        template: Either by passing in a PSBT with at least one output declared or
        by passing in a raw TxTemplate message.

        If there are no inputs specified in the template, coin selection is
        performed automatically. If the template does contain any inputs, it is
        assumed that full coin selection happened externally and no additional
        inputs are added. If the specified inputs aren't enough to fund the outputs
        with the given fee rate, an error is returned.

        After either selecting or verifying the inputs, all input UTXOs are locked
        with an internal app ID.

        NOTE: If this method returns without an error, it is the caller's
        responsibility to either spend the locked UTXOs (by finalizing and then
        publishing the transaction) or to unlock/release the locked UTXOs in case of
        an error on the caller's side.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def FinalizePsbt(self, request, context):
        """
        FinalizePsbt expects a partial transaction with all inputs and outputs fully
        declared and tries to sign all inputs that belong to the wallet. Lnd must be
        the last signer of the transaction. That means, if there are any unsigned
        non-witness inputs or inputs without UTXO information attached or inputs
        without witness data that do not belong to lnd's wallet, this method will
        fail. If no error is returned, the PSBT is ready to be extracted and the
        final TX within to be broadcast.

        NOTE: This method does NOT publish the transaction once finalized. It is the
        caller's responsibility to either publish the transaction on success or
        unlock/release any locked UTXOs in case of an error in this method.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_WalletKitServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'ListUnspent': grpc.unary_unary_rpc_method_handler(
                    servicer.ListUnspent,
                    request_deserializer=walletrpc_dot_walletkit__pb2.ListUnspentRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.ListUnspentResponse.SerializeToString,
            ),
            'LeaseOutput': grpc.unary_unary_rpc_method_handler(
                    servicer.LeaseOutput,
                    request_deserializer=walletrpc_dot_walletkit__pb2.LeaseOutputRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.LeaseOutputResponse.SerializeToString,
            ),
            'ReleaseOutput': grpc.unary_unary_rpc_method_handler(
                    servicer.ReleaseOutput,
                    request_deserializer=walletrpc_dot_walletkit__pb2.ReleaseOutputRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.ReleaseOutputResponse.SerializeToString,
            ),
            'ListLeases': grpc.unary_unary_rpc_method_handler(
                    servicer.ListLeases,
                    request_deserializer=walletrpc_dot_walletkit__pb2.ListLeasesRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.ListLeasesResponse.SerializeToString,
            ),
            'DeriveNextKey': grpc.unary_unary_rpc_method_handler(
                    servicer.DeriveNextKey,
                    request_deserializer=walletrpc_dot_walletkit__pb2.KeyReq.FromString,
                    response_serializer=signrpc_dot_signer__pb2.KeyDescriptor.SerializeToString,
            ),
            'DeriveKey': grpc.unary_unary_rpc_method_handler(
                    servicer.DeriveKey,
                    request_deserializer=signrpc_dot_signer__pb2.KeyLocator.FromString,
                    response_serializer=signrpc_dot_signer__pb2.KeyDescriptor.SerializeToString,
            ),
            'NextAddr': grpc.unary_unary_rpc_method_handler(
                    servicer.NextAddr,
                    request_deserializer=walletrpc_dot_walletkit__pb2.AddrRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.AddrResponse.SerializeToString,
            ),
            'ListAccounts': grpc.unary_unary_rpc_method_handler(
                    servicer.ListAccounts,
                    request_deserializer=walletrpc_dot_walletkit__pb2.ListAccountsRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.ListAccountsResponse.SerializeToString,
            ),
            'ImportAccount': grpc.unary_unary_rpc_method_handler(
                    servicer.ImportAccount,
                    request_deserializer=walletrpc_dot_walletkit__pb2.ImportAccountRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.ImportAccountResponse.SerializeToString,
            ),
            'ImportPublicKey': grpc.unary_unary_rpc_method_handler(
                    servicer.ImportPublicKey,
                    request_deserializer=walletrpc_dot_walletkit__pb2.ImportPublicKeyRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.ImportPublicKeyResponse.SerializeToString,
            ),
            'PublishTransaction': grpc.unary_unary_rpc_method_handler(
                    servicer.PublishTransaction,
                    request_deserializer=walletrpc_dot_walletkit__pb2.Transaction.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.PublishResponse.SerializeToString,
            ),
            'SendOutputs': grpc.unary_unary_rpc_method_handler(
                    servicer.SendOutputs,
                    request_deserializer=walletrpc_dot_walletkit__pb2.SendOutputsRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.SendOutputsResponse.SerializeToString,
            ),
            'EstimateFee': grpc.unary_unary_rpc_method_handler(
                    servicer.EstimateFee,
                    request_deserializer=walletrpc_dot_walletkit__pb2.EstimateFeeRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.EstimateFeeResponse.SerializeToString,
            ),
            'PendingSweeps': grpc.unary_unary_rpc_method_handler(
                    servicer.PendingSweeps,
                    request_deserializer=walletrpc_dot_walletkit__pb2.PendingSweepsRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.PendingSweepsResponse.SerializeToString,
            ),
            'BumpFee': grpc.unary_unary_rpc_method_handler(
                    servicer.BumpFee,
                    request_deserializer=walletrpc_dot_walletkit__pb2.BumpFeeRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.BumpFeeResponse.SerializeToString,
            ),
            'ListSweeps': grpc.unary_unary_rpc_method_handler(
                    servicer.ListSweeps,
                    request_deserializer=walletrpc_dot_walletkit__pb2.ListSweepsRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.ListSweepsResponse.SerializeToString,
            ),
            'LabelTransaction': grpc.unary_unary_rpc_method_handler(
                    servicer.LabelTransaction,
                    request_deserializer=walletrpc_dot_walletkit__pb2.LabelTransactionRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.LabelTransactionResponse.SerializeToString,
            ),
            'FundPsbt': grpc.unary_unary_rpc_method_handler(
                    servicer.FundPsbt,
                    request_deserializer=walletrpc_dot_walletkit__pb2.FundPsbtRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.FundPsbtResponse.SerializeToString,
            ),
            'FinalizePsbt': grpc.unary_unary_rpc_method_handler(
                    servicer.FinalizePsbt,
                    request_deserializer=walletrpc_dot_walletkit__pb2.FinalizePsbtRequest.FromString,
                    response_serializer=walletrpc_dot_walletkit__pb2.FinalizePsbtResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'walletrpc.WalletKit', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class WalletKit(object):
    """WalletKit is a service that gives access to the core functionalities of the
    daemon's wallet.
    """

    @staticmethod
    def ListUnspent(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ListUnspent',
            walletrpc_dot_walletkit__pb2.ListUnspentRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.ListUnspentResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def LeaseOutput(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/LeaseOutput',
            walletrpc_dot_walletkit__pb2.LeaseOutputRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.LeaseOutputResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ReleaseOutput(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ReleaseOutput',
            walletrpc_dot_walletkit__pb2.ReleaseOutputRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.ReleaseOutputResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListLeases(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ListLeases',
            walletrpc_dot_walletkit__pb2.ListLeasesRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.ListLeasesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeriveNextKey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/DeriveNextKey',
            walletrpc_dot_walletkit__pb2.KeyReq.SerializeToString,
            signrpc_dot_signer__pb2.KeyDescriptor.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeriveKey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/DeriveKey',
            signrpc_dot_signer__pb2.KeyLocator.SerializeToString,
            signrpc_dot_signer__pb2.KeyDescriptor.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def NextAddr(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/NextAddr',
            walletrpc_dot_walletkit__pb2.AddrRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.AddrResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListAccounts(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ListAccounts',
            walletrpc_dot_walletkit__pb2.ListAccountsRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.ListAccountsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ImportAccount(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ImportAccount',
            walletrpc_dot_walletkit__pb2.ImportAccountRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.ImportAccountResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ImportPublicKey(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ImportPublicKey',
            walletrpc_dot_walletkit__pb2.ImportPublicKeyRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.ImportPublicKeyResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def PublishTransaction(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/PublishTransaction',
            walletrpc_dot_walletkit__pb2.Transaction.SerializeToString,
            walletrpc_dot_walletkit__pb2.PublishResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def SendOutputs(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/SendOutputs',
            walletrpc_dot_walletkit__pb2.SendOutputsRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.SendOutputsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def EstimateFee(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/EstimateFee',
            walletrpc_dot_walletkit__pb2.EstimateFeeRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.EstimateFeeResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def PendingSweeps(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/PendingSweeps',
            walletrpc_dot_walletkit__pb2.PendingSweepsRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.PendingSweepsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def BumpFee(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/BumpFee',
            walletrpc_dot_walletkit__pb2.BumpFeeRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.BumpFeeResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListSweeps(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/ListSweeps',
            walletrpc_dot_walletkit__pb2.ListSweepsRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.ListSweepsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def LabelTransaction(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/LabelTransaction',
            walletrpc_dot_walletkit__pb2.LabelTransactionRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.LabelTransactionResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def FundPsbt(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/FundPsbt',
            walletrpc_dot_walletkit__pb2.FundPsbtRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.FundPsbtResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def FinalizePsbt(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/walletrpc.WalletKit/FinalizePsbt',
            walletrpc_dot_walletkit__pb2.FinalizePsbtRequest.SerializeToString,
            walletrpc_dot_walletkit__pb2.FinalizePsbtResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
