from __future__ import absolute_import, division, print_function, unicode_literals

# don't do `from builtins import str`
from setuptools import setup
from io import open
from itertools import chain

# nltk.download("punkt")

with open("README.md", "r", encoding="utf-8") as fr:
	long_description = fr.read()

extras_require = {
	"args": [],
	"algorithms": [],
	"atomic": [],
	"binary": [],
	"concurrency": [],
	"constants_physics": [],
	"constants_video": [],
	"csv": [],
	"datetime": [],
	"debug": [],
	"dict": [],
	"datastructures": [],
	"error": [],
	"exceptions": [],
	"factorial": [],
	"func": [],
	"file": [],
	"filesystem": [],
	"geometry": [],
	"hash": [],
	"iter": [],
	"imdb": [],
	"indexing": [],
	"latex": [],
	"math": [],
	"mongo": [],
	"object": [],
	"ops": [],
	"os": ["ctypes-windows-sdk>=0.0.7; sys_platform == 'win32'"],
	"pickle": [],
	"profile": [],
	"rand": [],
	"ringlist": [],
	"search": [],
	"sequence": [],
	"set": [],
	"signal": [],
	"sort": [],
	"sql": [],
	"sqlite": [],
	"statistics": [],
	"stdio": [],
	"string": [],
	"test": [],
	"time": [],
	"typing": [],
	"text": [],
	"twitch": [],
	"url": [],

	# "browscap": ["re2"], # unfinished
	"cholesky": ["numpy", "numba"],
	"config": ["jsonschema", "sortedcontainers"],
	"downloadmanager": ["aiohttp>=0.16.3", "orderedset"],
	"encoder": ["numpy", "nltk; python_version>='3'", "nltk<3.5; python_version<'3'"],
	"filesdb": ["tls-property"],
	"fingerprinting": ["numpy", "numba", "pillow"],
	"fuzzy": ["polyleven; python_version>='3'", "python-Levenshtein; python_version<'3'"],
	"html": ["beautifulsoup4"],
	"http": ["requests"],
	"http2": ["hyper"],
	"image": ["numpy"],
	"json": ["jsonschema"],
	"lda": ["numpy", "nltk; python_version>='3'", "nltk<3.5; python_version<'3'"],
	"metrics": ["numpy"],
	"mp4": ["setuptools"],
	"multihash": ["rhash"],
	"net": ["netifaces"],
	"nlp": ["nltk; python_version>='3'", "nltk<3.5; python_version<'3'"],
	"regression": ["numpy"],
	"resizing": ["numpy", "opencv-python", "scikit-learn"],
	"scene_change_detection": ["numpy"],
	"sudoku": ["setuptools"],
	"tls": ["cryptography", "pyOpenSSL>=17.5.0"],
	"torrent": ["bencode.py>=2.0.0"],  # bencoding ?
	"videofile": ["opencv-python", "av"],
	"win32": ["wmi", "pypiwin32"],
	"widgets": ["wxPython"],
	"xsl": ["lxml"],

	# helpers for specific packages
	"aria": ["aria2p", "requests"],
	"av": ["av"],
	"cv": ["opencv-python", "numpy"],
	"flask": ["flask", "werkzeug>=0.11.11"],
	"gensim": ["gensim>=3.3.0", "numpy"],
	"msgpack": ["msgpack>=0.6.0"],
	"mediainfo": ["pymediainfo"],
	"numpy": ["numpy"],
	"numba": ["numba"],
	"nltk": ["nltk; python_version>='3'", "nltk<3.5; python_version<'3'"],
	"networkx": ["networkx"],
	"pandas": ["pandas"],
	"pdf": ["PyPDF2"],
	"pillow": ["pillow", "piexif"],
	"powerpoint": ["python-pptx"],
	"rasa": ["requests"],
	"salesforce": ["simple_salesforce>=1.1.0", "simplejson"],
	"scipy": ["numpy", "scipy"],
	"toml": ["toml"],
	"torch": ["torch"],
	"twisted": ["twisted"],
	"tensorflow": ["tensorflow"],
	"yaml": ["ruamel.yaml"],
}

extras_require["all"] = sorted(set(chain.from_iterable(extras_require.values())))

setup(
	author="Dobatymo",
	name="genutility",
	version="0.0.49",
	url="https://github.com/Dobatymo/genutility",
	description="A collection of various Python utilities",
	long_description=long_description,
	long_description_content_type="text/markdown",
	classifiers=[
		"Programming Language :: Python :: 2",
		"Programming Language :: Python :: 3",
		"License :: OSI Approved :: ISC License (ISCL)",
		"Operating System :: OS Independent",
		"Topic :: Utilities",
	],
	packages=["genutility", "genutility/compat", "genutility/fileformats", "genutility/hardware", "genutility/twothree"],
	package_data={str("genutility"): ["data/*.tsv"]},
	python_requires=">=2.7",
	install_requires=[
		"future",
		"ctypes-windows-sdk>=0.0.7; sys_platform=='win32'",
		"typing; python_version<'3.5'",
		"scandir; python_version<'3.5'",
		"pathlib2; python_version<'3.4'",
		"mock; python_version<'3.3'",
		"contextlib2; python_version<'3.3'",
	],
	extras_require=extras_require,
	use_2to3=False
)
