/**
 * File: sample_env.sv
 * Brief: Sample UVM environment for documentation testing
 * 
 * Class: sample_env
 * 
 * Brief: Top-level verification environment
 * 
 * Module       : sample_design
 * Design File  : sample_design.v
 * Project      : test_project
 * 
 * This environment integrates agents, scoreboard, and coverage collectors
 * to create a complete verification environment.
 */

`ifndef SAMPLE_ENV_DEF
`define SAMPLE_ENV_DEF

class sample_env extends uvm_env;
  
  `uvm_component_utils(sample_env)
  
  // Environment components
  sample_agent      input_agent;
  sample_agent      output_agent;
  sample_scoreboard scoreboard;
  sample_coverage   coverage;
  
  // Configuration
  sample_env_cfg cfg;
  
  /**
   * Constructor: new
   * Creates a new environment instance
   */
  function new(string name = "sample_env", uvm_component parent = null);
    super.new(name, parent);
  endfunction
  
  /**
   * Function: build_phase
   * Builds all environment components
   */
  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);
    
    input_agent = sample_agent::type_id::create("input_agent", this);
    output_agent = sample_agent::type_id::create("output_agent", this);
    scoreboard = sample_scoreboard::type_id::create("scoreboard", this);
    coverage = sample_coverage::type_id::create("coverage", this);
  endfunction
  
  /**
   * Function: connect_phase
   * Connects monitors to scoreboard and coverage
   */
  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
    
    input_agent.monitor.ap.connect(scoreboard.input_fifo.analysis_export);
    output_agent.monitor.ap.connect(scoreboard.output_fifo.analysis_export);
    input_agent.monitor.ap.connect(coverage.analysis_export);
  endfunction
  
endclass

`endif // SAMPLE_ENV_DEF
