/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import no.priv.garshol.duke.utils.CSVReaderTest;
import no.priv.garshol.duke.utils.StringUtils;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void testEmptyReplace() {
        Assert.assertEquals((String)"", (String)StringUtils.replaceAnyOf((String)"", (String)"abc", (char)' '));
    }

    @Test
    public void testNoReplacements() {
        Assert.assertEquals((String)"123", (String)StringUtils.replaceAnyOf((String)"123", (String)"abc", (char)' '));
    }

    @Test
    public void testAllReplacements() {
        Assert.assertEquals((String)"   ", (String)StringUtils.replaceAnyOf((String)"abc", (String)"abc", (char)' '));
    }

    @Test
    public void testEmptyWS() {
        Assert.assertEquals((String)"", (String)StringUtils.normalizeWS((String)""));
    }

    @Test
    public void testNoWS() {
        Assert.assertEquals((String)"abc", (String)StringUtils.normalizeWS((String)"abc"));
    }

    @Test
    public void testLeadingWS() {
        Assert.assertEquals((String)"abc", (String)StringUtils.normalizeWS((String)"  abc"));
    }

    @Test
    public void testTrailingWS1() {
        Assert.assertEquals((String)"abc", (String)StringUtils.normalizeWS((String)"abc "));
    }

    @Test
    public void testTrailingWS2() {
        Assert.assertEquals((String)"abc", (String)StringUtils.normalizeWS((String)"abc  "));
    }

    @Test
    public void testTrailingWS3() {
        Assert.assertEquals((String)"abc def", (String)StringUtils.normalizeWS((String)"abc def "));
    }

    @Test
    public void testEmpty() {
        StringUtilsTest.assertEqual(new String[0], StringUtils.split((String)""));
    }

    @Test
    public void testOneToken() {
        StringUtilsTest.assertEqual(new String[]{"ab"}, StringUtils.split((String)"ab"));
    }

    @Test
    public void testTwoTokens() {
        StringUtilsTest.assertEqual(new String[]{"a", "b"}, StringUtils.split((String)"a b"));
    }

    @Test
    public void testTwoTokensLeadingTrailing() {
        StringUtilsTest.assertEqual(new String[]{"a", "b"}, StringUtils.split((String)"  a b  "));
    }

    @Test
    public void testManySpaces() {
        StringUtilsTest.assertEqual(new String[]{"aaa", "bbb"}, StringUtils.split((String)"aaa   bbb"));
    }

    @Test
    public void testThreeTokens() {
        StringUtilsTest.assertEqual(new String[]{"aaa", "bbb", "ccc"}, StringUtils.split((String)"aaa bbb ccc"));
    }

    public static void assertEqual(String[] s1, String[] s2) {
        boolean equal = s1.length == s2.length;
        for (int ix = 0; ix < s1.length && equal; ++ix) {
            equal = s1[ix].equals(s2[ix]);
        }
        if (!equal) {
            throw new AssertionFailedError("Array " + CSVReaderTest.toString(s1) + " != " + CSVReaderTest.toString(s2));
        }
    }
}

