/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import junit.framework.Assert;
import no.priv.garshol.duke.comparators.QGramComparator;
import org.junit.Before;
import org.junit.Test;

public class QGramComparatorTest {
    private QGramComparator comp;

    @Before
    public void setup() {
        this.comp = new QGramComparator();
    }

    @Test
    public void testEmpty() {
        Assert.assertEquals((Object)1.0, (Object)this.comp.compare("", ""));
    }

    @Test
    public void testOneIsEmpty() {
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("", "abc"));
    }

    @Test
    public void testOneIsDifferent() {
        Assert.assertEquals((Object)0.6666666666666666, (Object)this.comp.compare("abc def", "cab def"));
    }

    @Test
    public void testGail() {
        Assert.assertEquals((Object)0.3333333333333333, (Object)this.comp.compare("gail", "gayle"));
    }

    @Test
    public void testGailJaccard() {
        this.comp.setFormula(QGramComparator.Formula.JACCARD);
        Assert.assertEquals((Object)0.16666666666666666, (Object)this.comp.compare("gail", "gayle"));
    }

    @Test
    public void testGailDice() {
        this.comp.setFormula(QGramComparator.Formula.DICE);
        Assert.assertEquals((Object)0.2857142857142857, (Object)this.comp.compare("gail", "gayle"));
    }

    @Test
    public void testGail3() {
        this.comp.setQ(3);
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("gail", "gayle"));
    }

    @Test
    public void testGarshol3() {
        this.comp.setQ(3);
        Assert.assertEquals((Object)0.8, (Object)this.comp.compare("garshol", "garshoel"));
    }

    @Test
    public void testGailPositional() {
        this.comp.setTokenizer(QGramComparator.Tokenizer.POSITIONAL);
        Assert.assertEquals((Object)0.3333333333333333, (Object)this.comp.compare("gail", "gayle"));
    }

    @Test
    public void testKakadu() {
        Assert.assertEquals((Object)0.5, (Object)this.comp.compare("kakadu", "cacadu"));
    }

    @Test
    public void testKakaduPositional() {
        this.comp.setTokenizer(QGramComparator.Tokenizer.POSITIONAL);
        Assert.assertEquals((Object)0.4, (Object)this.comp.compare("kakadu", "cacadu"));
    }

    @Test
    public void testGailEnds() {
        this.comp.setTokenizer(QGramComparator.Tokenizer.ENDS);
        Assert.assertEquals((Object)0.4, (Object)this.comp.compare("gail", "gayle"));
    }
}

