/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import junit.framework.Assert;
import no.priv.garshol.duke.comparators.LongestCommonSubstring;
import org.junit.Before;
import org.junit.Test;

public class LongestCommonSubstringTest {
    private LongestCommonSubstring comp;

    @Before
    public void setup() {
        this.comp = new LongestCommonSubstring();
    }

    @Test
    public void testEmpty() {
        Assert.assertEquals((Object)1.0, (Object)this.comp.compare("", ""));
    }

    @Test
    public void testEmpty2() {
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("", "foo"));
    }

    @Test
    public void testComparatorEqual() {
        Assert.assertEquals((Object)1.0, (Object)this.comp.compare("foo", "foo"));
    }

    @Test
    public void testComparatorTotallyDifferent() {
        Assert.assertEquals((Object)0.0, (Object)this.comp.compare("foo", "bar"));
    }

    @Test
    public void testChristen5_21() {
        Assert.assertEquals((Object)0.5714285714285714, (Object)this.comp.compare("peter christen", "christian pedro"));
    }

    @Test
    public void testChristen5_21b() {
        this.comp.setMinimumLength(4);
        Assert.assertEquals((Object)0.42857142857142855, (Object)this.comp.compare("peter christen", "christian pedro"));
    }

    @Test
    public void testChristen5_21c() {
        this.comp.setMinimumLength(4);
        Assert.assertEquals((Object)0.9285714285714286, (Object)this.comp.compare("peter christen", "christen peter"));
    }

    @Test
    public void testSelf() {
        Assert.assertEquals((Object)1.0, (Object)this.comp.compare("lars marius garshol", "lars garshol"));
    }

    @Test
    public void testSymmetric() {
        Assert.assertEquals((Object)this.comp.compare("papr", "prap"), (Object)this.comp.compare("prap", "papr"));
    }

    @Test
    public void testHotels() {
        Assert.assertEquals((Object)0.7272727272727273, (Object)this.comp.compare("the waldorf hilton", "one aldwych"));
    }

    @Test
    public void testHotels2() {
        this.comp.setMinimumLength(3);
        Assert.assertEquals((Object)0.5454545454545454, (Object)this.comp.compare("the waldorf hilton", "one aldwych"));
    }

    @Test
    public void testJaccard1() {
        this.comp.setFormula(LongestCommonSubstring.Formula.JACCARD);
        Assert.assertEquals((Object)0.38095238095238093, (Object)this.comp.compare("peter christen", "christian pedro"));
    }

    @Test
    public void testJaccard2() {
        this.comp.setFormula(LongestCommonSubstring.Formula.JACCARD);
        Assert.assertEquals((Object)0.8666666666666667, (Object)this.comp.compare("peter christen", "christen peter"));
    }

    @Test
    public void testDice1() {
        this.comp.setFormula(LongestCommonSubstring.Formula.DICE);
        Assert.assertEquals((Object)0.5517241379310345, (Object)this.comp.compare("peter christen", "christian pedro"));
    }

    @Test
    public void testDice2() {
        this.comp.setFormula(LongestCommonSubstring.Formula.DICE);
        Assert.assertEquals((Object)0.9285714285714286, (Object)this.comp.compare("peter christen", "christen peter"));
    }
}

