/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import junit.framework.Assert;
import no.priv.garshol.duke.cleaners.LowerCaseNormalizeCleanerTest;
import no.priv.garshol.duke.cleaners.RegexpCleaner;
import org.junit.Test;

public class RegexpCleanerTest
extends LowerCaseNormalizeCleanerTest {
    @Test
    public void testNoMatch() {
        this.test("^(\\d\\d\\d\\d)-", "gurble", null);
    }

    @Test
    public void testStartYear() {
        this.test("^(\\d\\d\\d\\d)-", "1850-1888", "1850");
    }

    @Test
    public void testEndYear() {
        this.test("-(\\d\\d\\d\\d)$", "1850-1888", "1888");
    }

    @Test
    public void discardSecondGroup() {
        RegexpCleaner cl = new RegexpCleaner();
        cl.setDiscardGroup(true);
        cl.setGroup(2);
        cl.setRegexp("([a-zA-Z])(\\d+)");
        Assert.assertEquals((String)"IDontLikeDigitsBut53inTheEndIsOk", (String)cl.clean("ID42ontLikeDigitsBut53inTheEndIsOk"));
    }

    @Test
    public void discardAll() {
        RegexpCleaner cl = new RegexpCleaner();
        cl.setDiscardGroup(false);
        cl.setDiscardAllGroup(true);
        cl.setRegexp("(\\d+)");
        Assert.assertEquals((String)"IDontLikeDigits  $", (String)cl.clean("I123Dont454Like450Di3gits 4234 0234$"));
    }

    @Test
    public void discardAllSecondGroup() {
        RegexpCleaner cl = new RegexpCleaner();
        cl.setDiscardAllGroup(true);
        cl.setGroup(2);
        cl.setRegexp("([A-Z])(\\d+\\s?)");
        Assert.assertEquals((String)"This is DUKE", (String)cl.clean("This is D1 U312 K1231 E4332"));
    }

    private void test(String regexp, String value, String result) {
        RegexpCleaner cl = new RegexpCleaner();
        cl.setRegexp(regexp);
        Assert.assertEquals((String)result, (String)cl.clean(value));
    }
}

