/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import junit.framework.Assert;
import no.priv.garshol.duke.cleaners.NorwegianCompanyNameCleaner;
import org.junit.Before;
import org.junit.Test;

public class NorwegianCompanyNameCleanerTest {
    private NorwegianCompanyNameCleaner cleaner;

    @Before
    public void setup() {
        this.cleaner = new NorwegianCompanyNameCleaner();
    }

    @Test
    public void testEmpty() {
        this.test("", "");
    }

    @Test
    public void testAslashsAs() {
        this.test("sundby maskin as", "sundby maskin a/s");
    }

    @Test
    public void testAbackslashAs() {
        this.test("sundby maskin as", "sundby maskin a\\s");
    }

    @Test
    public void testAslashL() {
        this.test("al follestadgata sameie", "a/l follestadgata sameie");
    }

    @Test
    public void testMoveALToEnd() {
        this.test("a/l follestadgata sameie", "follestadgata sameie al");
    }

    @Test
    public void testMoveASToEnd() {
        this.test("a/s sundby maskin", "sundby maskin as");
    }

    private void test(String s1, String s2) {
        Assert.assertEquals((String)this.cleaner.clean(s1), (String)this.cleaner.clean(s2));
    }
}

