/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import junit.framework.Assert;
import no.priv.garshol.duke.Cleaner;
import no.priv.garshol.duke.cleaners.LowerCaseNormalizeCleaner;
import org.junit.Before;
import org.junit.Test;

public class LowerCaseNormalizeCleanerTest {
    protected Cleaner cleaner;

    @Before
    public void setUp() {
        this.cleaner = new LowerCaseNormalizeCleaner();
    }

    @Test
    public void testEmpty() {
        Assert.assertEquals((String)"", (String)this.cleaner.clean(""));
    }

    @Test
    public void testSingleChar() {
        Assert.assertEquals((String)"a", (String)this.cleaner.clean("A"));
    }

    @Test
    public void testSingleChar2() {
        Assert.assertEquals((String)"a", (String)this.cleaner.clean("a"));
    }

    @Test
    public void testSingleSpace() {
        Assert.assertEquals((String)"", (String)this.cleaner.clean(" "));
    }

    @Test
    public void testManySpaces() {
        Assert.assertEquals((String)"", (String)this.cleaner.clean("    "));
    }

    @Test
    public void testManyLeadingSpaces() {
        Assert.assertEquals((String)"a", (String)this.cleaner.clean("    a"));
    }

    @Test
    public void testManyTrailingSpaces() {
        Assert.assertEquals((String)"a", (String)this.cleaner.clean("a    "));
    }

    @Test
    public void testLarsMarius() {
        Assert.assertEquals((String)"lars marius", (String)this.cleaner.clean("Lars Marius"));
    }

    @Test
    public void testLarsMarius3Spaces() {
        Assert.assertEquals((String)"lars marius", (String)this.cleaner.clean("Lars   Marius"));
    }

    @Test
    public void testLarsMariusPadded() {
        Assert.assertEquals((String)"lars marius", (String)this.cleaner.clean("   Lars   Marius   "));
    }

    @Test
    public void testRealData() {
        Assert.assertEquals((String)"inger elisabeth foyn havre", (String)this.cleaner.clean("Inger Elisabeth Foyn Havre"));
    }

    @Test
    public void testAccentStripping() {
        Assert.assertEquals((String)"male", (String)this.cleaner.clean("Mal\u00e9"));
    }

    @Test
    public void testAccentStripping2() {
        Assert.assertEquals((String)"h\u00f8ybr\u00e5ten", (String)this.cleaner.clean("H\u00f8ybr\u00e5ten"));
    }
}

