/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.io.File;
import java.io.IOException;
import no.priv.garshol.duke.DukeException;

public class Utils {
    public static double computeBayes(double prob1, double prob2) {
        return prob1 * prob2 / (prob1 * prob2 + (1.0 - prob1) * (1.0 - prob2));
    }

    public static boolean isWindowsOS() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static File createTempDirectory(String prefix) {
        File temp = null;
        try {
            temp = File.createTempFile(prefix != null ? prefix : "temp", Long.toString(System.nanoTime()));
            if (!temp.delete()) {
                throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
            }
            if (!temp.mkdir()) {
                throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new DukeException("Unable to create temporary directory with prefix " + prefix, e);
        }
        return temp;
    }
}

