/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.matchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.matchers.AbstractMatchListener;
import no.priv.garshol.duke.matchers.PrintMatchListener;

public class LinkDatabaseMatchListener
extends AbstractMatchListener {
    private Configuration config;
    private LinkDatabase linkdb;
    private Record current;
    private Collection<Link> curlinks;

    public LinkDatabaseMatchListener(Configuration config, LinkDatabase linkdb) {
        this.config = config;
        this.linkdb = linkdb;
    }

    @Override
    public void matches(Record r1, Record r2, double confidence) {
        if (r1 != this.current) {
            if (this.current != null) {
                this.endRecord_();
            }
            this.startRecord_(r1);
        }
        String id1 = this.getIdentity(r1);
        String id2 = this.getIdentity(r2);
        this.curlinks.add(new Link(id1, id2, LinkStatus.INFERRED, LinkKind.SAME, confidence));
    }

    @Override
    public void matchesPerhaps(Record r1, Record r2, double confidence) {
        if (r1 != this.current) {
            if (this.current != null) {
                this.endRecord_();
            }
            this.startRecord_(r1);
        }
        String id1 = this.getIdentity(r1);
        String id2 = this.getIdentity(r2);
        this.curlinks.add(new Link(id1, id2, LinkStatus.INFERRED, LinkKind.MAYBESAME, confidence));
    }

    @Override
    public void noMatchFor(Record record) {
        if (this.current != null) {
            this.endRecord_();
        }
        this.startRecord_(record);
    }

    public void startRecord_(Record r) {
        this.current = r;
        this.curlinks = new ArrayList<Link>();
    }

    public void endRecord_() {
        Collection<Link> oldlinks = this.linkdb.getAllLinksFor(this.getIdentity(this.current));
        if (oldlinks != null) {
            HashMap<String, Link> oldmap = new HashMap<String, Link>(oldlinks.size());
            for (Link l : oldlinks) {
                oldmap.put(this.makeKey(l), l);
            }
            for (Link newl : new ArrayList<Link>(this.curlinks)) {
                String key = this.makeKey(newl);
                Link oldl = (Link)oldmap.get(key);
                if (oldl == null) continue;
                if (oldl.overrides(newl)) {
                    this.curlinks.remove(newl);
                    continue;
                }
                if (this.sameAs(oldl, newl)) {
                    this.curlinks.remove(newl);
                    oldmap.remove(key);
                    continue;
                }
                oldmap.remove(key);
            }
            for (Link oldl : oldmap.values()) {
                if (oldl.getStatus() != LinkStatus.INFERRED) continue;
                oldl.retract();
                this.curlinks.add(oldl);
            }
        }
        for (Link l : this.curlinks) {
            this.linkdb.assertLink(l);
        }
    }

    @Override
    public void batchReady(int size) {
        this.linkdb.validateConnection();
    }

    @Override
    public void batchDone() {
        this.endRecord_();
        this.current = null;
        this.linkdb.commit();
    }

    private String getIdentity(Record r) {
        for (Property p : this.config.getIdentityProperties()) {
            Iterator<String> iterator;
            Collection<String> vs = r.getValues(p.getName());
            if (vs == null || !(iterator = vs.iterator()).hasNext()) continue;
            String v = iterator.next();
            return v;
        }
        throw new DukeException("No identity found in record [" + PrintMatchListener.toString(r) + "]");
    }

    private String makeKey(Link l) {
        return l.getID1() + "\t" + l.getID2();
    }

    private boolean sameAs(Link l1, Link l2) {
        return l1.getStatus() == l2.getStatus() && l1.getKind() == l2.getKind();
    }
}

