/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import no.priv.garshol.duke.Cleaner;

public class Column {
    private String name;
    private String property;
    private String prefix;
    private Cleaner cleaner;
    private Pattern splitter;

    public Column(String name, String property, String prefix, Cleaner cleaner) {
        this.name = name;
        this.property = property;
        this.prefix = prefix;
        this.cleaner = cleaner;
    }

    public String getName() {
        return this.name;
    }

    public String getProperty() {
        if (this.property == null) {
            return this.name;
        }
        return this.property;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Cleaner getCleaner() {
        return this.cleaner;
    }

    public void setSplitOn(String spliton) {
        this.splitter = Pattern.compile(spliton);
    }

    public boolean isSplit() {
        return this.splitter != null;
    }

    public Collection<String> split(String value) {
        String[] parts = this.splitter.split(value);
        ArrayList<String> values = new ArrayList<String>(parts.length);
        for (int ix = 0; ix < parts.length; ++ix) {
            values.add(parts[ix]);
        }
        return values;
    }

    public String getSplitOn() {
        return this.splitter.toString();
    }
}

