/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.DukeException;

public class GeopositionComparator
implements Comparator {
    private static final double R = 6371000.0;
    private double maxdist = 100.0;
    private boolean strict;

    @Override
    public boolean isTokenized() {
        return false;
    }

    @Override
    public double compare(String v1, String v2) {
        try {
            double lat1 = GeopositionComparator.getLatitude(v1);
            double lon1 = GeopositionComparator.getLongitude(v1);
            double lat2 = GeopositionComparator.getLatitude(v2);
            double lon2 = GeopositionComparator.getLongitude(v2);
            if (!this.valid(lat1, lon1) || !this.valid(lat2, lon2)) {
                return 0.5;
            }
            double dist = GeopositionComparator.distance(lat1, lon1, lat2, lon2);
            if (dist > this.maxdist) {
                return 0.0;
            }
            return (1.0 - dist / this.maxdist) * 0.5 + 0.5;
        }
        catch (NumberFormatException e) {
            if (this.strict) {
                throw new DukeException("Invalid number: " + e, e);
            }
            return 0.5;
        }
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setMaxDistance(double maxdist) {
        this.maxdist = maxdist;
    }

    public double getMaxDistance() {
        return this.maxdist;
    }

    public static double distance(double lat1, double lon1, double lat2, double lon2) {
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1);
        lat1 = Math.toRadians(lat1);
        lat2 = Math.toRadians(lat2);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0) * Math.cos(lat1) * Math.cos(lat2);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6371000.0 * c;
    }

    private static double getLongitude(String v) {
        int pos = v.indexOf(44);
        if (pos == -1) {
            throw new NumberFormatException("No comma separating lat/long");
        }
        return Double.parseDouble(v.substring(pos + 1));
    }

    private static double getLatitude(String v) {
        int pos = v.indexOf(44);
        if (pos == -1) {
            throw new NumberFormatException("No comma separating lat/long");
        }
        return Double.parseDouble(v.substring(0, pos));
    }

    private boolean valid(double lat, double lon) {
        if (lat > 90.0 || lat < -90.0 || lon > 180.0 || lon < -180.0) {
            if (this.strict) {
                throw new DukeException("Position outside legal range: " + lat + ", " + lon);
            }
            return false;
        }
        return true;
    }
}

