/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.io.IOException;
import java.util.Collection;
import no.priv.garshol.duke.ConfigLoader;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.Database;
import no.priv.garshol.duke.Processor;
import no.priv.garshol.duke.utils.CommandLineParser;
import org.xml.sax.SAXException;

public abstract class AbstractCmdlineTool {
    protected Database database;
    protected Configuration config;
    protected CommandLineParser parser;
    private static final int DEFAULT_BATCH_SIZE = 40000;

    public String[] init(String[] argv, int min, int max, Collection<CommandLineParser.Option> options) throws IOException, SAXException {
        this.parser = new CommandLineParser();
        this.parser.setMinimumArguments(min);
        this.parser.setMaximumArguments(max);
        this.parser.registerOption(new CommandLineParser.BooleanOption("reindex", 'I'));
        if (options != null) {
            for (CommandLineParser.Option option : options) {
                this.parser.registerOption(option);
            }
        }
        try {
            argv = this.parser.parse(argv);
        }
        catch (CommandLineParser.CommandLineParserException e) {
            System.err.println("ERROR: " + e.getMessage());
            this.usage();
            System.exit(1);
        }
        boolean reindex = this.parser.getOptionState("reindex");
        this.config = ConfigLoader.load(argv[0]);
        this.database = this.config.getDatabase(reindex);
        if (this.database.isInMemory()) {
            reindex = true;
        }
        if (reindex) {
            AbstractCmdlineTool.reindex(this.config, this.database);
        }
        return argv;
    }

    protected abstract void usage();

    private static void reindex(Configuration config, Database database) {
        System.out.println("Reindexing all records...");
        Processor processor = new Processor(config, database);
        if (config.isDeduplicationMode()) {
            processor.index(config.getDataSources(), 40000);
        } else {
            processor.index(config.getDataSources(1), 40000);
            processor.index(config.getDataSources(2), 40000);
        }
    }
}

