/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.server;

import java.io.IOException;
import java.util.Properties;
import no.priv.garshol.duke.ConfigLoader;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.JDBCLinkDatabase;
import no.priv.garshol.duke.JNDILinkDatabase;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.Logger;
import no.priv.garshol.duke.Processor;
import no.priv.garshol.duke.RDBMSLinkDatabase;
import no.priv.garshol.duke.matchers.AbstractMatchListener;
import no.priv.garshol.duke.matchers.LinkDatabaseMatchListener;
import no.priv.garshol.duke.matchers.MatchListener;
import no.priv.garshol.duke.utils.ObjectUtils;
import no.priv.garshol.duke.utils.PropertyUtils;

public class DukeController
extends AbstractMatchListener {
    private String status = "Initialized, inactive";
    private int records;
    private int batch_size;
    private long lastCheck;
    private long lastRecord;
    private int error_factor;
    private int error_skips;
    private int last_batch_size;
    private Processor processor;
    private LinkDatabase linkdb;
    private Logger logger;

    public DukeController(Properties props) {
        String configfile = PropertyUtils.get((Properties)props, (String)"duke.configfile");
        try {
            String loggerclass = PropertyUtils.get((Properties)props, (String)"duke.logger-class", null);
            if (loggerclass != null) {
                this.logger = (Logger)ObjectUtils.instantiate((String)loggerclass);
                this.logger.debug("DukeController starting up");
            }
            Configuration config = ConfigLoader.load((String)configfile);
            this.processor = new Processor(config, false);
            this.linkdb = this.makeLinkDatabase(props);
            this.processor.addMatchListener((MatchListener)new LinkDatabaseMatchListener(config, this.linkdb));
            this.processor.addMatchListener((MatchListener)this);
            this.batch_size = PropertyUtils.get((Properties)props, (String)"duke.batch-size", (int)40000);
            this.error_factor = PropertyUtils.get((Properties)props, (String)"duke.error-wait-skips", (int)6);
            if (this.logger != null) {
                this.processor.setLogger(this.logger);
                if (this.linkdb instanceof RDBMSLinkDatabase) {
                    ((RDBMSLinkDatabase)this.linkdb).setLogger(this.logger);
                }
            }
        }
        catch (Throwable e) {
            block9: {
                if (this.processor != null) {
                    try {
                        this.processor.close();
                    }
                    catch (Exception e2) {
                        if (this.logger == null) break block9;
                        this.logger.error("Couldn't close processor", (Throwable)e2);
                    }
                }
            }
            if (this.linkdb != null) {
                this.linkdb.close();
            }
            throw new DukeException(e);
        }
    }

    public void process() {
        if (this.error_skips > 0) {
            --this.error_skips;
            return;
        }
        try {
            if (this.logger != null) {
                this.logger.debug("Starting processing");
            }
            this.status = "Processing";
            this.lastCheck = System.currentTimeMillis();
            this.processor.deduplicate(this.batch_size);
            this.status = "Sleeping";
            if (this.logger != null) {
                this.logger.debug("Finished processing");
            }
        }
        catch (Throwable e) {
            this.status = "Thread blocked on error: " + e;
            if (this.logger != null) {
                this.logger.error("Error in processing; waiting", e);
            }
            this.error_skips = this.error_factor;
        }
    }

    public void close() throws IOException {
        this.processor.close();
        this.linkdb.close();
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isErrorBlocked() {
        return this.error_skips > 0 || this.status.startsWith("Thread blocked");
    }

    public long getLastCheck() {
        return this.lastCheck;
    }

    public long getLastRecord() {
        return this.lastRecord;
    }

    public int getRecordCount() {
        return this.records;
    }

    void reportError(Throwable throwable) {
        if (this.logger != null) {
            this.logger.error("Timer reported error", throwable);
        }
        this.status = "Thread blocked on error: " + throwable;
        this.error_skips = this.error_factor;
    }

    void reportStopped() {
        this.status = "Thread stopped";
        if (this.logger != null) {
            this.logger.error("Timer thread has stopped");
        }
    }

    public void batchReady(int size) {
        this.last_batch_size = size;
    }

    public void batchDone() {
        this.linkdb.commit();
        this.records += this.last_batch_size;
        this.lastRecord = System.currentTimeMillis();
    }

    private LinkDatabase makeLinkDatabase(Properties props) {
        String dbtype = PropertyUtils.get((Properties)props, (String)"duke.linkdbtype");
        if (dbtype.equals("jdbc")) {
            return this.makeJDBCLinkDatabase(props);
        }
        if (dbtype.equals("jndi")) {
            return this.makeJNDILinkDatabase(props);
        }
        throw new DukeConfigException("Unknown link database type '" + dbtype + "'");
    }

    private LinkDatabase makeJDBCLinkDatabase(Properties props) {
        String linkjdbcuri = PropertyUtils.get((Properties)props, (String)"duke.linkjdbcuri");
        String driverklass = PropertyUtils.get((Properties)props, (String)"duke.jdbcdriver");
        String dbtype = PropertyUtils.get((Properties)props, (String)"duke.database");
        String tblprefix = PropertyUtils.get((Properties)props, (String)"duke.table-prefix", null);
        Properties jdbcprops = new Properties();
        if (PropertyUtils.get((Properties)props, (String)"duke.username", null) != null) {
            jdbcprops.put("user", PropertyUtils.get((Properties)props, (String)"duke.username"));
        }
        if (PropertyUtils.get((Properties)props, (String)"duke.password", null) != null) {
            jdbcprops.put("password", PropertyUtils.get((Properties)props, (String)"duke.password"));
        }
        JDBCLinkDatabase db = new JDBCLinkDatabase(driverklass, linkjdbcuri, dbtype, jdbcprops);
        if (tblprefix != null) {
            db.setTablePrefix(tblprefix);
        }
        db.init();
        return db;
    }

    private LinkDatabase makeJNDILinkDatabase(Properties props) {
        String tblprefix = PropertyUtils.get((Properties)props, (String)"duke.table-prefix", null);
        JNDILinkDatabase db = new JNDILinkDatabase(PropertyUtils.get((Properties)props, (String)"duke.linkjndipath"), PropertyUtils.get((Properties)props, (String)"duke.database"));
        if (tblprefix != null) {
            db.setTablePrefix(tblprefix);
        }
        db.init();
        return db;
    }
}

