# Generated by Django 2.1.11 on 2019-09-18 15:25

from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djautotask', '0008_auto_20190917_1454'),
    ]

    operations = [
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('name', models.CharField(max_length=100)),
                ('number', models.CharField(max_length=50, null=True)),
                ('description', models.CharField(max_length=2000)),
                ('actual_hours', models.DecimalField(decimal_places=2, max_digits=9, null=True)),
                ('completed_date_time', models.DateTimeField(null=True)),
                ('completed_percentage', models.PositiveSmallIntegerField(default=0)),
                ('duration', models.PositiveSmallIntegerField(default=0)),
                ('start_date_time', models.DateTimeField(null=True)),
                ('end_date_time', models.DateTimeField(null=True)),
                ('estimated_time', models.DecimalField(decimal_places=2, max_digits=9, null=True)),
                ('last_activity_date_time', models.DateTimeField(null=True)),
                ('account', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='djautotask.Account')),
                ('project_lead_resource', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='djautotask.Resource')),
            ],
            options={
                'ordering': ('-modified', '-created'),
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ProjectStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('value', models.CharField(blank=True, max_length=50, null=True)),
                ('label', models.CharField(blank=True, max_length=50, null=True)),
                ('is_default_value', models.BooleanField(default=False)),
                ('sort_order', models.PositiveSmallIntegerField(blank=True, null=True)),
                ('parent_value', models.CharField(blank=True, max_length=20, null=True)),
                ('is_active', models.BooleanField(default=False)),
                ('is_system', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name_plural': 'Project statuses',
            },
        ),
        migrations.CreateModel(
            name='ProjectType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('value', models.CharField(blank=True, max_length=50, null=True)),
                ('label', models.CharField(blank=True, max_length=50, null=True)),
                ('is_default_value', models.BooleanField(default=False)),
                ('sort_order', models.PositiveSmallIntegerField(blank=True, null=True)),
                ('parent_value', models.CharField(blank=True, max_length=20, null=True)),
                ('is_active', models.BooleanField(default=False)),
                ('is_system', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='project',
            name='status',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='djautotask.ProjectStatus'),
        ),
        migrations.AddField(
            model_name='project',
            name='type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='djautotask.ProjectType'),
        ),
        migrations.AddField(
            model_name='ticket',
            name='project',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='djautotask.Project'),
        ),
    ]
