#  Copyright 2020 Varun Kruthiventi
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from pydantic import BaseSettings


class Settings(BaseSettings):
    API_V1_STR: str = "/api/v1"
    PROJECT_NAME: str = 'krypton'
    APP_PORT: int = 7000
    APP_HOSTNAME: str = '0.0.0.0'
    APP_ROOT: str = '~/krypton'
    APP_MODEL_FOLDER = 'models'
    LOG_LEVEL: str = 'info'
    DEBUG: bool = True

    class Config:
        """Config class is used to configure env reading parameters"""
        env_prefix = 'KRYPTON_'
        case_sensitive = True


settings = Settings()
