from __future__ import with_statement, division, unicode_literals, \
    print_function, absolute_import

"""
remote job launch using the fabric package.

usage:
    example: launch firework with id 10 on lithium
        fab launch:10,lithium

Note:
    Before launching make sure that the machine to the which the
    jobs are submitted to has the proper database connection settings
    avaialable in the ~/.fireworks/my_launchpad.yaml file. If that
    file doent exist, log into that machine and run 'lpad init'. Copy
    the yaml file generated by lpad init to ~/.fireworks folder(create
    the folder if not present)

    The job will be launched from the home directory, unless
    an explicit launch directory is given using the
    firework spec '_launch_dir'(see workflow_examples)
"""

from fabric.api import settings, run


def launch(fw_id, machine='hipergator'):
    cmd = "rlaunch singleshot -f " + str(fw_id)
    if machine == 'hipergator':
        with settings(host_string='username@hipergator.rc.ufl.edu'):
            run("ssh dev1 " + cmd)
    elif machine == 'hydrogen':
        with settings(host_string='hydrogen'):
            run(cmd)
    elif machine == 'stampede':
        pass
    else:
        with settings(host_string='hydrogen'):
            run("ssh " + machine + " " + cmd)


if __name__ == '__main__':
    launch()
