# /*****************************************************************************\
#  *                        ANALYSIS PERFORMANCE TOOLS                         *
#  *                                   Extrae                                  *
#  *              Instrumentation package for parallel applications            *
#  *****************************************************************************
#  *     ___     This library is free software; you can redistribute it and/or *
#  *    /  __         modify it under the terms of the GNU LGPL as published   *
#  *   /  /  _____    by the Free Software Foundation; either version 2.1      *
#  *  /  /  /     \   of the License, or (at your option) any later version.   *
#  * (  (  ( B S C )                                                           *
#  *  \  \  \_____/   This library is distributed in hope that it will be      *
#  *   \  \__         useful but WITHOUT ANY WARRANTY; without even the        *
#  *    \___          implied warranty of MERCHANTABILITY or FITNESS FOR A     *
#  *                  PARTICULAR PURPOSE. See the GNU LGPL for more details.   *
#  *                                                                           *
#  * You should have received a copy of the GNU Lesser General Public License  *
#  * along with this library; if not, write to the Free Software Foundation,   *
#  * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA          *
#  * The GNU LEsser General Public License is contained in the file COPYING.   *
#  *                                 ---------                                 *
#  *   Barcelona Supercomputing Center - Centro Nacional de Supercomputacion   *
# \*****************************************************************************/


MPITYPE_PTOP = 50000001
MPITYPE_COLLECTIVE = 50000002
MPITYPE_OTHER = 50000003
MPITYPE_RMA = 50000004
MPITYPE_SEND_GLOBAL_SIZE = 50100001
MPITYPE_RECV_GLOBAL_SIZE = 50100002
MPITYPE_RMA_SIZE = 50001000
MPITYPE_RMA_TARGET_RANK = 50001001
MPITYPE_RMA_ORIGIN_ADDR = 50001002
MPITYPE_RMA_TARGET_DISP = 50001003
MPITYPE_COMM = MPITYPE_OTHER
MPITYPE_GROUP = MPITYPE_OTHER
MPITYPE_TOPOLOGIES = MPITYPE_OTHER
MPITYPE_TYPE = MPITYPE_OTHER
MPITYPE_IO = 50000005


MPIVal = {'MPI_END': 0, 'MPI_SEND': 1, 'MPI_RECV': 2, 'MPI_ISEND': 3, 'MPI_IRECV': 4, 'MPI_WAIT': 5, 'MPI_WAITALL': 6, 'MPI_BCAST': 7, 'MPI_BARRIER': 8, 'MPI_REDUCE': 9, 'MPI_ALLREDUCE': 10, 'MPI_ALLTOALL': 11, 'MPI_ALLTOALLV': 12, 'MPI_GATHER': 13, 'MPI_GATHERV': 14, 'MPI_SCATTER': 15, 'MPI_SCATTERV': 16, 'MPI_ALLGATHER': 17, 'MPI_ALLGATHERV': 18, 'MPI_COMM_RANK': 19, 'MPI_COMM_SIZE': 20, 'MPI_COMM_CREATE': 21, 'MPI_COMM_DUP': 22, 'MPI_COMM_SPLIT': 23, 'MPI_COMM_GROUP': 24, 'MPI_COMM_FREE': 25, 'MPI_COMM_REMOTE_GROUP': 26, 'MPI_COMM_REMOTE_SIZE': 27, 'MPI_COMM_TEST_INTER': 28, 'MPI_COMM_COMPARE': 29, 'MPI_SCAN': 30, 'MPI_INIT': 31, 'MPI_FINALIZE': 32, 'MPI_BSEND': 33, 'MPI_SSEND': 34, 'MPI_RSEND': 35, 'MPI_IBSEND': 36, 'MPI_ISSEND': 37, 'MPI_IRSEND': 38, 'MPI_TEST': 39, 'MPI_CANCEL': 40, 'MPI_SENDRECV': 41, 'MPI_SENDRECV_REPLACE': 42, 'MPI_CART_CREATE': 43, 'MPI_CART_SHIFT': 44, 'MPI_CART_COORDS': 45, 'MPI_CART_GET': 46, 'MPI_CART_MAP': 47, 'MPI_CART_RANK': 48, 'MPI_CART_SUB': 49, 'MPI_CARTDIM_GET': 50, 'MPI_DIMS_CREATE': 51, 'MPI_GRAPH_GET': 52, 'MPI_GRAPH_MAP': 53, 'MPI_GRAPH_CREATE': 54, 'MPI_GRAPH_NEIGHBORS': 55, 'MPI_GRAPHDIMS_GET': 56, 'MPI_GRAPH_NEIGHBORS_COUNT': 57, 'MPI_TOPO_TEST': 58, 'MPI_WAITANY': 59, 'MPI_WAITSOME': 60, 'MPI_PROBE': 61, 'MPI_IPROBE': 62, 'MPI_WIN_CREATE': 63, 'MPI_WIN_FREE': 64, 'MPI_PUT': 65, 'MPI_GET': 66, 'MPI_ACCUMULATE': 67, 'MPI_WIN_FENCE': 68, 'MPI_WIN_START': 69, 'MPI_WIN_COMPLETE': 70, 'MPI_WIN_POST': 71, 'MPI_WIN_WAIT': 72, 'MPI_WIN_TEST': 73, 'MPI_WIN_LOCK': 74, 'MPI_WIN_UNLOCK': 75, 'MPI_PACK': 76, 'MPI_UNPACK': 77, 'MPI_OP_CREATE': 78, 'MPI_OP_FREE': 79, 'MPI_REDUCE_SCATTER': 80, 'MPI_ATTR_DELETE': 81, 'MPI_ATTR_GET': 82, 'MPI_ATTR_PUT': 83, 'MPI_GROUP_DIFFERENCE': 84, 'MPI_GROUP_EXCL': 85, 'MPI_GROUP_FREE': 86, 'MPI_GROUP_INCL': 87, 'MPI_GROUP_INTERSECTION': 88, 'MPI_GROUP_RANK': 89, 'MPI_GROUP_RANGE_EXCL': 90, 'MPI_GROUP_RANGE_INCL': 91, 'MPI_GROUP_SIZE': 92, 'MPI_GROUP_TRANSLATE_RANKS': 93, 'MPI_GROUP_UNION': 94, 'MPI_GROUP_COMPARE': 95, 'MPI_INTERCOMM_CREATE': 96, 'MPI_INTERCOMM_MERGE': 97, 'MPI_KEYVAL_FREE': 98, 'MPI_KEYVAL_CREATE': 99, 'MPI_ABORT': 100, 'MPI_ERROR_CLASS': 101, 'MPI_ERRHANDLER_CREATE': 102, 'MPI_ERRHANDLER_FREE': 103, 'MPI_ERRHANDLER_GET': 104, 'MPI_ERROR_STRING': 105, 'MPI_ERRHANDLER_SET': 106, 'MPI_GET_PROCESSOR_NAME': 107, 'MPI_INITIALIZED': 108, 'MPI_WTICK': 109, 'MPI_WTIME': 110, 'MPI_ADDRESS': 111, 'MPI_BSEND_INIT': 112, 'MPI_BUFFER_ATTACH': 113, 'MPI_BUFFER_DETACH': 114, 'MPI_REQUEST_FREE': 115, 'MPI_RECV_INIT': 116, 'MPI_SEND_INIT': 117, 'MPI_GET_COUNT': 118, 'MPI_GET_ELEMENTS': 119, 'MPI_PACK_SIZE': 120, 'MPI_RSEND_INIT': 121, 'MPI_SSEND_INIT': 122, 'MPI_START': 123, 'MPI_STARTALL': 124, 'MPI_TESTALL': 125, 'MPI_TESTANY': 126, 'MPI_TEST_CANCELLED': 127, 'MPI_TESTSOME': 128, 'MPI_TYPE_COMMIT': 129, 'MPI_TYPE_CONTIGUOUS': 130, 'MPI_TYPE_EXTENT': 131, 'MPI_TYPE_FREE': 132, 'MPI_TYPE_HINDEXED': 133, 'MPI_TYPE_HVECTOR': 134, 'MPI_TYPE_INDEXED': 135, 'MPI_TYPE_LB': 136, 'MPI_TYPE_SIZE': 137, 'MPI_TYPE_STRUCT': 138, 'MPI_TYPE_UB': 139, 'MPI_TYPE_VECTOR': 140, 'MPI_FILE_OPEN': 141, 'MPI_FILE_CLOSE': 142, 'MPI_FILE_READ': 143, 'MPI_FILE_READ_ALL': 144, 'MPI_FILE_WRITE': 145, 'MPI_FILE_WRITE_ALL': 146, 'MPI_FILE_READ_AT': 147, 'MPI_FILE_READ_AT_ALL': 148, 'MPI_FILE_WRITE_AT': 149, 'MPI_FILE_WRITE_AT_ALL': 150, 'MPI_COMM_SPAWN': 151, 'MPI_COMM_SPAWN_MULTIPLE': 152, 'MPI_REQUEST_GET_STATUS': 153, 'MPI_IREDUCE': 154, 'MPI_IALLREDUCE': 155, 'MPI_IBARRIER': 156, 'MPI_IBCAST': 157, 'MPI_IALLTOALL': 158, 'MPI_IALLTOALLV': 159, 'MPI_IALLGATHER': 160, 'MPI_IALLGATHERV': 161, 'MPI_IGATHER': 162, 'MPI_IGATHERV': 163, 'MPI_ISCATTER': 164, 'MPI_ISCATTERV': 165, 'MPI_IREDUCESCAT': 166, 'MPI_ISCAN': 167, 'MPI_REDUCE_SCATTER_BLOCK': 168, 'MPI_IREDUCE_SCATTER_BLOCK': 169, 'MPI_ALLTOALLW': 170, 'MPI_IALLTOALLW': 171, 'MPI_GET_ACCUMULATE': 172, 'MPI_DIST_GRAPH_CREATE': 173, 'MPI_NEIGHBOR_ALLGATHER': 174, 'MPI_INEIGHBOR_ALLGATHER': 175, 'MPI_NEIGHBOR_ALLGATHERV': 176, 'MPI_INEIGHBOR_ALLGATHERV': 177, 'MPI_NEIGHBOR_ALLTOALL': 178, 'MPI_INEIGHBOR_ALLTOALL': 179, 'MPI_NEIGHBOR_ALLTOALLV': 180, 'MPI_INEIGHBOR_ALLTOALLV': 181, 'MPI_NEIGHBOR_ALLTOALLW': 182, 'MPI_INEIGHBOR_ALLTOALLW': 183, 'MPI_FETCH_AND_OP': 184, 'MPI_COMPARE_AND_SWAP': 185, 'MPI_WIN_FLUSH': 186, 'MPI_WIN_FLUSH_ALL': 187, 'MPI_WIN_FLUSH_LOCAL': 188, 'MPI_WIN_FLUSH_LOCAL_ALL': 189, 'MPI_MPROBE': 190, 'MPI_IMPROBE': 191, 'MPI_MRECV': 192, 'MPI_IMRECV': 193, 'MPI_COMM_SPLIT_TYPE': 194, 'MPI_FILE_WRITE_ALL_BEGIN': 195, 'MPI_FILE_WRITE_ALL_END': 196, 'MPI_FILE_READ_ALL_BEGIN': 197, 'MPI_FILE_READ_ALL_END': 198, 'MPI_FILE_WRITE_AT_ALL_BEGIN': 199, 'MPI_FILE_WRITE_AT_ALL_END': 200, 'MPI_FILE_READ_AT_ALL_BEGIN': 201, 'MPI_FILE_READ_AT_ALL_END': 202, 'MPI_FILE_READ_ORDERED': 203, 'MPI_FILE_READ_ORDERED_BEGIN': 204, 'MPI_FILE_READ_ORDERED_END': 205, 'MPI_FILE_READ_SHARED': 206, 'MPI_FILE_WRITE_ORDERED': 207, 'MPI_FILE_WRITE_ORDERED_BEGIN': 208, 'MPI_FILE_WRITE_ORDERED_END': 209, 'MPI_FILE_WRITE_SHARED': 210, 'MPI_COMM_DUP_WITH_INFO': 211, 'MPI_DIST_GRAPH_CREATE_ADJACENT': 212, 'MPI_COMM_CREATE_GROUP': 213, 'MPI_EXSCAN': 214, 'MPI_IEXSCAN_VAL': 215, 'MPI_FILE_GET_INFO': 216, 'MPI_FILE_GET_SIZE': 217, 'MPI_FILE_SET_VIEW': 218, 'MPI_FILE_SET_SIZE': 219}

MPI_Type_Labels = {
'MPITYPE_PTOP' : "MPI Point-to-point",
'MPITYPE_COLLECTIVE' : "MPI Collective Comm",
'MPITYPE_OTHER' : "MPI Other",
'MPITYPE_RMA' : "MPI One-sided",
'MPITYPE_RMA_SIZE' : "MPI One-sided size",
'MPITYPE_RMA_TARGET_RANK' : "MPI One,-sided target rank",
'MPITYPE_RMA_ORIGIN_ADDR' : "MPI One,-sided origin address",
'MPITYPE_RMA_TARGET_DISP' : "MPI One,-sided target displacement",
'MPITYPE_COMM' : "MPI Other",
'MPITYPE_GROUP' : "MPI Other",
'MPITYPE_TOPOLOGIES' : "MPI Other",
'MPITYPE_TYPE' : "MPI Other",
'MPITYPE_IO' : "MPI I/O"
}

MPI_Val_Labels = {
"MPIEND_LABEL" : "End",
'MPI_SEND' : "MPI_Send",
'MPI_RECV' : "MPI_Recv",
'MPI_ISEND' : "MPI_Isend",
'MPI_IRECV' : "MPI_Irecv",
'MPI_WAIT' : "MPI_Wait",
'MPI_WAITALL' : "MPI_Waitall",
'MPI_REDUCE' : "MPI_Reduce",
'MPI_ALLREDUCE' : "MPI_Allreduce",
'MPI_BARRIER' : "MPI_Barrier",
'MPI_BCAST' : "MPI_Bcast",
'MPI_ALLTOALL' : "MPI_Alltoall",
'MPI_ALLTOALLV' : "MPI_Alltoallv",
'MPI_ALLGATHER' : "MPI_Allgather",
'MPI_ALLGATHERV' : "MPI_Allgatherv",
'MPI_GATHER' : "MPI_Gather",
'MPI_GATHERV' : "MPI_Gatherv",
'MPI_SCATTER' : "MPI_Scatter",
'MPI_SCATTERV' : "MPI_Scatterv",
'MPI_REDUCE_SCATTER' : "MPI_Reduce_scatter",
'MPI_SCAN' : "MPI_Scan",
'MPI_REDUCE_SCATTER_BLOCK' : "MPI_Reduce_scatter_block",
'MPI_ALLTOALLW' : "MPI_Alltoallw",
'MPI_EXSCAN' : "MPI_Exscan",
'MPI_IREDUCE' : "MPI_Ireduce",
'MPI_IALLREDUCE' : "MPI_Iallreduce",
'MPI_IBARRIER' : "MPI_Ibarrier",
'MPI_IBCAST' : "MPI_Ibcast",
'MPI_IALLTOALL' : "MPI_Ialltoall",
'MPI_IALLTOALLV' : "MPI_Ialltoallv",
'MPI_IALLGATHER' : "MPI_Iallgather",
'MPI_IALLGATHERV' : "MPI_Iallgatherv",
'MPI_IGATHER' : "MPI_Igather",
'MPI_IGATHERV' : "MPI_Igatherv",
'MPI_ISCATTER' : "MPI_Iscatter",
'MPI_ISCATTERV' : "MPI_Iscatterv",
'MPI_IREDUCESCAT' : "MPI_Ireduce_scatter",
'MPI_ISCAN' : "MPI_Iscan",
'MPI_IREDUCE_SCATTER_BLOCK' : "MPI_Ireduce_scatter_block",
'MPI_IALLTOALLW' : "MPI_Ialltoallw",
'MPI_IEXSCAN' : "MPI_Iexscan",
'MPI_NEIGHBOR_ALLGATHER' : "MPI_Neighbor_allgather",
'MPI_INEIGHBOR_ALLGATHER' : "MPI_Ineighbor_allgather",
'MPI_NEIGHBOR_ALLGATHERV' : "MPI_Neighbor_allgatherv",
'MPI_INEIGHBOR_ALLGATHERV' : "MPI_Ineighbor_allgatherv",
'MPI_NEIGHBOR_ALLTOALL' : "MPI_Neighbor_alltoall",
'MPI_INEIGHBOR_ALLTOALL' : "MPI_Ineighbor_alltoall",
'MPI_NEIGHBOR_ALLTOALLV' : "MPI_Neighbor_alltoallv",
'MPI_INEIGHBOR_ALLTOALLV' : "MPI_Ineighbor_alltoallv",
'MPI_NEIGHBOR_ALLTOALLW' : "MPI_Neighbor_alltoallw",
'MPI_INEIGHBOR_ALLTOALLW' : "MPI_Ineighbor_alltoallw",
'MPI_INIT' : "MPI_Init",
'MPI_FINALIZE' : "MPI_Finalize",
'MPI_BSEND' : "MPI_Bsend",
'MPI_SSEND' : "MPI_Ssend",
'MPI_RSEND' : "MPI_Rsend",
'MPI_IBSEND' : "MPI_Ibsend",
'MPI_ISSEND' : "MPI_Issend",
'MPI_IRSEND' : "MPI_Irsend",
'MPI_TEST' : "MPI_Test",
'MPI_CANCEL' : "MPI_Cancel",
'MPI_SENDRECV' : "MPI_Sendrecv",
'MPI_SENDRECV_REPLACE' : "MPI_Sendrecv_replace",
'MPI_CART_CREATE' : "MPI_Cart_create",
'MPI_CART_SHIFT' : "MPI_Cart_shift",
'MPI_CART_COORDS' : "MPI_Cart_coords",
'MPI_CART_GET' : "MPI_Cart_get",
'MPI_CART_MAP' : "MPI_Cart_map",
'MPI_CART_RANK' : "MPI_Cart_rank",
'MPI_CART_SUB' : "MPI_Cart_sub",
'MPI_CARTDIM_GET' : "MPI_Cartdim_get",
'MPI_DIMS_CREATE' : "MPI_Dims_create",
'MPI_GRAPH_GET' : "MPI_Graph_get",
'MPI_GRAPH_MAP' : "MPI_Graph_map",
'MPI_GRAPH_CREATE' : "MPI_Graph_create",
'MPI_DIST_GRAPH_CREATE' : "MPI_Dist_graph_create",
'MPI_DIST_GRAPH_CREATE_ADJACENT' : "MPI_Dist_graph_create_adjacent",
'MPI_GRAPH_NEIGHBORS' : "MPI_Graph_neighbors",
'MPI_GRAPHDIMS_GET' : "MPI_Graphdims_get",
'MPI_GRAPH_NEIGHBORS_COUNT' : "MPI_Graph_neighbors_count",
'MPI_WAITANY' : "MPI_Waitany",
'MPI_TOPO_TEST' : "MPI_Topo_test",
'MPI_WAITSOME' : "MPI_Waitsome",
'MPI_PROBE' : "MPI_Probe",
'MPI_IPROBE' : "MPI_Iprobe",
'MPI_MPROBE' : "MPI_Mprobe",
'MPI_IMPROBE' : "MPI_Improbe",
'MPI_MRECV' : "MPI_Mrecv",
'MPI_IMRECV' : "MPI_Imrecv",
'MPI_WIN_CREATE' : "MPI_Win_create",
'MPI_WIN_FREE' : "MPI_Win_free",
'MPI_PUT' : "MPI_Put",
'MPI_GET' : "MPI_Get",
'MPI_ACCUMULATE' : "MPI_Accumulate",
'MPI_WIN_FENCE' : "MPI_Win_fence",
'MPI_WIN_START' : "MPI_Win_complete",
'MPI_WIN_COMPLETE' : "MPI_Win_start",
'MPI_WIN_POST' : "MPI_Win_post",
'MPI_WIN_WAIT' : "MPI_Win_wait",
'MPI_WIN_TEST' : "MPI_Win_test",
'MPI_WIN_LOCK' : "MPI_Win_lock",
'MPI_WIN_UNLOCK' : "MPI_Win_unlock",
'MPI_GET_ACCUMULATE' : "MPI_Get_accumulate",
'MPI_FETCH_AND_OP' : "MPI_Fetch_and_op",
'MPI_COMPARE_AND_SWAP' : "MPI_Compare_and_swap",
'MPI_WIN_FLUSH' : "MPI_Win_flush",
'MPI_WIN_FLUSH_ALL' : "MPI_Win_flush_all",
'MPI_WIN_FLUSH_LOCAL' : "MPI_Win_flush_local",
'MPI_WIN_FLUSH_LOCAL_ALL' : "MPI_Win_flush_local_all",
'MPI_PACK' : "MPI_Pack",
'MPI_UNPACK' : "MPI_Unpack",
'MPI_OP_CREATE' : "MPI_Op_create",
'MPI_OP_FREE' : "MPI_Op_free",
'MPI_ATTR_DELETE' : "MPI_Attr_delete",
'MPI_ATTR_GET' : "MPI_Attr_get",
'MPI_ATTR_PUT' : "MPI_Attr_put",
'MPI_COMM_RANK' : "MPI_Comm_rank",
'MPI_COMM_SIZE' : "MPI_Comm_size",
'MPI_COMM_CREATE' : "MPI_Comm_create",
'MPI_COMM_CREATE_GROUP' : "MPI_Comm_create_group",
'MPI_COMM_DUP' : "MPI_Comm_dup",
'MPI_COMM_DUP_WITH_INFO' : "MPI_Comm_dup_with_info",
'MPI_COMM_SPLIT' : "MPI_Comm_split",
'MPI_COMM_SPLIT_TYPE' : "MPI_Comm_split_type",
'MPI_COMM_SPAWN' : "MPI_Comm_spawn",
'MPI_COMM_SPAWN_MULTIPLE' : "MPI_Comm_spawn_multiple",
'MPI_COMM_GROUP' : "MPI_Comm_group",
'MPI_COMM_FREE' : "MPI_Comm_free",
'MPI_COMM_REMOTE_GROUP' : "MPI_Comm_remote_group",
'MPI_COMM_REMOTE_SIZE' : "MPI_Comm_remote_size",
'MPI_COMM_TEST_INTER' : "MPI_Comm_test_inter",
'MPI_COMM_COMPARE' : "MPI_Comm_compare",
'MPI_GROUP_DIFFERENCE' : "MPI_Group_difference",
'MPI_GROUP_EXCL' : "MPI_Group_excl",
'MPI_GROUP_FREE' : "MPI_Group_free",
'MPI_GROUP_INCL' : "MPI_Group_incl",
'MPI_GROUP_INTERSECTION' : "MPI_Group_intersection",
'MPI_GROUP_RANK' : "MPI_Group_rank",
'MPI_GROUP_RANGE_EXCL' : "MPI_Group_range_excl",
'MPI_GROUP_RANGE_INCL' : "MPI_Group_range_incl",
'MPI_GROUP_SIZE' : "MPI_Group_size",
'MPI_GROUP_TRANSLATE_RANKS' : "MPI_Group_translate_ranks",
'MPI_GROUP_UNION' : "MPI_Group_union",
'MPI_GROUP_COMPARE' : "MPI_Group_compare",
'MPI_INTERCOMM_CREATE' : "MPI_Intercomm_create",
'MPI_INTERCOMM_MERGE' : "MPI_Intercomm_merge",
'MPI_KEYVAL_FREE' : "MPI_Keyval_free",
'MPI_KEYVAL_CREATE' : "MPI_Keyval_create",
'MPI_ABORT' : "MPI_Abort",
'MPI_ERROR_CLASS' : "MPI_Error_class",
'MPI_ERRHANDLER_CREATE' : "MPI_Errhandler_create",
'MPI_ERRHANDLER_FREE' : "MPI_Errhandler_free",
'MPI_ERRHANDLER_GET' : "MPI_Errhandler_get",
'MPI_ERROR_STRING' : "MPI_Error_string",
'MPI_ERRHANDLER_SET' : "MPI_Errhandler_set",
'MPI_GET_PROCESSOR_NAME' : "MPI_Get_processor_name",
'MPI_INITIALIZED' : "MPI_Initialized",
'MPI_WTICK' : "MPI_Wtick",
'MPI_WTIME' : "MPI_Wtime",
'MPI_ADDRESS' : "MPI_Address",
'MPI_BSEND_INIT' : "MPI_Bsend_init",
'MPI_BUFFER_ATTACH' : "MPI_Buffer_attach",
'MPI_BUFFER_DETACH' : "MPI_Buffer_detach",
'MPI_REQUEST_FREE' : "MPI_Request_free",
'MPI_RECV_INIT' : "MPI_Recv_init",
'MPI_SEND_INIT' : "MPI_Send_init",
'MPI_GET_COUNT' : "MPI_Get_count",
'MPI_GET_ELEMENTS' : "MPI_Get_elements",
'MPI_PACK_SIZE' : "MPI_Pack_size",
'MPI_RSEND_INIT' : "MPI_Rsend_init",
'MPI_SSEND_INIT' : "MPI_Ssend_init",
'MPI_START' : "MPI_Start",
'MPI_STARTALL' : "MPI_Startall",
'MPI_TESTALL' : "MPI_Testall",
'MPI_TESTANY' : "MPI_Testany",
'MPI_TEST_CANCELLED' : "MPI_Test_cancelled",
'MPI_TESTSOME' : "MPI_Testsome",
'MPI_TYPE_COMMIT' : "MPI_Type_commit",
'MPI_TYPE_CONTIGUOUS' : "MPI_Type_contiguous",
'MPI_TYPE_EXTENT' : "MPI_Type_extent",
'MPI_TYPE_FREE' : "MPI_Type_free",
'MPI_TYPE_HINDEXED' : "MPI_Type_hindexed",
'MPI_TYPE_HVECTOR' : "MPI_Type_hvector",
'MPI_TYPE_INDEXED' : "MPI_Type_indexed",
'MPI_TYPE_LB' : "MPI_Type_lb",
'MPI_TYPE_SIZE' : "MPI_Type_size",
'MPI_TYPE_STRUCT' : "MPI_Type_struct",
'MPI_TYPE_UB' : "MPI_Type_ub",
'MPI_TYPE_VECTOR' : "MPI_Type_vector",
'MPI_FILE_OPEN' : "MPI_File_open",
'MPI_FILE_CLOSE' : "MPI_File_close",
'MPI_FILE_READ' : "MPI_File_read",
'MPI_FILE_READ_ALL' : "MPI_File_read_all",
'MPI_FILE_READ_ALL_BEGIN' : "MPI_File_read_all_begin",
'MPI_FILE_READ_ALL_END' : "MPI_File_read_all_end",
'MPI_FILE_READ_AT' : "MPI_File_read_at",
'MPI_FILE_READ_AT_ALL' : "MPI_File_read_at_all",
'MPI_FILE_READ_AT_ALL_BEGIN' : "MPI_File_read_at_all_begin",
'MPI_FILE_READ_AT_ALL_END' : "MPI_File_read_at_all_end",
'MPI_FILE_READ_ORDERED' : "MPI_File_read_ordered",
'MPI_FILE_READ_ORDERED_BEGIN' : "MPI_File_read_ordered_begin",
'MPI_FILE_READ_ORDERED_END' : "MPI_File_read_ordered_end",
'MPI_FILE_READ_SHARED' : "MPI_File_read_shared",
'MPI_FILE_WRITE' : "MPI_File_write",
'MPI_FILE_WRITE_ALL' : "MPI_File_write_all",
'MPI_FILE_WRITE_ALL_BEGIN' : "MPI_File_write_all_begin",
'MPI_FILE_WRITE_ALL_END' : "MPI_File_write_all_end",
'MPI_FILE_WRITE_AT' : "MPI_File_write_at",
'MPI_FILE_WRITE_AT_ALL' : "MPI_File_write_at_all",
'MPI_FILE_WRITE_AT_ALL_BEGIN' : "MPI_File_write_at_all_begin",
'MPI_FILE_WRITE_AT_ALL_END' : "MPI_File_write_at_all_end",
'MPI_FILE_WRITE_ORDERED' : "MPI_File_write_ordered",
'MPI_FILE_WRITE_ORDERED_BEGIN' : "MPI_File_write_ordered_begin",
'MPI_FILE_WRITE_ORDERED_END' : "MPI_File_write_ordered_end",
'MPI_FILE_WRITE_SHARED' : "MPI_File_write_shared",
'MPI_REQUEST_GET_STATUS' : "MPI_Request_get_status",
'MPI_FILE_GET_INFO': "MPI_File_get_info", 
'MPI_FILE_GET_SIZE': "MPI_File_get_size", 
'MPI_FILE_SET_VIEW': "MPI_File_set_view",
'MPI_FILE_SET_SIZE': "MPI_File_set_size"
}