# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FusionAuthGenericConnectorArgs', 'FusionAuthGenericConnector']

@pulumi.input_type
class FusionAuthGenericConnectorArgs:
    def __init__(__self__, *,
                 authentication_url: pulumi.Input[str],
                 connect_timeout: pulumi.Input[int],
                 read_timeout: pulumi.Input[int],
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 http_authentication_password: Optional[pulumi.Input[str]] = None,
                 http_authentication_username: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ssl_certificate_key_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FusionAuthGenericConnector resource.
        :param pulumi.Input[str] authentication_url: The fully qualified URL used to send an HTTP request to authenticate the user.
        :param pulumi.Input[int] connect_timeout: The connect timeout for the HTTP connection, in milliseconds. Value must be greater than 0.
        :param pulumi.Input[int] read_timeout: The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Connector that should be persisted.
        :param pulumi.Input[bool] debug: Determines if debug should be enabled to create an event log to assist in debugging integration errors. Defaults to false.
        :param pulumi.Input[Mapping[str, Any]] headers: An object that can hold HTTPHeader key and value pairs.
        :param pulumi.Input[str] http_authentication_password: The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_username: The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] name: The unique Connector name.
        :param pulumi.Input[str] ssl_certificate_key_id: The Id of an existing [Key](https://fusionauth.io/docs/v1/tech/apis/keys/). The X509 certificate is used for client certificate authentication in requests to the Connector.
        """
        pulumi.set(__self__, "authentication_url", authentication_url)
        pulumi.set(__self__, "connect_timeout", connect_timeout)
        pulumi.set(__self__, "read_timeout", read_timeout)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_authentication_password is not None:
            pulumi.set(__self__, "http_authentication_password", http_authentication_password)
        if http_authentication_username is not None:
            pulumi.set(__self__, "http_authentication_username", http_authentication_username)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ssl_certificate_key_id is not None:
            pulumi.set(__self__, "ssl_certificate_key_id", ssl_certificate_key_id)

    @property
    @pulumi.getter(name="authenticationUrl")
    def authentication_url(self) -> pulumi.Input[str]:
        """
        The fully qualified URL used to send an HTTP request to authenticate the user.
        """
        return pulumi.get(self, "authentication_url")

    @authentication_url.setter
    def authentication_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_url", value)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> pulumi.Input[int]:
        """
        The connect timeout for the HTTP connection, in milliseconds. Value must be greater than 0.
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: pulumi.Input[int]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> pulumi.Input[int]:
        """
        The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        """
        return pulumi.get(self, "read_timeout")

    @read_timeout.setter
    def read_timeout(self, value: pulumi.Input[int]):
        pulumi.set(self, "read_timeout", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Connector that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug should be enabled to create an event log to assist in debugging integration errors. Defaults to false.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold HTTPHeader key and value pairs.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="httpAuthenticationPassword")
    def http_authentication_password(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_password")

    @http_authentication_password.setter
    def http_authentication_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_authentication_password", value)

    @property
    @pulumi.getter(name="httpAuthenticationUsername")
    def http_authentication_username(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_username")

    @http_authentication_username.setter
    def http_authentication_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_authentication_username", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Connector name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sslCertificateKeyId")
    def ssl_certificate_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of an existing [Key](https://fusionauth.io/docs/v1/tech/apis/keys/). The X509 certificate is used for client certificate authentication in requests to the Connector.
        """
        return pulumi.get(self, "ssl_certificate_key_id")

    @ssl_certificate_key_id.setter
    def ssl_certificate_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_certificate_key_id", value)


@pulumi.input_type
class _FusionAuthGenericConnectorState:
    def __init__(__self__, *,
                 authentication_url: Optional[pulumi.Input[str]] = None,
                 connect_timeout: Optional[pulumi.Input[int]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 http_authentication_password: Optional[pulumi.Input[str]] = None,
                 http_authentication_username: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_timeout: Optional[pulumi.Input[int]] = None,
                 ssl_certificate_key_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthGenericConnector resources.
        :param pulumi.Input[str] authentication_url: The fully qualified URL used to send an HTTP request to authenticate the user.
        :param pulumi.Input[int] connect_timeout: The connect timeout for the HTTP connection, in milliseconds. Value must be greater than 0.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Connector that should be persisted.
        :param pulumi.Input[bool] debug: Determines if debug should be enabled to create an event log to assist in debugging integration errors. Defaults to false.
        :param pulumi.Input[Mapping[str, Any]] headers: An object that can hold HTTPHeader key and value pairs.
        :param pulumi.Input[str] http_authentication_password: The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_username: The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] name: The unique Connector name.
        :param pulumi.Input[int] read_timeout: The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[str] ssl_certificate_key_id: The Id of an existing [Key](https://fusionauth.io/docs/v1/tech/apis/keys/). The X509 certificate is used for client certificate authentication in requests to the Connector.
        """
        if authentication_url is not None:
            pulumi.set(__self__, "authentication_url", authentication_url)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_authentication_password is not None:
            pulumi.set(__self__, "http_authentication_password", http_authentication_password)
        if http_authentication_username is not None:
            pulumi.set(__self__, "http_authentication_username", http_authentication_username)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if ssl_certificate_key_id is not None:
            pulumi.set(__self__, "ssl_certificate_key_id", ssl_certificate_key_id)

    @property
    @pulumi.getter(name="authenticationUrl")
    def authentication_url(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified URL used to send an HTTP request to authenticate the user.
        """
        return pulumi.get(self, "authentication_url")

    @authentication_url.setter
    def authentication_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_url", value)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The connect timeout for the HTTP connection, in milliseconds. Value must be greater than 0.
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Connector that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug should be enabled to create an event log to assist in debugging integration errors. Defaults to false.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold HTTPHeader key and value pairs.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="httpAuthenticationPassword")
    def http_authentication_password(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_password")

    @http_authentication_password.setter
    def http_authentication_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_authentication_password", value)

    @property
    @pulumi.getter(name="httpAuthenticationUsername")
    def http_authentication_username(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_username")

    @http_authentication_username.setter
    def http_authentication_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_authentication_username", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Connector name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        """
        return pulumi.get(self, "read_timeout")

    @read_timeout.setter
    def read_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_timeout", value)

    @property
    @pulumi.getter(name="sslCertificateKeyId")
    def ssl_certificate_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of an existing [Key](https://fusionauth.io/docs/v1/tech/apis/keys/). The X509 certificate is used for client certificate authentication in requests to the Connector.
        """
        return pulumi.get(self, "ssl_certificate_key_id")

    @ssl_certificate_key_id.setter
    def ssl_certificate_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_certificate_key_id", value)


class FusionAuthGenericConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_url: Optional[pulumi.Input[str]] = None,
                 connect_timeout: Optional[pulumi.Input[int]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 http_authentication_password: Optional[pulumi.Input[str]] = None,
                 http_authentication_username: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_timeout: Optional[pulumi.Input[int]] = None,
                 ssl_certificate_key_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Generic Connector Resource

        A FusionAuth Generic Connector is a named object that provides configuration for allowing authentication against external systems.

        [Generic Connector API](https://fusionauth.io/docs/v1/tech/apis/connectors/generic/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthGenericConnector("example",
            authentication_url="http://mygameserver.local:7001/fusionauth-connector",
            connect_timeout=1000,
            data={
                "foo": "bar",
            },
            debug=False,
            headers={
                "foo": "bar",
                "bar": "baz",
            },
            http_authentication_password="supersecret",
            http_authentication_username="me",
            read_timeout=2000,
            ssl_certificate_key_id="00000000-0000-0000-0000-000000000678")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authentication_url: The fully qualified URL used to send an HTTP request to authenticate the user.
        :param pulumi.Input[int] connect_timeout: The connect timeout for the HTTP connection, in milliseconds. Value must be greater than 0.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Connector that should be persisted.
        :param pulumi.Input[bool] debug: Determines if debug should be enabled to create an event log to assist in debugging integration errors. Defaults to false.
        :param pulumi.Input[Mapping[str, Any]] headers: An object that can hold HTTPHeader key and value pairs.
        :param pulumi.Input[str] http_authentication_password: The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_username: The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] name: The unique Connector name.
        :param pulumi.Input[int] read_timeout: The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[str] ssl_certificate_key_id: The Id of an existing [Key](https://fusionauth.io/docs/v1/tech/apis/keys/). The X509 certificate is used for client certificate authentication in requests to the Connector.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthGenericConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Generic Connector Resource

        A FusionAuth Generic Connector is a named object that provides configuration for allowing authentication against external systems.

        [Generic Connector API](https://fusionauth.io/docs/v1/tech/apis/connectors/generic/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthGenericConnector("example",
            authentication_url="http://mygameserver.local:7001/fusionauth-connector",
            connect_timeout=1000,
            data={
                "foo": "bar",
            },
            debug=False,
            headers={
                "foo": "bar",
                "bar": "baz",
            },
            http_authentication_password="supersecret",
            http_authentication_username="me",
            read_timeout=2000,
            ssl_certificate_key_id="00000000-0000-0000-0000-000000000678")
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthGenericConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthGenericConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_url: Optional[pulumi.Input[str]] = None,
                 connect_timeout: Optional[pulumi.Input[int]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 http_authentication_password: Optional[pulumi.Input[str]] = None,
                 http_authentication_username: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_timeout: Optional[pulumi.Input[int]] = None,
                 ssl_certificate_key_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthGenericConnectorArgs.__new__(FusionAuthGenericConnectorArgs)

            if authentication_url is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_url'")
            __props__.__dict__["authentication_url"] = authentication_url
            if connect_timeout is None and not opts.urn:
                raise TypeError("Missing required property 'connect_timeout'")
            __props__.__dict__["connect_timeout"] = connect_timeout
            __props__.__dict__["data"] = data
            __props__.__dict__["debug"] = debug
            __props__.__dict__["headers"] = headers
            __props__.__dict__["http_authentication_password"] = None if http_authentication_password is None else pulumi.Output.secret(http_authentication_password)
            __props__.__dict__["http_authentication_username"] = None if http_authentication_username is None else pulumi.Output.secret(http_authentication_username)
            __props__.__dict__["name"] = name
            if read_timeout is None and not opts.urn:
                raise TypeError("Missing required property 'read_timeout'")
            __props__.__dict__["read_timeout"] = read_timeout
            __props__.__dict__["ssl_certificate_key_id"] = ssl_certificate_key_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["httpAuthenticationPassword", "httpAuthenticationUsername"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FusionAuthGenericConnector, __self__).__init__(
            'fusionauth:index/fusionAuthGenericConnector:FusionAuthGenericConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_url: Optional[pulumi.Input[str]] = None,
            connect_timeout: Optional[pulumi.Input[int]] = None,
            data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            debug: Optional[pulumi.Input[bool]] = None,
            headers: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            http_authentication_password: Optional[pulumi.Input[str]] = None,
            http_authentication_username: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            read_timeout: Optional[pulumi.Input[int]] = None,
            ssl_certificate_key_id: Optional[pulumi.Input[str]] = None) -> 'FusionAuthGenericConnector':
        """
        Get an existing FusionAuthGenericConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authentication_url: The fully qualified URL used to send an HTTP request to authenticate the user.
        :param pulumi.Input[int] connect_timeout: The connect timeout for the HTTP connection, in milliseconds. Value must be greater than 0.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Connector that should be persisted.
        :param pulumi.Input[bool] debug: Determines if debug should be enabled to create an event log to assist in debugging integration errors. Defaults to false.
        :param pulumi.Input[Mapping[str, Any]] headers: An object that can hold HTTPHeader key and value pairs.
        :param pulumi.Input[str] http_authentication_password: The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] http_authentication_username: The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        :param pulumi.Input[str] name: The unique Connector name.
        :param pulumi.Input[int] read_timeout: The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        :param pulumi.Input[str] ssl_certificate_key_id: The Id of an existing [Key](https://fusionauth.io/docs/v1/tech/apis/keys/). The X509 certificate is used for client certificate authentication in requests to the Connector.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthGenericConnectorState.__new__(_FusionAuthGenericConnectorState)

        __props__.__dict__["authentication_url"] = authentication_url
        __props__.__dict__["connect_timeout"] = connect_timeout
        __props__.__dict__["data"] = data
        __props__.__dict__["debug"] = debug
        __props__.__dict__["headers"] = headers
        __props__.__dict__["http_authentication_password"] = http_authentication_password
        __props__.__dict__["http_authentication_username"] = http_authentication_username
        __props__.__dict__["name"] = name
        __props__.__dict__["read_timeout"] = read_timeout
        __props__.__dict__["ssl_certificate_key_id"] = ssl_certificate_key_id
        return FusionAuthGenericConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationUrl")
    def authentication_url(self) -> pulumi.Output[str]:
        """
        The fully qualified URL used to send an HTTP request to authenticate the user.
        """
        return pulumi.get(self, "authentication_url")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> pulumi.Output[int]:
        """
        The connect timeout for the HTTP connection, in milliseconds. Value must be greater than 0.
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Connector that should be persisted.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def debug(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if debug should be enabled to create an event log to assist in debugging integration errors. Defaults to false.
        """
        return pulumi.get(self, "debug")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An object that can hold HTTPHeader key and value pairs.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="httpAuthenticationPassword")
    def http_authentication_password(self) -> pulumi.Output[Optional[str]]:
        """
        The HTTP basic authentication password that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_password")

    @property
    @pulumi.getter(name="httpAuthenticationUsername")
    def http_authentication_username(self) -> pulumi.Output[Optional[str]]:
        """
        The HTTP basic authentication username that is sent as part of the HTTP request for the events.
        """
        return pulumi.get(self, "http_authentication_username")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique Connector name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> pulumi.Output[int]:
        """
        The read timeout in milliseconds used when FusionAuth sends events to the Webhook.
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="sslCertificateKeyId")
    def ssl_certificate_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Id of an existing [Key](https://fusionauth.io/docs/v1/tech/apis/keys/). The X509 certificate is used for client certificate authentication in requests to the Connector.
        """
        return pulumi.get(self, "ssl_certificate_key_id")

