/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.util.Histogram;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.sam.markduplicates.ElcDuplicatesFinder;
import picard.sam.markduplicates.EstimateLibraryComplexity;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;

class ElcHashBasedDuplicatesFinder
extends ElcDuplicatesFinder {
    private int numberOfHashesInGroup = -1;
    private int minReadLenInGroup = Integer.MAX_VALUE;
    private final Map<Integer, List<EstimateLibraryComplexity.PairedReadSequence>> readsByHashInGroup = new HashMap<Integer, List<EstimateLibraryComplexity.PairedReadSequence>>();

    ElcHashBasedDuplicatesFinder(double maxDiffRate, int maxReadLength, int minIdenticalBases, OpticalDuplicateFinder opticalDuplicateFinder) {
        super(maxDiffRate, maxReadLength, minIdenticalBases, opticalDuplicateFinder);
    }

    @Override
    void searchDuplicates(List<EstimateLibraryComplexity.PairedReadSequence> sequences, Histogram<Integer> duplicationHisto, Histogram<Integer> opticalHisto) {
        this.initHashLength(sequences);
        this.fillHashValues(sequences);
        this.populateDupCandidates(sequences);
        HashSet<EstimateLibraryComplexity.PairedReadSequence> dupSet = new HashSet<EstimateLibraryComplexity.PairedReadSequence>();
        for (EstimateLibraryComplexity.PairedReadSequence lhs : sequences) {
            if (dupSet.contains(lhs)) continue;
            ArrayList<EstimateLibraryComplexity.PairedReadSequence> dupes = new ArrayList<EstimateLibraryComplexity.PairedReadSequence>();
            for (EstimateLibraryComplexity.PairedReadSequence rhs : this.getSimilarReads(lhs)) {
                if (dupSet.contains(rhs) || !this.isDuplicate(lhs, rhs)) continue;
                dupes.add(rhs);
            }
            dupSet.addAll(dupes);
            this.fillHistogram(duplicationHisto, opticalHisto, lhs, dupes);
        }
    }

    private Set<EstimateLibraryComplexity.PairedReadSequence> getSimilarReads(EstimateLibraryComplexity.PairedReadSequence pattern) {
        HashSet<EstimateLibraryComplexity.PairedReadSequence> toCheck = new HashSet<EstimateLibraryComplexity.PairedReadSequence>();
        int[][] nArrayArray = new int[][]{pattern.hashes1, pattern.hashes2};
        int n = nArrayArray.length;
        for (int i = 0; i < n; ++i) {
            int[] hashesForRead;
            for (int hash : hashesForRead = nArrayArray[i]) {
                List<EstimateLibraryComplexity.PairedReadSequence> readsWithSameHash = this.readsByHashInGroup.get(hash);
                if (readsWithSameHash.size() <= 1) continue;
                toCheck.addAll(readsWithSameHash);
            }
        }
        return toCheck;
    }

    private void populateDupCandidates(List<EstimateLibraryComplexity.PairedReadSequence> seqs) {
        this.readsByHashInGroup.clear();
        for (EstimateLibraryComplexity.PairedReadSequence prs : seqs) {
            int[][] readHashValues;
            int[][] nArrayArray = readHashValues = new int[][]{prs.hashes1, prs.hashes2};
            int n = nArrayArray.length;
            for (int i = 0; i < n; ++i) {
                int[] readHashValue;
                for (int key : readHashValue = nArrayArray[i]) {
                    List dupCandidates = this.readsByHashInGroup.computeIfAbsent(key, k -> new ArrayList());
                    dupCandidates.add(prs);
                }
            }
        }
    }

    private void fillHashValues(List<EstimateLibraryComplexity.PairedReadSequence> sequences) {
        for (EstimateLibraryComplexity.PairedReadSequence prs : sequences) {
            prs.initHashes(this.numberOfHashesInGroup, this.minIdenticalBases, this.minReadLenInGroup);
        }
    }

    private void initHashLength(List<EstimateLibraryComplexity.PairedReadSequence> sequences) {
        for (EstimateLibraryComplexity.PairedReadSequence prs : sequences) {
            int minReadLength = Math.min(Math.min(prs.read1.length, prs.read2.length), this.maxReadLength);
            int numberOfHashes = (int)((double)(minReadLength - this.minIdenticalBases) * this.maxDiffRate) + 1;
            if (numberOfHashes > this.numberOfHashesInGroup) {
                this.numberOfHashesInGroup = numberOfHashes;
            }
            if (this.minReadLenInGroup <= minReadLength) continue;
            this.minReadLenInGroup = minReadLength;
        }
    }

    private boolean isDuplicate(EstimateLibraryComplexity.PairedReadSequence lhs, EstimateLibraryComplexity.PairedReadSequence rhs) {
        int read2Length;
        if (lhs == rhs) {
            return false;
        }
        int read1Length = this.minLength(lhs.read1, rhs.read1);
        int maxErrors = (int)Math.floor((double)(read1Length + (read2Length = this.minLength(lhs.read2, rhs.read2))) * this.maxDiffRate);
        int errors = this.compareReadToRead(lhs.read1, lhs.hashes1, rhs.read1, rhs.hashes1, maxErrors);
        if (errors > maxErrors) {
            return false;
        }
        return (errors += this.compareReadToRead(lhs.read2, lhs.hashes2, rhs.read2, rhs.hashes2, maxErrors)) <= maxErrors;
    }

    private int compareReadToRead(byte[] read1, int[] hashes1, byte[] read2, int[] hashes2, int maxErrors) {
        int errors = 0;
        int minReadLength = this.minLength(read1, read2);
        for (int hashNumber = 0; hashNumber < this.numberOfHashesInGroup; ++hashNumber) {
            if (hashes1[hashNumber] == hashes2[hashNumber] || (errors += this.compareHashes(read1, read2, hashNumber)) <= maxErrors) continue;
            return errors;
        }
        if (minReadLength > this.minReadLenInGroup) {
            errors += this.compareTails(read1, read2, this.minReadLenInGroup, minReadLength);
        }
        return errors;
    }

    private int compareHashes(byte[] read1, byte[] read2, int hashNumber) {
        int errors = 0;
        for (int position = this.minIdenticalBases + hashNumber; position < this.minReadLenInGroup; position += this.numberOfHashesInGroup) {
            if (read1[position] == read2[position]) continue;
            ++errors;
        }
        return errors;
    }

    private int compareTails(byte[] read1, byte[] read2, int start, int stop) {
        int errors = 0;
        for (int i = start; i < stop; ++i) {
            if (read1[i] == read2[i]) continue;
            ++errors;
        }
        return errors;
    }
}

