/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CoordMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.illumina.parser.Range;
import picard.illumina.parser.ReadDescriptor;
import picard.illumina.parser.ReadType;

public class ReadStructure {
    public static final String PARAMETER_DOC = "A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Sample Barcode, M for molecular barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"28T8M8B8S28T\" then the sequence may be split up into four reads:\n* read one with 28 cycles (bases) of template\n* read two with 8 cycles (bases) of molecular barcode (ex. unique molecular barcode)\n* read three with 8 cycles (bases) of sample barcode\n* 8 cycles (bases) skipped.\n* read four with 28 cycles (bases) of template\nThe skipped cycles would NOT be included in an output SAM/BAM file or in read groups therein.";
    public final List<ReadDescriptor> descriptors;
    public final int totalCycles;
    public final int[] readLengths;
    public final Substructure sampleBarcodes;
    public final Substructure templates;
    public final Substructure molecularBarcode;
    public final Substructure skips;
    public final Substructure nonSkips;
    private static final String ValidTypeChars;
    private static final String ValidTypeCharsWSep;
    private static final String ReadStructureMsg;
    private static final Pattern FullPattern;
    private static final Pattern SubPattern;

    public ReadStructure(List<ReadDescriptor> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("ReadStructure does not support 0 length clusters!");
        }
        ArrayList<Range> allRanges = new ArrayList<Range>(collection.size());
        this.descriptors = Collections.unmodifiableList(collection);
        int cycles = 0;
        ArrayList<Integer> nonSkipIndicesList = new ArrayList<Integer>();
        ArrayList<Integer> sampleBarcodeIndicesList = new ArrayList<Integer>();
        ArrayList<Integer> templateIndicesList = new ArrayList<Integer>();
        ArrayList<Integer> molecularBarcodeIndicesList = new ArrayList<Integer>();
        ArrayList<Integer> skipIndicesList = new ArrayList<Integer>();
        this.readLengths = new int[collection.size()];
        int currentCycleIndex = 0;
        int descIndex = 0;
        for (ReadDescriptor desc : this.descriptors) {
            if (desc.length == 0 || desc.length < 0) {
                throw new IllegalArgumentException("ReadStructure only supports ReadDescriptor lengths > 0, found(" + desc.length + ")");
            }
            int endIndexOfRange = CoordMath.getEnd(currentCycleIndex, desc.length);
            allRanges.add(new Range(currentCycleIndex, endIndexOfRange));
            currentCycleIndex = endIndexOfRange + 1;
            this.readLengths[descIndex] = desc.length;
            cycles += desc.length;
            switch (desc.type) {
                case B: {
                    nonSkipIndicesList.add(descIndex);
                    sampleBarcodeIndicesList.add(descIndex);
                    break;
                }
                case T: {
                    nonSkipIndicesList.add(descIndex);
                    templateIndicesList.add(descIndex);
                    break;
                }
                case S: {
                    skipIndicesList.add(descIndex);
                    break;
                }
                case M: {
                    nonSkipIndicesList.add(descIndex);
                    molecularBarcodeIndicesList.add(descIndex);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported ReadType (" + (Object)((Object)desc.type) + ") encountered by IlluminaRunConfiugration!");
                }
            }
            ++descIndex;
        }
        this.totalCycles = cycles;
        this.sampleBarcodes = new Substructure(sampleBarcodeIndicesList, allRanges);
        this.templates = new Substructure(templateIndicesList, allRanges);
        this.skips = new Substructure(skipIndicesList, allRanges);
        this.molecularBarcode = new Substructure(molecularBarcodeIndicesList, allRanges);
        this.nonSkips = new Substructure(nonSkipIndicesList, allRanges);
    }

    public ReadStructure(String readStructureString) {
        this(ReadStructure.readStructureStringToDescriptors(readStructureString));
    }

    public int getNumDescriptors() {
        return this.descriptors.size();
    }

    public String toString() {
        String out = "";
        for (ReadDescriptor rd : this.descriptors) {
            out = out + rd.toString();
        }
        return out;
    }

    private static final List<ReadDescriptor> readStructureStringToDescriptors(String readStructure) {
        Matcher fullMatcher = FullPattern.matcher(readStructure);
        if (!fullMatcher.matches()) {
            throw new IllegalArgumentException(readStructure + " cannot be parsed as a ReadStructure! " + ReadStructureMsg);
        }
        Matcher subMatcher = SubPattern.matcher(readStructure);
        ArrayList<ReadDescriptor> descriptors = new ArrayList<ReadDescriptor>();
        while (subMatcher.find()) {
            ReadDescriptor rd = new ReadDescriptor(Integer.parseInt(subMatcher.group(1)), ReadType.valueOf(subMatcher.group(2)));
            descriptors.add(rd);
        }
        return descriptors;
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (this.getClass() != thatObj.getClass()) {
            return false;
        }
        ReadStructure that = (ReadStructure)thatObj;
        if (this.descriptors.size() != that.descriptors.size()) {
            return false;
        }
        for (int i = 0; i < this.descriptors.size(); ++i) {
            if (this.descriptors.get(i).equals(that.descriptors.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int res = this.descriptors.get(0).hashCode();
        for (int i = 1; i < this.descriptors.size(); ++i) {
            res *= this.descriptors.get(i).hashCode();
        }
        return res;
    }

    static {
        String validTypes = "";
        String vtWSep = "";
        boolean written = false;
        for (ReadType rt : ReadType.values()) {
            if (written) {
                vtWSep = vtWSep + ",";
            }
            validTypes = validTypes + rt.name();
            vtWSep = vtWSep + rt.name();
        }
        ValidTypeChars = validTypes;
        ValidTypeCharsWSep = vtWSep;
        ReadStructureMsg = "Read structure must be formatted as follows: <number of bases><type><number of bases><type>...<number of bases> where number of bases is a positive (NON-ZERO) integer and type is one of the following characters " + ValidTypeCharsWSep + " (e.g. 76T8B68T would denote a paired-end run with a 76 base first end an 8 base barcode followed by a 68 base second end).";
        FullPattern = Pattern.compile("^((\\d+[" + ValidTypeChars + "]{1}))+$");
        SubPattern = Pattern.compile("(\\d+)([" + ValidTypeChars + "]{1})");
    }

    private class IndexedIterator
    implements Iterator<ReadDescriptor> {
        private int index;
        private final int[] indices;

        public IndexedIterator(int[] indices) {
            this.indices = indices;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.indices.length;
        }

        @Override
        public ReadDescriptor next() {
            return ReadStructure.this.descriptors.get(this.indices[this.index++]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class Substructure
    implements Iterable<ReadDescriptor> {
        private final int numDescriptors;
        private final int[] descriptorIndices;
        private final int[] descriptorLengths;
        private final Range[] cycleIndexRanges;
        private final int totalCycles;

        public Substructure(List<Integer> descriptorIndices, List<Range> allRanges) {
            int i;
            this.numDescriptors = descriptorIndices.size();
            this.descriptorIndices = new int[this.numDescriptors];
            this.descriptorLengths = new int[this.numDescriptors];
            for (i = 0; i < descriptorIndices.size(); ++i) {
                this.descriptorIndices[i] = descriptorIndices.get(i);
                this.descriptorLengths[i] = ReadStructure.this.descriptors.get((int)this.descriptorIndices[i]).length;
            }
            this.cycleIndexRanges = new Range[this.numDescriptors];
            for (i = 0; i < this.numDescriptors; ++i) {
                this.cycleIndexRanges[i] = allRanges.get(this.descriptorIndices[i]);
            }
            int totalLength = 0;
            for (int length : this.descriptorLengths) {
                totalLength += length;
            }
            this.totalCycles = totalLength;
        }

        public ReadDescriptor get(int index) {
            return ReadStructure.this.descriptors.get(this.descriptorIndices[index]);
        }

        public boolean isEmpty() {
            return this.numDescriptors == 0;
        }

        public int length() {
            return this.numDescriptors;
        }

        public int getTotalCycles() {
            return this.totalCycles;
        }

        public int[] getIndices() {
            return this.descriptorIndices;
        }

        public int[] getDescriptorLengths() {
            return this.descriptorLengths;
        }

        public Range[] getCycleIndexRanges() {
            return this.cycleIndexRanges;
        }

        @Override
        public Iterator<ReadDescriptor> iterator() {
            return new IndexedIterator(this.descriptorIndices);
        }

        public int[] getCycles() {
            int[] cycles = new int[this.totalCycles];
            int cycleIndex = 0;
            for (Range range : this.cycleIndexRanges) {
                for (int i = range.start; i <= range.end; ++i) {
                    cycles[cycleIndex++] = i + 1;
                }
            }
            return cycles;
        }

        public ReadStructure toReadStructure() {
            ArrayList<ReadDescriptor> descriptors = new ArrayList<ReadDescriptor>(this.numDescriptors);
            for (ReadDescriptor rd : this) {
                descriptors.add(rd);
            }
            return new ReadStructure(descriptors);
        }
    }
}

