/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.illumina.parser.BaseIlluminaDataProvider;
import picard.illumina.parser.CbclData;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import picard.illumina.parser.readers.BarcodeFileReader;
import picard.illumina.parser.readers.CbclReader;

public class NewIlluminaDataProvider
extends BaseIlluminaDataProvider {
    private final CbclReader reader;
    private BarcodeFileReader barcodeReader = null;

    NewIlluminaDataProvider(List<File> cbcls, List<AbstractIlluminaPositionFileReader.PositionInfo> locs, File[] filterFiles, int lane, int tileNum, OutputMapping outputMapping, File barcodeFile) {
        super(lane, outputMapping);
        HashMap<Integer, File> filterFileMap = new HashMap<Integer, File>();
        for (File filterFile : filterFiles) {
            filterFileMap.put(NewIlluminaDataProvider.fileToTile(filterFile.getName()), filterFile);
        }
        this.reader = new CbclReader(cbcls, filterFileMap, outputMapping.getOutputReadLengths(), tileNum, locs, outputMapping.getOutputCycles(), false);
        if (barcodeFile != null) {
            this.barcodeReader = new BarcodeFileReader(barcodeFile);
        }
    }

    @Override
    public void close() {
        this.reader.clear();
        this.reader.close();
    }

    @Override
    public void seekToTile(int seekAfterFirstRead) {
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public ClusterData next() {
        CbclData cbclData = this.reader.next();
        if (cbclData == null) {
            return null;
        }
        ClusterData cluster = new ClusterData(this.outputReadTypes);
        cluster.setLane(this.lane);
        cluster.setTile(cbclData.getTile());
        if (this.barcodeReader != null) {
            cluster.setMatchedBarcode(this.barcodeReader.next());
        }
        this.addReadData(cluster, this.numReads, cbclData);
        return cluster;
    }

    public static Integer fileToTile(String fileName) {
        Matcher matcher = Pattern.compile("^s_\\d+_(\\d{1,5}).+").matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        return Integer.parseInt(matcher.group(1));
    }
}

