/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import picard.illumina.parser.BarcodeData;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.PerTileParser;
import picard.illumina.parser.readers.BarcodeFileReader;

class BarcodeParser
extends PerTileParser<BarcodeData> {
    private static final Set<IlluminaDataType> SUPPORTED_TYPES = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.Barcodes));

    public BarcodeParser(IlluminaFileMap tilesToFiles) {
        super(tilesToFiles);
    }

    public BarcodeParser(IlluminaFileMap tilesToFiles, int nextTile) {
        super(tilesToFiles, nextTile);
    }

    @Override
    protected CloseableIterator<BarcodeData> makeTileIterator(File nextTileFile) {
        return new BarcodeDataIterator(nextTileFile);
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    private static class BarcodeDataIterator
    implements CloseableIterator<BarcodeData> {
        private final BarcodeFileReader bfr;

        public BarcodeDataIterator(File file) {
            this.bfr = new BarcodeFileReader(file);
        }

        @Override
        public void close() {
            this.bfr.close();
        }

        @Override
        public boolean hasNext() {
            return this.bfr.hasNext();
        }

        @Override
        public BarcodeData next() {
            return new BarcodeData(){

                @Override
                public String getBarcode() {
                    return bfr.next();
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

