/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesFromSequence;

public class Fingerprint
extends TreeMap<HaplotypeBlock, HaplotypeProbabilities> {
    private final String sample;
    private final Path source;
    private final String info;

    public Fingerprint(String sample, Path source, String info) {
        this.sample = sample;
        this.source = source;
        this.info = info;
    }

    public String getSample() {
        return this.sample;
    }

    public Path getSource() {
        return this.source;
    }

    public String getInfo() {
        return this.info;
    }

    public String getPrintableId() {
        return this.getSample() + "@" + (this.source == null ? "" : this.source.toUri().toString()) + (this.info == null ? "" : ":" + this.info);
    }

    public void add(HaplotypeProbabilities h) {
        this.put(h.getHaplotype(), h);
    }

    public void merge(Fingerprint other) {
        HashSet haps = new HashSet();
        haps.addAll(this.keySet());
        haps.addAll(other.keySet());
        for (HaplotypeBlock haplotype : haps) {
            HaplotypeProbabilities probabilities = (HaplotypeProbabilities)this.get(haplotype);
            HaplotypeProbabilities otherProbabilities = (HaplotypeProbabilities)other.get(haplotype);
            if (probabilities == null) {
                probabilities = otherProbabilities;
                this.put(haplotype, probabilities);
                continue;
            }
            if (otherProbabilities == null) continue;
            probabilities.merge(otherProbabilities);
        }
    }

    public void filterSuspectSites() {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            HaplotypeProbabilitiesFromSequence probs;
            Map.Entry entry = iterator.next();
            HaplotypeProbabilities p = (HaplotypeProbabilities)entry.getValue();
            if (!(p instanceof HaplotypeProbabilitiesFromSequence) || !((probs = (HaplotypeProbabilitiesFromSequence)p).getLodMostProbableGenotype() >= 3.0) || !(probs.getFractionUnexpectedAlleleObs() > 0.1)) continue;
            iterator.remove();
        }
    }
}

