/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.IntervalList;
import java.io.File;
import java.util.List;
import java.util.Set;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.HsMetrics;
import picard.analysis.directed.TargetMetrics;
import picard.analysis.directed.TargetMetricsCollector;
import picard.sam.DuplicationMetrics;

public class HsMetricCollector
extends TargetMetricsCollector<HsMetrics> {
    public HsMetricCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, File perBaseCoverage, IntervalList targetIntervals, IntervalList probeIntervals, String probeSetName, int nearProbeDistance, int minimumMappingQuality, int minimumBaseQuality, boolean clipOverlappingReads, int coverageCap, int sampleSize) {
        super(accumulationLevels, samRgRecords, refFile, perTargetCoverage, perBaseCoverage, targetIntervals, probeIntervals, probeSetName, nearProbeDistance, minimumMappingQuality, minimumBaseQuality, clipOverlappingReads, coverageCap, sampleSize);
    }

    public HsMetricCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, File perBaseCoverage, IntervalList targetIntervals, IntervalList probeIntervals, String probeSetName, int nearProbeDistance, int minimumMappingQuality, int minimumBaseQuality, boolean clipOverlappingReads, boolean noSideEffects, int coverageCap, int sampleSize) {
        super(accumulationLevels, samRgRecords, refFile, perTargetCoverage, perBaseCoverage, targetIntervals, probeIntervals, probeSetName, nearProbeDistance, minimumMappingQuality, minimumBaseQuality, clipOverlappingReads, noSideEffects, coverageCap, sampleSize);
    }

    @Override
    public HsMetrics convertMetric(TargetMetrics targetMetrics) {
        HsMetrics hsMetrics = new HsMetrics();
        TargetMetricsCollector.reflectiveCopy(targetMetrics, hsMetrics, new String[]{"PROBE_SET", "PROBE_TERRITORY", "ON_PROBE_BASES", "NEAR_PROBE_BASES", "OFF_PROBE_BASES", "PCT_OFF_PROBE", "ON_PROBE_VS_SELECTED", "MEAN_PROBE_COVERAGE"}, new String[]{"BAIT_SET", "BAIT_TERRITORY", "ON_BAIT_BASES", "NEAR_BAIT_BASES", "OFF_BAIT_BASES", "PCT_OFF_BAIT", "ON_BAIT_VS_SELECTED", "MEAN_BAIT_COVERAGE"});
        hsMetrics.BAIT_DESIGN_EFFICIENCY = (double)hsMetrics.TARGET_TERRITORY / (double)hsMetrics.BAIT_TERRITORY;
        hsMetrics.PCT_USABLE_BASES_ON_BAIT = (double)hsMetrics.ON_BAIT_BASES / (double)targetMetrics.PF_BASES;
        hsMetrics.PCT_USABLE_BASES_ON_TARGET = (double)hsMetrics.ON_TARGET_BASES / (double)targetMetrics.PF_BASES;
        hsMetrics.HS_LIBRARY_SIZE = DuplicationMetrics.estimateLibrarySize(targetMetrics.PF_SELECTED_PAIRS, targetMetrics.PF_SELECTED_UNIQUE_PAIRS);
        hsMetrics.HS_PENALTY_10X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 10);
        hsMetrics.HS_PENALTY_20X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 20);
        hsMetrics.HS_PENALTY_30X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 30);
        hsMetrics.HS_PENALTY_40X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 40);
        hsMetrics.HS_PENALTY_50X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 50);
        hsMetrics.HS_PENALTY_100X = this.calculateHsPenalty(hsMetrics.HS_LIBRARY_SIZE, targetMetrics, 100);
        return hsMetrics;
    }

    private double calculateHsPenalty(Long librarySize, TargetMetrics targetMetrics, int coverageGoal) {
        double uniquePairGoalMultiplier;
        if (librarySize == null) {
            return 0.0;
        }
        double meanCoverage = (double)targetMetrics.ON_TARGET_FROM_PAIR_BASES / (double)targetMetrics.TARGET_TERRITORY;
        double fold80 = targetMetrics.FOLD_80_BASE_PENALTY;
        long pairs = targetMetrics.PF_SELECTED_PAIRS;
        long uniquePairs = targetMetrics.PF_SELECTED_UNIQUE_PAIRS;
        double onTargetPct = (double)targetMetrics.ON_TARGET_BASES / (double)targetMetrics.PF_UQ_BASES_ALIGNED;
        double pairMultiplier = uniquePairGoalMultiplier = (double)coverageGoal / meanCoverage * fold80;
        double increment = 1.0;
        boolean goingUp = uniquePairGoalMultiplier >= 1.0;
        double finalPairMultiplier = -1.0;
        for (int i = 0; i < 10000; ++i) {
            double uniquePairMultiplier = DuplicationMetrics.estimateRoi(librarySize, pairMultiplier, pairs, uniquePairs);
            if (Math.abs(uniquePairMultiplier - uniquePairGoalMultiplier) / uniquePairGoalMultiplier <= 0.001) {
                finalPairMultiplier = pairMultiplier;
                break;
            }
            if (uniquePairMultiplier > uniquePairGoalMultiplier && goingUp || uniquePairMultiplier < uniquePairGoalMultiplier && !goingUp) {
                increment /= 2.0;
                goingUp = !goingUp;
            }
            pairMultiplier += goingUp ? increment : -increment;
        }
        if (finalPairMultiplier == -1.0) {
            return -1.0;
        }
        double uniqueFraction = (double)uniquePairs * uniquePairGoalMultiplier / ((double)pairs * finalPairMultiplier);
        return 1.0 / uniqueFraction * fold80 * (1.0 / onTargetPct);
    }
}

