/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.utils;

import htsjdk.samtools.SamStreams;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.TribbleException;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.bcf2.BCFVersion;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;

public final class VCFHeaderReader {
    private VCFHeaderReader() {
    }

    public static VCFHeader readHeaderFrom(SeekableStream in) throws IOException {
        long initialPos = in.position();
        byte[] magicBytes = InputStreamUtils.readFully(VCFHeaderReader.bufferAndDecompressIfNecessary(in), BCFVersion.MAGIC_HEADER_START.length);
        in.seek(initialPos);
        if (magicBytes[0] == 35) {
            return VCFHeaderReader.readHeaderFrom(in, new VCFCodec());
        }
        if (Arrays.equals(magicBytes, BCFVersion.MAGIC_HEADER_START)) {
            return VCFHeaderReader.readHeaderFrom(in, new BCF2Codec());
        }
        throw new TribbleException.InvalidHeader("No VCF header found in " + in.getSource());
    }

    private static InputStream bufferAndDecompressIfNecessary(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        return SamStreams.isGzippedSAMFile(bis) ? new GZIPInputStream(bis) : bis;
    }

    private static <FEATURE_TYPE extends Feature, SOURCE> VCFHeader readHeaderFrom(InputStream in, FeatureCodec<FEATURE_TYPE, SOURCE> featureCodec) throws IOException {
        InputStream is = VCFHeaderReader.bufferAndDecompressIfNecessary(in);
        FeatureCodecHeader headerCodec = featureCodec.readHeader(featureCodec.makeSourceFromStream(is));
        return (VCFHeader)headerCodec.getHeaderValue();
    }
}

