/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl.compression;

import com.intel.gkl.NativeLibraryLoader;
import java.io.File;
import java.util.zip.Inflater;
import org.broadinstitute.gatk.nativebindings.NativeLibrary;

public final class IntelInflater
extends Inflater
implements NativeLibrary {
    private static final String NATIVE_LIBRARY_NAME = "gkl_compression";
    private static boolean initialized = false;
    private long lz_stream;
    private byte[] inputBuffer;
    private int inputBufferLength;
    private int inputBufferOffset;
    private boolean finished;
    private boolean nowrap;

    @Override
    public synchronized boolean load(File tempDir) {
        if (!NativeLibraryLoader.load(tempDir, NATIVE_LIBRARY_NAME)) {
            return false;
        }
        if (!initialized) {
            IntelInflater.initNative();
            initialized = true;
        }
        return true;
    }

    private static native void initNative();

    private native void resetNative(boolean var1);

    private native int inflateNative(byte[] var1, int var2, int var3);

    private native void endNative();

    public IntelInflater(boolean nowrap) {
        this.nowrap = nowrap;
    }

    public IntelInflater() {
        this(false);
    }

    @Override
    public void reset() {
        this.resetNative(this.nowrap);
        this.inputBuffer = null;
        this.inputBufferLength = 0;
        this.finished = false;
    }

    @Override
    public void setInput(byte[] b, int off, int len) throws NullPointerException {
        if (this.lz_stream == 0L) {
            this.reset();
        }
        if (b == null) {
            throw new NullPointerException("Input is null");
        }
        if (len <= 0) {
            throw new NullPointerException("Input buffer length is zero.");
        }
        this.inputBuffer = b;
        this.inputBufferOffset = off;
        this.inputBufferLength = len;
    }

    @Override
    public int inflate(byte[] b, int off, int len) {
        return this.inflateNative(b, off, len);
    }

    @Override
    public int inflate(byte[] b) {
        return this.inflateNative(b, 0, b.length);
    }

    @Override
    public boolean finished() {
        return this.finished;
    }

    @Override
    public void end() {
        if (this.lz_stream != 0L) {
            this.endNative();
            this.lz_stream = 0L;
        }
    }
}

