/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl.compression;

import com.intel.gkl.NativeLibraryLoader;
import java.io.File;
import java.util.zip.Deflater;
import org.broadinstitute.gatk.nativebindings.NativeLibrary;

public final class IntelDeflater
extends Deflater
implements NativeLibrary {
    private static final String NATIVE_LIBRARY_NAME = "gkl_compression";
    private static boolean initialized = false;
    private long lz_stream;
    private byte[] inputBuffer;
    private int inputBufferLength;
    private boolean endOfStream;
    private boolean finished;
    private int level;
    private int strategy;
    private boolean nowrap;

    @Override
    public synchronized boolean load(File tempDir) {
        if (!NativeLibraryLoader.load(tempDir, NATIVE_LIBRARY_NAME)) {
            return false;
        }
        if (!initialized) {
            IntelDeflater.initNative();
            initialized = true;
        }
        return true;
    }

    private static native void initNative();

    private native void resetNative(boolean var1);

    private native int deflateNative(byte[] var1, int var2);

    private native void endNative();

    public IntelDeflater(int level, boolean nowrap) {
        if ((level < 0 || level > 9) && level != -1) {
            throw new IllegalArgumentException("Illegal compression level");
        }
        this.level = level;
        this.nowrap = nowrap;
        this.strategy = 0;
    }

    public IntelDeflater(int level) {
        this(level, false);
    }

    public IntelDeflater() {
        this(-1, false);
    }

    @Override
    public void reset() {
        this.resetNative(this.nowrap);
        this.inputBuffer = null;
        this.inputBufferLength = 0;
        this.endOfStream = false;
        this.finished = false;
    }

    @Override
    public void setInput(byte[] b, int off, int len) throws NullPointerException {
        if (this.lz_stream == 0L) {
            this.reset();
        }
        if (b == null) {
            throw new NullPointerException("Input is null");
        }
        if (len <= 0) {
            throw new NullPointerException("Input buffer length is zero.");
        }
        this.inputBuffer = b;
        this.inputBufferLength = len;
    }

    @Override
    public void finish() {
        this.endOfStream = true;
    }

    @Override
    public int deflate(byte[] b, int off, int len) {
        return this.deflateNative(b, len);
    }

    @Override
    public boolean finished() {
        return this.finished;
    }

    @Override
    public void end() {
        if (this.lz_stream != 0L) {
            this.endNative();
            this.lz_stream = 0L;
        }
    }
}

