/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import blbutil.StringUtil;
import blbutil.Utilities;
import java.io.File;
import java.util.Arrays;
import java.util.BitSet;
import vcf.BasicMarker;
import vcf.Marker;
import vcf.VcfHeader;

public final class VcfRecGTParser {
    private final VcfHeader vcfHeader;
    private final String vcfRec;
    private final Marker marker;
    private final int nAlleles;
    private final int nSamples;
    private final int ninthTabPos;

    public VcfRecGTParser(VcfHeader vcfHeader, String string) {
        if (vcfHeader.nSamples() == 0) {
            throw new IllegalArgumentException("nSamples==0");
        }
        this.vcfHeader = vcfHeader;
        this.vcfRec = string;
        this.marker = new BasicMarker(string);
        this.nAlleles = this.marker.nAlleles();
        this.nSamples = vcfHeader.nSamples();
        this.ninthTabPos = VcfRecGTParser.ninthTabPos(string);
    }

    private static int ninthTabPos(String string) {
        int n = -1;
        for (int i = 0; i < 9; ++i) {
            if ((n = string.indexOf(9, n + 1)) != -1) continue;
            throw new IllegalArgumentException("VCF record format error: " + string);
        }
        return n;
    }

    public VcfHeader vcfHeader() {
        return this.vcfHeader;
    }

    public String vcfRecord() {
        return this.vcfRec;
    }

    public Marker marker() {
        return this.marker;
    }

    public int nAlleles() {
        return this.nAlleles;
    }

    public Samples samples() {
        return this.vcfHeader.samples();
    }

    public int nSamples() {
        return this.nSamples;
    }

    public void storeAlleles(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4, BitSet bitSet5) {
        int n = VcfRecGTParser.bitsPerAllele(this.marker);
        int n2 = this.ninthTabPos;
        int n3 = -1;
        for (int i = 0; i < this.nSamples; ++i) {
            if (n2 == -1) {
                this.throwFieldCountError();
            }
            int n4 = this.vcfHeader.unfilteredSampleIndex(i);
            while (++n3 < n4) {
                if ((n2 = this.vcfRec.indexOf(9, n2 + 1)) != -1) continue;
                this.throwFieldCountError();
            }
            int n5 = VcfRecGTParser.alEnd1(this.vcfRec, n2 + 1);
            int n6 = VcfRecGTParser.alEnd2(this.vcfRec, n5 + 1);
            int n7 = this.parseAllele(n2 + 1, n5);
            int n8 = this.parseAllele(n5 + 1, n6);
            char c = this.vcfRec.charAt(n5);
            if (c == '|') {
                bitSet5.set(i);
            }
            if (n7 == -1) {
                bitSet3.set(i);
            } else {
                VcfRecGTParser.storeAllele(bitSet, i, n, n7);
            }
            if (n8 == -1) {
                bitSet4.set(i);
            } else {
                VcfRecGTParser.storeAllele(bitSet2, i, n, n8);
            }
            n2 = this.vcfRec.indexOf(9, n6);
        }
    }

    private static int bitsPerAllele(Marker marker) {
        int n = marker.nAlleles() - 1;
        int n2 = 32 - Integer.numberOfLeadingZeros(n);
        return n2;
    }

    private static void storeAllele(BitSet bitSet, int n, int n2, int n3) {
        int n4 = n * n2;
        int n5 = 1;
        for (int i = 0; i < n2; ++i) {
            if ((n3 & n5) == n5) {
                bitSet.set(n4);
            }
            ++n4;
            n5 <<= 1;
        }
    }

    public int[] phasedAlleles() {
        int[] nArray = new int[2 * this.nSamples];
        int n = this.ninthTabPos;
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < this.nSamples; ++i) {
            if (n == -1) {
                this.throwFieldCountError();
            }
            int n4 = this.vcfHeader.unfilteredSampleIndex(i);
            while (++n2 < n4) {
                if ((n = this.vcfRec.indexOf(9, n + 1)) != -1) continue;
                this.throwFieldCountError();
            }
            int n5 = VcfRecGTParser.alEnd1(this.vcfRec, n + 1);
            int n6 = VcfRecGTParser.alEnd2(this.vcfRec, n5 + 1);
            int n7 = this.parseAllele(n + 1, n5);
            int n8 = this.parseAllele(n5 + 1, n6);
            char c = this.vcfRec.charAt(n5);
            if (c != '|' || n7 == -1 || n8 == -1) {
                String string = "Unphased or missing reference genotype at marker: " + this.marker;
                throw new IllegalArgumentException(string);
            }
            nArray[n3++] = n7;
            nArray[n3++] = n8;
            n = this.vcfRec.indexOf(9, n6);
        }
        return nArray;
    }

    private static int alEnd1(String string, int n) {
        int n2;
        if (n == string.length()) {
            VcfRecGTParser.throwGTFormatError(string, string.length());
        }
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (c == '/' || c == '|') {
                return n2;
            }
            if (c != ':' && c != '\t') continue;
            VcfRecGTParser.throwGTFormatError(string, n2 + 1);
        }
        if (n2 == string.length()) {
            VcfRecGTParser.throwGTFormatError(string, string.length());
        }
        return n2;
    }

    private static int alEnd2(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (c != ':' && c != '\t') continue;
            return n2;
        }
        return n2;
    }

    private int parseAllele(int n, int n2) {
        int n3;
        if (n == n2) {
            String string = "Missing sample allele: " + this.vcfRec;
            throw new IllegalArgumentException(string);
        }
        if (n + 1 == n2) {
            char c = this.vcfRec.charAt(n);
            if (c == '.') {
                return -1;
            }
            n3 = c - 48;
        } else {
            n3 = Integer.parseInt(this.vcfRec.substring(n, n2));
        }
        if (n3 < 0 || n3 >= this.nAlleles) {
            String string = this.vcfRec.substring(n, n2);
            String string2 = "invalid allele [" + string + "]: " + Const.nl + this.vcfRec;
            throw new IllegalArgumentException(string2);
        }
        return n3;
    }

    private static void throwGTFormatError(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("ERROR: genotype is missing allele separator:");
        stringBuilder.append(Const.nl);
        stringBuilder.append(string.substring(0, n));
        stringBuilder.append(Const.nl);
        stringBuilder.append("Exiting Program");
        stringBuilder.append(Const.nl);
        Utilities.exit(stringBuilder.toString());
    }

    private void throwFieldCountError() {
        File file = this.vcfHeader.file();
        Object[] objectArray = StringUtil.getFields(this.vcfRec, '\t');
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("VCF header line has ");
        stringBuilder.append(this.vcfHeader.nHeaderFields());
        stringBuilder.append(" fields, but data line has ");
        stringBuilder.append(objectArray.length);
        stringBuilder.append(" fields");
        stringBuilder.append(Const.nl);
        stringBuilder.append("File source: ");
        stringBuilder.append(file != null ? file.toString() : "stdin");
        stringBuilder.append(Const.nl);
        stringBuilder.append(Arrays.toString(objectArray));
        stringBuilder.append(Const.nl);
        Utilities.exit(stringBuilder.toString());
    }

    public int[][] nonMajRefIndices() {
        int n;
        int n2;
        int[] nArray = this.phasedAlleles();
        int[] nArray2 = new int[this.nAlleles];
        int[] nArray3 = nArray;
        int n3 = nArray3.length;
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = n = nArray3[n2];
            nArray2[n4] = nArray2[n4] + 1;
        }
        int n5 = 0;
        for (n3 = 1; n3 < this.nAlleles; ++n3) {
            if (nArray2[n3] <= nArray2[n5]) continue;
            n5 = n3;
        }
        int[][] nArrayArray = new int[this.nAlleles][];
        for (n2 = 0; n2 < this.nAlleles; ++n2) {
            nArrayArray[n2] = n2 == n5 ? null : new int[nArray2[n2]];
        }
        Arrays.fill(nArray2, 0);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n == n5) continue;
            int n6 = n;
            int n7 = nArray2[n6];
            nArray2[n6] = n7 + 1;
            nArrayArray[n][n7] = n2;
        }
        return nArrayArray;
    }
}

