/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.SampleFileIt;
import haplotype.HapPair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import main.Par;
import main.Pedigree;
import vcf.BasicGT;
import vcf.Data;
import vcf.GT;
import vcf.GTRec;
import vcf.GeneticMap;
import vcf.Marker;
import vcf.Markers;
import vcf.RefGT;
import vcf.Window;
import vcf.WindowIt;
import vcf.XBasicGT;

public class TargetData
implements Data {
    private final Pedigree ped;
    private int window = 0;
    private Window<GTRec> currentWindow;
    private Markers markers;
    private GTRec[] emData;
    private GT gt;
    private final WindowIt<GTRec> targWindow;
    private int cumMarkerCnt = 0;

    public static TargetData targetData(Par par, Supplier<SampleFileIt<GTRec>> supplier) {
        GeneticMap geneticMap = GeneticMap.geneticMap(par.map(), par.chromInt());
        WindowIt<GTRec> windowIt = WindowIt.newInstance(supplier, geneticMap, par.window(), par.overlap());
        TargetData targetData = new TargetData(par, windowIt);
        assert (targetData.canAdvanceWindow());
        targetData.advanceWindowCm();
        return targetData;
    }

    private TargetData(Par par, WindowIt<GTRec> windowIt) {
        this.ped = new Pedigree(windowIt.samples(), par.ped());
        this.targWindow = windowIt;
        this.currentWindow = null;
        this.markers = Markers.create(new Marker[0]);
        this.emData = new GTRec[0];
        this.gt = TargetData.targGT(windowIt.samples(), this.emData, this.ped);
    }

    private static GT targGT(Samples samples, GTRec[] gTRecArray, Pedigree pedigree) {
        BasicGT basicGT = new BasicGT(samples, gTRecArray);
        return basicGT.isGTData() ? new XBasicGT(basicGT, pedigree) : basicGT;
    }

    @Override
    public Pedigree ped() {
        return this.ped;
    }

    @Override
    public GeneticMap genMap() {
        return this.targWindow.genMap();
    }

    @Override
    public boolean lastWindowOnChrom() {
        return this.currentWindow.lastWindowOnChrom();
    }

    @Override
    public boolean canAdvanceWindow() {
        return this.targWindow.hasNext();
    }

    @Override
    public void advanceWindowCm() {
        this.currentWindow = this.targWindow.next();
        this.cumMarkerCnt += this.currentWindow.nMarkers() - this.currentWindow.overlapEnd();
        this.emData = this.currentWindow.recList().toArray(new GTRec[0]);
        this.markers = TargetData.extractMarkers(this.emData);
        this.gt = TargetData.targGT(this.targWindow.samples(), this.emData, this.ped);
        ++this.window;
    }

    private static Markers extractMarkers(GTRec[] gTRecArray) {
        Marker[] markerArray = new Marker[gTRecArray.length];
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i] = gTRecArray[i].marker();
        }
        return Markers.create(markerArray);
    }

    @Override
    public int windowIndex() {
        return this.window;
    }

    @Override
    public int targetOverlap() {
        return this.currentWindow.overlapEnd();
    }

    @Override
    public int overlap() {
        return this.currentWindow.overlapEnd();
    }

    @Override
    public int nextOverlapStart() {
        return this.currentWindow.overlapStart();
    }

    @Override
    public int nTargetMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public int nTargetMarkersSoFar() {
        return this.cumMarkerCnt;
    }

    @Override
    public Markers targetMarkers() {
        return this.markers;
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public int nMarkersSoFar() {
        return this.cumMarkerCnt;
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int targetMarkerIndex(int n) {
        if (n < 0 || n >= this.markers.nMarkers()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return n;
    }

    @Override
    public int markerIndex(int n) {
        if (n < 0 || n >= this.markers.nMarkers()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return n;
    }

    @Override
    public int nTargetSamples() {
        return this.targWindow.samples().nSamples();
    }

    @Override
    public Samples targetSamples() {
        return this.targWindow.samples();
    }

    @Override
    public int nRefSamples() {
        return 0;
    }

    @Override
    public Samples refSamples() {
        return null;
    }

    @Override
    public int nAllSamples() {
        return this.nTargetSamples();
    }

    @Override
    public Samples allSamples() {
        return this.targetSamples();
    }

    @Override
    public GT targGT() {
        return this.gt;
    }

    @Override
    public List<HapPair> restrictedRefHapPairs() {
        return new ArrayList<HapPair>();
    }

    @Override
    public List<HapPair> refHapPairs() {
        return new ArrayList<HapPair>();
    }

    @Override
    public RefGT refGT() {
        return null;
    }

    @Override
    public RefGT restrictRefGT() {
        return null;
    }

    @Override
    public void close() {
        this.targWindow.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("vcf.NonRefData");
        return stringBuilder.toString();
    }
}

